/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef STRINGLISTMODEL_H
#define STRINGLISTMODEL_H

#include <QSortFilterProxyModel>

class QStringListModel;

class StringListModel : public QSortFilterProxyModel
{
    Q_OBJECT
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(QString query
               READ query
               WRITE setQuery
               NOTIFY queryChanged)
#if (defined QML_USER_INTERFACE) && (!defined Q_WS_MAEMO_5)
    Q_PROPERTY(QString highlightColor
               READ highlightColor
               WRITE setHighlightColor)
#endif

public:
    enum Roles {
        NameRole = Qt::DisplayRole,
        QueryMatchRole = Qt::UserRole + 1,
        SectionRole
    };

    explicit StringListModel(QObject *parent = 0);
    ~StringListModel();

#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif

    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;

    QString query() const;
    void setQuery(const QString &query);

#if (defined QML_USER_INTERFACE) && (!defined Q_WS_MAEMO_5)
    QString highlightColor() const;
    void setHighlightColor(const QString &color);
#endif

public slots:
    void setStrings(const QStringList &strings);
    void addString(const QString &string);
    void removeString(const QModelIndex &index);
    void removeString(int row);
    void clear();

protected:
    QString queryMatch(QString str) const;

signals:
    void countChanged(int count);
    void queryChanged(const QString &query);
    void highlightColorChanged(const QString &color);
    
protected:
    QStringListModel *m_model;
    QString m_query;
#if (defined QML_USER_INTERFACE) && (!defined Q_WS_MAEMO_5)
    QString m_highlight;
#endif
    QHash<int, QByteArray> m_roleNames;
};

#endif // STRINGLISTMODEL_H
