/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef SETTINGS_H
#define SETTINGS_H

#include <QSettings>
#include "enums.h"

class Settings : public QSettings
{
    Q_OBJECT

    Q_PROPERTY(ScreenOrientation::Orientation screenOrientation
               READ screenOrientation
               WRITE setScreenOrientation
               NOTIFY screenOrientationChanged)
    Q_PROPERTY(int sleepTimerDuration
               READ sleepTimerDuration
               WRITE setSleepTimerDuration
               NOTIFY sleepTimerDurationChanged)
    Q_PROPERTY(QString language
               READ language
               WRITE setLanguage
               NOTIFY languageChanged)
#if (defined QML_USER_INTERFACE) && (!defined Q_WS_MAEMO_5)
    Q_PROPERTY(QString activeColor
               READ activeColor
#ifndef Q_OS_SYMBIAN
               WRITE setActiveColor
               NOTIFY activeColorChanged)
#else
               CONSTANT)
#endif
    Q_PROPERTY(QString activeColorString
               READ activeColorString
#ifndef Q_OS_SYMBIAN
               WRITE setActiveColorString
               NOTIFY activeColorStringChanged)
#else
               CONSTANT)
#endif
#endif

public:
    explicit Settings(QObject *parent = 0);
    ~Settings();

    static Settings* instance();

    ScreenOrientation::Orientation screenOrientation() const;
    void setScreenOrientation(ScreenOrientation::Orientation orientation);

    int sleepTimerDuration() const;
    void setSleepTimerDuration(int duration);

    QString language() const;
    void setLanguage(const QString &language);

#if (defined QML_USER_INTERFACE) && (!defined Q_WS_MAEMO_5)
    QString activeColor() const;
#ifndef Q_OS_SYMBIAN
    void setActiveColor(const QString &color);
#endif

    QString activeColorString() const;
#ifndef Q_OS_SYMBIAN
    void setActiveColorString(const QString &colorString);
#endif
#endif

signals:
    void screenOrientationChanged(ScreenOrientation::Orientation orientation);
    void sleepTimerEnabledChanged(bool enabled);
    void sleepTimerDurationChanged(int duration);
    void languageChanged(const QString &language);
#if (defined QML_USER_INTERFACE) && !((defined Q_WS_MAEMO_5) || (defined Q_OS_SYMBIAN))
    void activeColorChanged(const QString &color);
    void activeColorStringChanged(const QString &colorString);
#endif
    
private:
    static Settings *self;
};

#endif // SETTINGS_H
