var Subscriptions = (function() {
    var SUBSCRIPTIONS_PATH = "/subscriptions";

    var subscriptions = {
        addSubscription: function(source, sourceType, downloadEnclosures, updateInterval, onsuccess, onerror) {
            Requests.post(SUBSCRIPTIONS_PATH, JSON.stringify({"source": source, "sourceType": sourceType,
                "downloadEnclosures": downloadEnclosures, "updateInterval": updateInterval}), onsuccess, onerror);
        },

        deleteSubscription: function(id, onsuccess, onerror) {
            Requests.deleteResource(SUBSCRIPTIONS_PATH + "/" + id, onsuccess, onerror);
        },

        fetchSubscription: function(id, onsuccess, onerror) {
            Requests.get(SUBSCRIPTIONS_PATH + "/" + id, onsuccess, onerror);
        },

        fetchSubscriptions: function(offset, limit, onsuccess, onerror) {
            Requests.get(SUBSCRIPTIONSPATH + "?offset=" + (offset || 0) + "&limit=" + (limit || 0), onsucess, onerror);
        },

        setSubscriptionProperties: function(id, properties, onsuccess, onerror) {
            Requests.put(SUBSCRIPTIONS_PATH + "/" + id, JSON.stringify(properties), onsuccess, onerror);
        },

        markSubscriptionRead: function(id, isRead, onsuccess, onerror) {
            Requests.get(SUBSCRIPTIONS_PATH + "/" + id + "/" + (isRead ? "read" : "unread"), onsuccess, onerror);
        },

        markAllSubscriptionsRead: function(onsuccess, onerror) {
            Requests.get(SUBSCRIPTIONS_PATH + "/read", onsuccess, onerror);
        },

        update: function(id, onsuccess, onerror) {
            Requests.get(SUBSCRIPTIONS_PATH + "/update?id=" + id, onsuccess, onerror);
        },

        updateAll: function(onsuccess, onerror) {
            Requests.get(SUBSCRIPTIONS_PATH + "/update", onsuccess, onerror);
        },

        cancelUpdates: function(onsuccess, onerror) {
            Requests.get(SUBSCRIPTIONS_PATH + "/cancel", onsuccess, onerror);
        },

        fetchStatus: function(onsuccess, onerror) {
            Requests.get(SUBSCRIPTIONS_PATH + "/status", onsuccess, onerror);
        }
    };

    return subscriptions;
})();
