var Articles = (function() {
    var ARTICLES_PATH = "/articles";

    var articles = {
        deleteArticle: function(id, onsuccess, onerror) {
            Requests.deleteResource(ARTICLES_PATH + "/" + id, onsuccess, onerror);
        },

        fetchArticle: function(id, onsuccess, onerror) {
            Requests.get(ARTICLES_PATH + "/" + id, onsuccess, onerror);
        },

        markArticleFavourite: function(id, isFavourite, onsuccess, onerror) {
            Requests.get(ARTICLES_PATH + "/" + id + "/" + (isFavourite ? "favourite" : "unfavourite"), onsuccess,
                onerror);
        },

        markArticleRead: function(id, isRead, onsuccess, onerror) {
            Requests.get(ARTICLES_PATH + "/" + id + "/" + (isRead ? "read" : "unread"), onsuccess, onerror);
        },

        fetchArticlesForSubscription: function(subscriptionId, offset, limit, onsuccess, onerror) {
            Requests.get(ARTICLES_PATH + "?sort=date&sortDescending=true&subscriptionId=" + subscriptionId
                + "&offset=" + (offset || 0) + "&limit=" + (limit || 0), onsuccess, onerror);
        },

        searchArticles: function(query, offset, limit, onsuccess, onerror) {
            Requests.get(ARTICLES_PATH + "?sort=date&sortDescending=true&search=" + query + "&offset=" + (offset || 0)
                + "&limit=" + (limit || 0), onsuccess, onerror);
        },

        deleteReadArticles: function(expiry, onsuccess, onerror) {
            Requests.get(ARTICLES_PATH + "/deleteread", onsuccess, onerror);
        }
    };

    return articles;
})();
