/*
 * Copyright (C) 2015 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import QtQuick.Controls 1.1

ItemDelegate {
    id: root
                
    Label {
        anchors {
            left: loader.item ? loader.right : parent.left
            right: parent.right
            margins: 2
        }
        verticalAlignment: Text.AlignVCenter
        font.bold: !model.read
        color: styleData.textColor
        elide: styleData.elideMode
        text: styleData.column == 1 ? Qt.formatDateTime(styleData.value, "dd/MM/yyyy hh:mm") : styleData.value
        visible: styleData.column > 0
    }
    
    Loader {
        id: loader
        
        width: height
        anchors {
            left: parent.left
            top: parent.top
            bottom: parent.bottom
            margins: 2
        }
        sourceComponent: styleData.column == 0 ? icon : undefined
    }
    
    Component {
        id: icon
        
        Image {
            anchors.fill: parent
            source: model.favourite ? "/usr/share/icons/Lubuntu/actions/24/dialog-yes.svg" : ""
            smooth: true
        }
    }
}
