#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>
#include <QString>
#include <QColor>

namespace Ui {
    class SettingsDialog;
}

class SettingsDialog : public QDialog {
    Q_OBJECT
public:
    SettingsDialog(QWidget *parent = 0);
    ~SettingsDialog();

    void setInitialValues(QString lfmuser, bool delart, QColor npcol);
    void setInitialValues(QString lfmuser, bool delart, QColor npcol, bool traynote);

    QString getLFMUser();
    QString getLFMHash();
    bool getDelArt();
    QColor getNpCol();
    bool getTrayNote();

public slots:
    void onBtnColor();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::SettingsDialog *ui;

    QString calculateHash(QString str);

    QString lastFmUser_;
    QString lastFmHash_;
    bool delArt_;
    bool trayNote_;
    QColor npCol_;
};

#endif // SETTINGSDIALOG_H
