#include "qmpdsong.h"

QmpdSong::QmpdSong(int id, int time, QString artist, QString title, QString track, QString file, QString date, QString album)
        : id_(id), time_(time), artist_(artist), title_(title), track_(track), file_(file), date_(date), album_(album),
        nowPlaying_(false)
{
    int minutes = time_ / 60;
    int seconds = time_ % 60;
    sTime_ = QString::number(minutes) + ":" + QString::number(seconds).rightJustified(2,'0');
}

bool QmpdSong::operator< (const QmpdSong& right) {
    if ( this->artist_ == right.artist_ && this->artist_ != "" &&
         this->album_ == right.album_  && this->album_ != "" &&
         this->track_ != right.track_ ) {
        return this->track_ < right.track_;
    }
    return this->file_ < right.file_;
}
