#ifndef SONGMODEL_H
#define SONGMODEL_H

#include <QtGui>
#include "qmpdsong.h"

class SongModel : public QAbstractTableModel
{
    Q_OBJECT

public:
    SongModel();
    ~SongModel();

    void addItem(QmpdSong *song);
    void removeItem(int ind);

    // To find out row number of specific song
    // returns -1 if not found
    int onWhichRow(int songId);

    // override abstract member functions
    int rowCount ( const QModelIndex & parent = QModelIndex() ) const;
    int columnCount ( const QModelIndex & parent = QModelIndex() ) const;
    QVariant data ( const QModelIndex & index, int role = Qt::DisplayRole ) const;

    QVariant headerData ( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;

    void setNowPlaying(int rowNumber);

private:
    QList<QmpdSong*> songList;

    // Column order
    int title_, artist_, album_, track_, date_, duration_, file_;

};

#endif // SONGMODEL_H
