#ifndef FILEBROWSERTREEITEM_H
#define FILEBROWSERTREEITEM_H

#include <QList>
#include <QString>

class FileBrowserTreeItem
{
public:
    FileBrowserTreeItem(QString fullpath, FileBrowserTreeItem* parent = 0);
    ~FileBrowserTreeItem();

    void appendChild(FileBrowserTreeItem* child);

    int row() const; // on which row under parent
    int childCount() const;
    FileBrowserTreeItem* parent() const;
    FileBrowserTreeItem* child(int row);
    QString visiblePath() const;
    QString fullPath() const;

    void killChildren();

    bool isExpanded() const;
    void setExpanded(bool exp);

private:
    FileBrowserTreeItem* parent_;
    QList<FileBrowserTreeItem*> children_;

    QString fullPathname_;
    QString visiblePathname_;

    bool expanded_;

};

#endif // FILEBROWSERTREEITEM_H
