#ifndef FILEBROWSERTREEMODEL_H
#define FILEBROWSERTREEMODEL_H

#include <QObject>
#include <QAbstractItemModel>
#include <QVariant>
#include <QString>
#include <QList>
#include <QPair>
#include <QStringList>

#include "filebrowsertreeitem.h"

typedef QList<QPair<QString, QStringList> > MyTreeType;

class FileBrowserTreeModel : public QAbstractItemModel
{
    Q_OBJECT

public:
    FileBrowserTreeModel(QObject *parent);
    ~FileBrowserTreeModel();

    QVariant data(const QModelIndex &index, int role) const;
    Qt::ItemFlags flags(const QModelIndex &index) const;
    QVariant headerData(int section, Qt::Orientation orientation,
                        int role = Qt::DisplayRole) const;
    QModelIndex index(int row, int column,
                      const QModelIndex &parent = QModelIndex()) const;
    QModelIndex parent(const QModelIndex &index) const;
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    int columnCount(const QModelIndex &parent = QModelIndex()) const;

    void setDirTree(MyTreeType &tree);

private:
    FileBrowserTreeItem *rootItem_;

    // Helper function
    FileBrowserTreeItem* findItem(FileBrowserTreeItem* parent, QString fullpath) const;

};

#endif // FILEBROWSERTREEMODEL_H
