#include <QUrl>
#include <QtGui>
#include <QtNetwork>
#include <QtXml>
#include "coverfetcher.h"

CoverFetcher::CoverFetcher() : success_(false)
{
}

//
// Set album and artist
//
void CoverFetcher::setAlbumArtist(QString artist, QString album) {
    artist_ = artist;
    album_ = album;
}

//
// Run thread..
//
void CoverFetcher::run() {
    fetch();
    emit finished(success_);
}

//
// Fetcher method
//
void CoverFetcher::fetch()
{
    success_ = false;

    // If coverart already exists, we don't need to fetch it
    QString artFilename = QDir::homePath() + "/.config/cutempc/coverart/" + QString(artist_).remove(' ').remove('/').remove('\\')
        + "_" + QString(album_).remove(' ').remove('/').remove('\\') + ".jpg";
    if (QFile::exists(artFilename)) {
        success_ = true;
        return;
    }

    QUrl url;
    url.setScheme( "http" );
    url.setHost( "ws.audioscrobbler.com" );
    url.setPath( "/2.0/" );
    url.addQueryItem( "method", "album.getinfo" );
    url.addQueryItem( "api_key", "38a1c929f8af58400ee6ed3354ea07ab" );
    url.addQueryItem( "album", album_);

    if ( artist_.size() )
        url.addQueryItem( "artist", artist_);

//    qDebug() << url;

    // Fetch xml from url
    QString tmpXmlFilename = QDir::homePath() + "/.config/cutempc/xml__tmp.xml";
    download(url, tmpXmlFilename);
    QFile file(tmpXmlFilename);
    if ( !file.open(QIODevice::ReadOnly | QIODevice::Text) ) {
        return;
    }

    QString m_xml = "";
    while (!file.atEnd()) {
        QByteArray line = file.readLine();
        m_xml += (line);
    }

    QDomDocument doc;
    if( !doc.setContent( m_xml ) )
    {
        return;
    }

    const QDomNodeList list = doc.documentElement().namedItem( "album" ).childNodes();
    QString size = "extralarge";

    QString coverUrl;
    for( int i = 0; i < list.count(); i++ )
    {
        QDomNode n = list.item( i );
        if( n.nodeName() == "image" )
        {
            const QDomNode node = list.item( i );

            if ( node.hasAttributes() ) {
                const QString imageSize = node.attributes().namedItem( "size" ).nodeValue();
                if ( imageSize == size && node.isElement() ) {
                    coverUrl = node.toElement().text();
                }
            }
        }
    }

    if ( coverUrl.isEmpty() ) {
        // Not found
        return;
    }

    // Fetch image from coverUrl
    QUrl coverUrl2 = QUrl(coverUrl);
    download(coverUrl2, artFilename);

    //image loaded successfully yay!
    success_ = true;
}

//
// Downloads file from 'url' to 'filename'
//
void CoverFetcher::download(const QUrl &url, const QString &filename)
{
    QNetworkAccessManager manager;
    QEventLoop loop;
    QNetworkReply *reply = manager.get(QNetworkRequest(url));
    QObject::connect(reply, SIGNAL(finished()), &loop, SLOT(quit()));

    loop.exec();

    QFile file(filename);

    // If the source directory doesn't exist, we have to create it
    QDir dir(QDir::root());
    QStringList sl = filename.split('/');
    for (int i = 1; i < sl.count()-1 ; ++i) {
        QString s = sl.at(i);
        if ( !dir.cd(s) ) {
            dir.mkdir(s);
            dir.cd(s);
        }
    }
    if ( !file.open(QIODevice::WriteOnly) ) {
        //qDebug() << "*** [RUNTIME ERROR in function CoverFetcher::download] Unable to write to file " << filename;
        delete reply;
        return;
    }
    file.write(reply->readAll());

    delete reply;

}
