/*
 * connui-cellular-operator-home-item-custom - Replacement operator name widget allowing you to put your own text there
 *
 * Copyright (c) 2009 Faheem Pervez <trippin1@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *      
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *      
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * Using HeColor, by Andrew Olmsted.
 *
 */

#include <glib.h>
#include <libintl.h>
#include <locale.h>
#include <libosso.h>
#include <gconf/gconf-client.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include "he-color-button.h"
#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>

#include "../desktopsrc/connui-cellular-operator-home-item-custom-settings.h"

typedef GdkColor GdkColour;

typedef struct _user_data_t user_data_t;

struct _user_data_t
{
  GtkWidget *dialog;

  GtkWidget *radio_online, *radio_connecting, *radio_offline;

  GtkWidget *operator_online_text_entry_caption, *operator_connecting_text_entry_caption, *operator_offline_text_entry_caption;

  GtkWidget *operator_online_colour_button_caption, *operator_connecting_colour_button_caption, *operator_offline_colour_button_caption;
  GtkWidget *operator_online_shadow_button_caption, *operator_connecting_shadow_button_caption, *operator_offline_shadow_button_caption;
  GdkColour operator_colour;

  GConfClient *gconf_client;
};

static void hide_show_on_toggled (GtkWidget *togglebutton, user_data_t *data)
{
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->radio_online)))
  {
    gtk_widget_hide_all (data->operator_connecting_text_entry_caption);
    gtk_widget_hide_all (data->operator_connecting_colour_button_caption);
    gtk_widget_hide_all (data->operator_connecting_shadow_button_caption);
    gtk_widget_hide_all (data->operator_offline_text_entry_caption);
    gtk_widget_hide_all (data->operator_offline_colour_button_caption);
    gtk_widget_hide_all (data->operator_offline_shadow_button_caption);
    gtk_widget_show_all (data->operator_online_text_entry_caption);
    gtk_widget_show_all (data->operator_online_colour_button_caption);
    gtk_widget_show_all (data->operator_online_shadow_button_caption);
  }
  else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(data->radio_connecting)))
  {
    gtk_widget_hide_all (data->operator_online_text_entry_caption);
    gtk_widget_hide_all (data->operator_online_colour_button_caption);
    gtk_widget_hide_all (data->operator_online_shadow_button_caption);
    gtk_widget_hide_all (data->operator_offline_text_entry_caption);
    gtk_widget_hide_all (data->operator_offline_colour_button_caption);
    gtk_widget_hide_all (data->operator_offline_shadow_button_caption);
    gtk_widget_show_all (data->operator_connecting_text_entry_caption);
    gtk_widget_show_all (data->operator_connecting_colour_button_caption);
    gtk_widget_show_all (data->operator_connecting_shadow_button_caption);
  }
  else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(data->radio_offline)))
  {
    gtk_widget_hide_all (data->operator_online_text_entry_caption);
    gtk_widget_hide_all (data->operator_online_colour_button_caption);
    gtk_widget_hide_all (data->operator_online_shadow_button_caption);
    gtk_widget_hide_all (data->operator_connecting_text_entry_caption);
    gtk_widget_hide_all (data->operator_connecting_colour_button_caption);
    gtk_widget_hide_all (data->operator_connecting_shadow_button_caption);
    gtk_widget_show_all (data->operator_offline_text_entry_caption);
    gtk_widget_show_all (data->operator_offline_colour_button_caption);
    gtk_widget_show_all (data->operator_offline_shadow_button_caption);
  }
}

static GtkWidget* setup_buttons_on_frame (GtkWidget *group_from_widget, user_data_t *data, gchar *label, GtkWidget *hbox)
{
  GtkWidget *toggle_button;

  toggle_button = group_from_widget ? hildon_gtk_radio_button_new_from_widget (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, GTK_RADIO_BUTTON (group_from_widget)) : hildon_gtk_radio_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, NULL);
  g_signal_connect (toggle_button, "toggled", G_CALLBACK (hide_show_on_toggled), data);
  gtk_button_set_label (GTK_BUTTON (toggle_button), label);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (toggle_button), FALSE);
  gtk_container_add (GTK_CONTAINER (hbox), toggle_button);
  
  return toggle_button;
}

static void add_frame_and_buttons_to_dialog (user_data_t *data)
{
  GtkWidget *phone_state_frame;
  GtkWidget *phone_state_hbox;

  phone_state_frame = gtk_frame_new ("Settings for phone state:");

  phone_state_hbox = gtk_hbox_new (FALSE, 0);

  data->radio_online = setup_buttons_on_frame (NULL, data, "Online", phone_state_hbox);
  data->radio_connecting = setup_buttons_on_frame (data->radio_online, data, "Connecting", phone_state_hbox);
  data->radio_offline = setup_buttons_on_frame (data->radio_connecting, data, "Offline", phone_state_hbox);

  gtk_container_add (GTK_CONTAINER (phone_state_frame), phone_state_hbox);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG(data->dialog)->vbox), phone_state_frame);

  gtk_widget_show_all (phone_state_frame);
}

static GtkWidget* setup_hildon_entries_on_dialog (user_data_t *data, gchar *gconf_key)
{
  gchar *gconf_val = NULL;
  GtkWidget *name_text_entry;
  GtkWidget *caption;

  gconf_val = gconf_client_get_string (data->gconf_client, gconf_key, NULL);

  name_text_entry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
  gtk_entry_set_text (GTK_ENTRY (name_text_entry), gconf_val);
  g_free (gconf_val);
  caption = hildon_caption_new (NULL, "Displayed text:", name_text_entry, NULL, HILDON_CAPTION_MANDATORY);
  hildon_caption_set_separator (HILDON_CAPTION (caption), "");
  return caption;
}

static void add_inputs_to_dialog (user_data_t *data)
{
  data->operator_online_text_entry_caption = setup_hildon_entries_on_dialog (data, CONNUI_CELLULAR_OPERATOR_HOME_ITEM_ONLINE_NAME_KEY);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (data->dialog)->vbox), data->operator_online_text_entry_caption);

  data->operator_connecting_text_entry_caption = setup_hildon_entries_on_dialog (data, CONNUI_CELLULAR_OPERATOR_HOME_ITEM_CONNECTING_NAME_KEY);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (data->dialog)->vbox), data->operator_connecting_text_entry_caption);

  data->operator_offline_text_entry_caption = setup_hildon_entries_on_dialog (data, CONNUI_CELLULAR_OPERATOR_HOME_ITEM_OFFLINE_NAME_KEY);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (data->dialog)->vbox), data->operator_offline_text_entry_caption);

  gtk_widget_show_all (data->operator_online_text_entry_caption);
}

static GtkWidget* setup_he_colour_button_on_dialog (user_data_t *data, gchar *gconf_key, gboolean shadow)
{
  GtkWidget *operator_colour_button;
  GtkWidget *caption;
  gchar *gconf_val = NULL;

  gconf_val = gconf_client_get_string (data->gconf_client, gconf_key, NULL);
  if (!gconf_val || *gconf_val == '\0')
    gconf_val = g_strdup (shadow ? CONNUI_CELLULAR_OPERATOR_HOME_ITEM_DEFAULT_SHADOW_COLOUR : CONNUI_CELLULAR_OPERATOR_HOME_ITEM_DEFAULT_COLOUR);

  operator_colour_button = he_color_button_new();
  hildon_gtk_widget_set_theme_size (operator_colour_button, HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
  gdk_color_parse (gconf_val, &data->operator_colour);
  g_free (gconf_val);
  he_color_button_set_color (HE_COLOR_BUTTON (operator_colour_button), &data->operator_colour);
  caption = hildon_caption_new (NULL, shadow ? "Shadow colour:" : "Text colour:    ", operator_colour_button, NULL, HILDON_CAPTION_MANDATORY);
  hildon_caption_set_separator (HILDON_CAPTION (caption), "");
  return caption;
}

static void add_colour_selection_to_dialog (user_data_t *data)
{
  data->operator_online_colour_button_caption = setup_he_colour_button_on_dialog (data, CONNUI_CELLULAR_OPERATOR_HOME_ITEM_ONLINE_COLOUR_KEY, FALSE);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (data->dialog)->vbox), data->operator_online_colour_button_caption);

  data->operator_connecting_colour_button_caption = setup_he_colour_button_on_dialog (data, CONNUI_CELLULAR_OPERATOR_HOME_ITEM_CONNECTING_COLOUR_KEY, FALSE);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (data->dialog)->vbox), data->operator_connecting_colour_button_caption);

  data->operator_offline_colour_button_caption = setup_he_colour_button_on_dialog (data, CONNUI_CELLULAR_OPERATOR_HOME_ITEM_OFFLINE_COLOUR_KEY, FALSE);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (data->dialog)->vbox), data->operator_offline_colour_button_caption);

  gtk_widget_show_all (data->operator_online_colour_button_caption);
}

static void add_shadow_selection_to_dialog (user_data_t *data)
{
  data->operator_online_shadow_button_caption = setup_he_colour_button_on_dialog (data, CONNUI_CELLULAR_OPERATOR_HOME_ITEM_ONLINE_SHADOW_KEY, TRUE);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (data->dialog)->vbox), data->operator_online_shadow_button_caption);

  data->operator_connecting_shadow_button_caption = setup_he_colour_button_on_dialog (data, CONNUI_CELLULAR_OPERATOR_HOME_ITEM_CONNECTING_SHADOW_KEY, TRUE);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (data->dialog)->vbox), data->operator_connecting_shadow_button_caption);

  data->operator_offline_shadow_button_caption = setup_he_colour_button_on_dialog (data, CONNUI_CELLULAR_OPERATOR_HOME_ITEM_OFFLINE_SHADOW_KEY, TRUE);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (data->dialog)->vbox), data->operator_offline_shadow_button_caption);

  gtk_widget_show_all (data->operator_online_shadow_button_caption);
}

static void save_operator_names (user_data_t *data)
{
  gconf_client_set_string (data->gconf_client, CONNUI_CELLULAR_OPERATOR_HOME_ITEM_ONLINE_NAME_KEY, gtk_entry_get_text( GTK_ENTRY(gtk_bin_get_child( GTK_BIN(data->operator_online_text_entry_caption)))), NULL);
  gconf_client_set_string (data->gconf_client, CONNUI_CELLULAR_OPERATOR_HOME_ITEM_CONNECTING_NAME_KEY, gtk_entry_get_text( GTK_ENTRY(gtk_bin_get_child( GTK_BIN(data->operator_connecting_text_entry_caption)))), NULL);
  gconf_client_set_string (data->gconf_client, CONNUI_CELLULAR_OPERATOR_HOME_ITEM_OFFLINE_NAME_KEY, gtk_entry_get_text( GTK_ENTRY(gtk_bin_get_child( GTK_BIN(data->operator_offline_text_entry_caption)))), NULL);
}

static void save_colours (user_data_t *data, GtkWidget *from_widget, gchar *gconf_key)
{
  gchar *colour = NULL;

  he_color_button_get_color (HE_COLOR_BUTTON (gtk_bin_get_child(GTK_BIN (from_widget))), &data->operator_colour);
  colour = gdk_color_to_string (&data->operator_colour);
  gconf_client_set_string (data->gconf_client, gconf_key, colour, NULL);
  g_free (colour);
}

static void handle_dialog_quit (user_data_t *data)
{
  save_operator_names(data);

  save_colours (data, data->operator_online_colour_button_caption, CONNUI_CELLULAR_OPERATOR_HOME_ITEM_ONLINE_COLOUR_KEY);
  save_colours (data, data->operator_connecting_colour_button_caption, CONNUI_CELLULAR_OPERATOR_HOME_ITEM_CONNECTING_COLOUR_KEY);
  save_colours (data, data->operator_offline_colour_button_caption, CONNUI_CELLULAR_OPERATOR_HOME_ITEM_OFFLINE_COLOUR_KEY);

  save_colours (data, data->operator_online_shadow_button_caption, CONNUI_CELLULAR_OPERATOR_HOME_ITEM_ONLINE_SHADOW_KEY);
  save_colours (data, data->operator_connecting_shadow_button_caption, CONNUI_CELLULAR_OPERATOR_HOME_ITEM_CONNECTING_SHADOW_KEY);
  save_colours (data, data->operator_offline_shadow_button_caption, CONNUI_CELLULAR_OPERATOR_HOME_ITEM_OFFLINE_SHADOW_KEY);
}

osso_return_t execute(osso_context_t *osso, gpointer user_data, gboolean user_activated)
{
  user_data_t *data = g_new0 (user_data_t, 1);
  gint response;
  
  g_return_val_if_fail (data != NULL, OSSO_ERROR);

  data->gconf_client = gconf_client_get_default ();

  setlocale (LC_ALL, "");

  data->dialog = gtk_dialog_new_with_buttons ("Custom Operator Name Settings:", GTK_WINDOW (user_data), GTK_DIALOG_MODAL | GTK_DIALOG_NO_SEPARATOR, dgettext ("hildon-libs", "wdgt_bd_save"), GTK_RESPONSE_OK, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL);

  add_frame_and_buttons_to_dialog (data);
  add_inputs_to_dialog (data);
  add_colour_selection_to_dialog (data);
  add_shadow_selection_to_dialog (data);

  response = gtk_dialog_run (GTK_DIALOG (data->dialog));
  if (response == GTK_RESPONSE_OK)
    handle_dialog_quit (data);

  gtk_widget_destroy (data->dialog);

  g_object_unref (data->gconf_client);
  g_free (data);

  return OSSO_OK;
}

