#include "help.h"
#include "ui_help.h"

Help::Help(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::Help)
{
    ui->setupUi(this);

    mvSettings.sync();
    QString helpFile = mvSettings.value("Help").toString();
    if (helpFile == "CurrencyEdit") {
        ui->textBrowser->setSource(QUrl("qrc:/docs/edit.html"));
    }  else if (helpFile == "CurrencySettings") {
        ui->textBrowser->setSource(QUrl("qrc:/docs/currency.html"));
    }  else if (helpFile == "UnitSettings") {
        ui->textBrowser->setSource(QUrl("qrc:/docs/unit.html"));
    } else {
        ui->textBrowser->setSource(QUrl("qrc:/docs/main.html"));
    }

}

Help::~Help()
{
    delete ui;
}

void Help::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
