#include "currencyedit.h"
#include "ui_currencyedit.h"

CurrencyEdit::CurrencyEdit(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::CurrencyEdit)
{
    ui->setupUi(this);
    mvPegged = true;
    updateList();
    ui->lineEdit_rate->setValidator(new QDoubleValidator(0, 9999999, 6, this));
    ui->labelRate->setText("Set the rate for 1 Euro");
}

CurrencyEdit::~CurrencyEdit()
{
    delete ui;
}

void CurrencyEdit::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void CurrencyEdit::updateList()
{
    mvSettings.beginGroup("Currency");
    QStringList allCurrencies = mvSettings.allKeys();
    QString currencyName;
    QStringList currencyNames;
    mvSettings.endGroup();

    mvSettings.beginGroup("CurrencyName");
    foreach (QString currency, allCurrencies) {
        currencyName = currency + " - " + mvSettings.value(currency).toString();
        currencyNames += currencyName;
    }
    mvSettings.endGroup();

    ui->listWidget->clear();
    ui->listWidget->addItems(currencyNames);
}

void CurrencyEdit::clearFields()
{
    ui->lineEdit_currency->clear();
    ui->lineEdit_description->clear();
    ui->lineEdit_rate->clear();
}

void CurrencyEdit::on_listWidget_clicked(QModelIndex index)
{
    QString selection = ui->listWidget->currentItem()->text().left(3);

    ui->lineEdit_currency->setText(selection);
    ui->lineEdit_description->setText(mvSettings.value("CurrencyName/" + selection).toString());
    ui->lineEdit_rate->setText(mvSettings.value("Currency/" + selection).toString());
    ui->pushButton_Add->setText("Modify");
    ui->labelRate->setText("Set the rate for 1 Euro");
    if (mvSettings.contains("CurrencyPeggedUSD/" + selection)) {
        mvPegged = true;
        ui->checkBox_Pegged->setChecked(true);
        ui->lineEdit_rate->setText(mvSettings.value("CurrencyPeggedUSD/" + selection).toString());
        ui->labelRate->setText("Set the rate for 1 US Dollar");
    }
}

void CurrencyEdit::on_pushButton_Add_clicked()
{
    QString currency = ui->lineEdit_currency->text();
    QString description = ui->lineEdit_description->text();
    double rate = ui->lineEdit_rate->text().toDouble();
    double usd = mvSettings.value("Currency/USD").toDouble();
    double rateEuro;

    if (currency != "EUR") {
        if (mvPegged) {
            rateEuro = rate * usd;
            mvSettings.setValue("CurrencyPeggedUSD/" + currency, rate);
            mvSettings.setValue("Currency/" + currency, rateEuro);
        } else {
            mvSettings.setValue("Currency/" + currency, rate);
        }
        mvSettings.setValue("CurrencyName/" + currency, description);
        updateList();
        clearFields();
        mvPegged = false;
        ui->checkBox_Pegged->setChecked(false);
        ui->pushButton_Add->setText("Add");
    }
}

void CurrencyEdit::on_pushButton_Remove_clicked()
{
    QString currency = ui->lineEdit_currency->text();

    if (currency != "EUR" and currency != "USD" and currency != "") {
        mvSettings.remove("CurrencyName/" + currency);
        mvSettings.remove("Currency/" + currency);
        if (mvPegged) {
           mvSettings.remove("CurrencyPeggedUSD/" + currency);
        }
        if  (mvSettings.value("Currency1") == currency) {
            mvSettings.setValue("Currency1", "EUR");
        }
        if  (mvSettings.value("Currency2") == currency) {
            mvSettings.setValue("Currency2", "EUR");
        }

        QString keyHome;
        QString keyForeign;
        QString presetHome;
        QString presetForeign;
        int countPreset = mvSettings.value("CurrencyPreset").toInt();

        mvSettings.beginGroup("CurrencyPreset");
        for (int current = 0; current < countPreset; current++) {
            keyHome = QString::number(current) + "Home";
            keyForeign = QString::number(current) + "Foreign";
            presetHome = mvSettings.value(keyHome).toString();
            presetForeign = mvSettings.value(keyForeign).toString();
            if (presetHome == currency) {
                mvSettings.setValue(keyHome, "EUR");
            } else if (presetForeign == currency) {
                mvSettings.setValue(keyForeign, "EUR");
            }
        }
        mvSettings.endGroup();

        updateList();
        clearFields();
    }
}

void CurrencyEdit::on_pushButton_Restore_clicked()
{
    QMessageBox::StandardButton reply;
    reply = QMessageBox::warning(this, tr("Warning!"),
                                  "You will lose all your custom settings and " \
                                  "everything will be restored to default. " \
                                  "Are you sure?",
                                  QMessageBox::Yes | QMessageBox::No);
    if (reply == QMessageBox::Yes) {
        mvSettings.remove("");
        mvSettings.setValue("Restore", true);
        this->close();
    }
}

void CurrencyEdit::on_actionHelp_triggered()
{
    mvSettings.setValue("Help", "CurrencyEdit");
    helpWindow = new Help(this);
    helpWindow->show();
}

void CurrencyEdit::on_checkBox_Pegged_toggled(bool checked)
{
    if (checked) {
        QString currency = ui->lineEdit_currency->text();
        if (currency != "EUR" and currency != "USD") {
            mvPegged = true;
            ui->labelRate->setText("Set the rate for 1 US Dollar");
        } else {
            ui->checkBox_Pegged->setChecked(false);
        }
    } else {
        mvPegged = false;
        ui->labelRate->setText("Set the rate for 1 Euro");
    }
}
