#include "currencysettings.h"
#include "ui_currencysettings.h"

CurrencySettings::CurrencySettings(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::CurrencySettings)
{
    ui->setupUi(this);

    ui->lineEdit_taxRate->setValidator(new QDoubleValidator(0, 100, 2, this));
    ui->lineEdit_tipRate->setValidator(new QDoubleValidator(0, 100, 2, this));
    ui->lineEdit_taxRate->setText(mvSettings.value("TaxRate").toString());
    ui->lineEdit_tipRate->setText(mvSettings.value("TipRate").toString());
    mvCurrency1 = mvSettings.value("Currency1").toString();
    mvCurrency2 = mvSettings.value("Currency2").toString();
    mvAutoUpdate = mvSettings.value("AutoUpdate").toBool();
    ui->checkBox_AutoUpdate->setChecked(mvAutoUpdate);

    displayRate();
    updateList();
}

CurrencySettings::~CurrencySettings()
{
    delete ui;
}

void CurrencySettings::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void CurrencySettings::displayRate()
{
    ui->pushButton_Home->setText(mvCurrency1);
    ui->pushButton_Foreign->setText(mvCurrency2);
    ui->listWidget_Currency->sortItems(Qt::AscendingOrder);
}

void CurrencySettings::updateList()
{
    mvSettings.beginGroup("Currency");
    QStringList allCurrencies = mvSettings.allKeys();
    QString currencyName;
    QStringList currencyNames;
    mvSettings.endGroup();

    mvSettings.beginGroup("CurrencyName");
    foreach (QString currency, allCurrencies) {
        currencyName = currency + " - " + mvSettings.value(currency).toString();
        currencyNames += currencyName;
    }
    mvSettings.endGroup();

    ui->listWidget_Currency->clear();
    ui->listWidget_Currency->addItems(currencyNames);

    QString keyHome;
    QString keyForeign;
    QString currencyHome;
    QString currencyForeign;
    QString presetItem;
    int countPreset = mvSettings.value("CurrencyPreset").toInt();

    ui->listWidget_Preset->clear();

    mvSettings.beginGroup("CurrencyPreset");
    for (int current = 0; current < countPreset; current++) {
        keyHome = QString::number(current) + "Home";
        keyForeign = QString::number(current) + "Foreign";
        currencyHome = mvSettings.value(keyHome).toString();
        currencyForeign = mvSettings.value(keyForeign).toString();
        presetItem = currencyHome + " - " + currencyForeign;
        ui->listWidget_Preset->addItem(presetItem);
    }
    mvSettings.endGroup();
}

void CurrencySettings::on_checkBox_AutoUpdate_clicked(bool checked)
{
    if (checked) {
        mvAutoUpdate = true;
    } else {
        mvAutoUpdate = false;
    }
}

void CurrencySettings::on_pushButton_Apply_clicked()
{
    QString keyHome;
    QString keyForeign;
    QString currencyHome;
    QString currencyForeign;
    int countPreset = ui->listWidget_Preset->count();

    mvSettings.remove("CurrencyPreset");

    if (countPreset > 0) {
        mvSettings.beginGroup("CurrencyPreset");
        for (int current = 0; current < countPreset; current++) {
            keyHome = QString::number(current) + "Home";
            keyForeign = QString::number(current) + "Foreign";
            currencyHome = ui->listWidget_Preset->item(current)->text().left(3);
            currencyForeign = ui->listWidget_Preset->item(current)->text().right(3);
            mvSettings.setValue(keyHome, currencyHome);
            mvSettings.setValue(keyForeign, currencyForeign);
        }
        mvSettings.endGroup();
        mvSettings.setValue("CurrencyPreset", countPreset);
    } else {
        mvSettings.beginGroup("CurrencyPreset");
        mvSettings.setValue("0Home", mvCurrency1);
        mvSettings.setValue("0Foreign", mvCurrency2);
        mvSettings.endGroup();
        mvSettings.setValue("CurrencyPreset", 1);
    }


    mvSettings.setValue("Currency1", mvCurrency1);
    mvSettings.setValue("Currency2", mvCurrency2);
    mvSettings.setValue("TaxRate", ui->lineEdit_taxRate->text().toDouble());
    mvSettings.setValue("TipRate", ui->lineEdit_tipRate->text().toDouble());
    mvSettings.setValue("AutoUpdate", mvAutoUpdate);
    mvSettings.setValue("Currency", true);
    mvSettings.sync();
    this->close();
}

void CurrencySettings::on_pushButton_Edit_clicked()
{
    currencyEdit = new CurrencyEdit(this);
    currencyEdit->installEventFilter(this);
    currencyEdit->show();   
}



void CurrencySettings::on_pushButton_Home_clicked()
{
    if (ui->listWidget_Currency->currentRow() != -1) {
        mvCurrency1 = ui->listWidget_Currency->currentItem()->text().left(3);
        displayRate();
    }
}

void CurrencySettings::on_pushButton_Foreign_clicked()
{
    if (ui->listWidget_Currency->currentRow() != -1)  {
        mvCurrency2 = ui->listWidget_Currency->currentItem()->text().left(3);
        displayRate();
    }
}

void CurrencySettings::on_pushButton_Preset_clicked()
{
    QString presetCurrency = mvCurrency1 + " - " + mvCurrency2;
    ui->listWidget_Preset->addItem(presetCurrency);
}

void CurrencySettings::on_pushButton_Delete_clicked()
{
    delete ui->listWidget_Preset->takeItem(ui->listWidget_Preset->currentRow());
}

bool CurrencySettings::eventFilter(QObject *obj, QEvent *event)
{
    if (event->type() == QEvent::Close) {
        if (mvSettings.value("Restore").toBool()) {
            this->close();
        } else {
            mvCurrency1 = mvSettings.value("Currency1").toString();
            mvCurrency2 = mvSettings.value("Currency2").toString();
            displayRate();
            updateList();
        }
        return true;
    } else {
        return QObject::eventFilter(obj, event);
    }
}
