#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    ui->lineEdit->setValidator(new QDoubleValidator(0, 0, 2, this));



    mvSettings.sync();
    initialSettings();
    updateCurrency();
    updateButtons();
    mvTotal = 0;
    updateValue(0);

}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::initialSettings()
{
    if (!mvSettings.contains("Currency1")) {
        mvSettings.setValue("Currency1", "EUR");
        mvSettings.setValue("Currency2", "USD");
        mvSettings.setValue("TaxRate", 20);
        mvSettings.setValue("TipRate", 10);
        mvSettings.setValue("USD", 1.4374);
        mvSettings.setValue("JPY", 130.76);
        mvSettings.setValue("BGN", 1.9558);
        mvSettings.setValue("CZK", 25.947);
        mvSettings.setValue("DKK", 7.4420);
        mvSettings.setValue("EEK", 15.6466);
        mvSettings.setValue("GBP", 0.88105);
        mvSettings.setValue("HUF", 266.80);
        mvSettings.setValue("LTL", 3.4528);
        mvSettings.setValue("LVL", 0.7085);
        mvSettings.setValue("PLN", 4.0399);
        mvSettings.setValue("RON", 4.1043);
        mvSettings.setValue("SEK", 10.1430);
        mvSettings.setValue("CHF", 1.4756);
        mvSettings.setValue("NOK", 8.1430);
        mvSettings.setValue("HRK", 7.2890);
        mvSettings.setValue("RUB", 42.5015);
        mvSettings.setValue("TRY", 2.0900);
        mvSettings.setValue("AUD", 1.5547);
        mvSettings.setValue("BRL", 2.5438);
        mvSettings.setValue("CAD", 1.4752);
        mvSettings.setValue("CNY", 9.8130);
        mvSettings.setValue("HKD", 11.1536);
        mvSettings.setValue("IDR", 65.7000);
        mvSettings.setValue("KRW", 1614.29);
        mvSettings.setValue("MXN", 18.2790);
        mvSettings.setValue("MYR", 4.8002);
        mvSettings.setValue("NZD", 1.9497);
        mvSettings.setValue("PHP", 65.867);
        mvSettings.setValue("SGD", 1.9984);
        mvSettings.setValue("THB", 47.244);
        mvSettings.setValue("ZAR", 10.6588);
    }

}

void MainWindow::updateValue(int actionType)
{
    double currentValue = ui->lineEdit->text().toDouble();

    switch (mvAction) {
    case 0:
        mvTotal = currentValue;
        break;
    case 1:
        mvTotal += currentValue;
        break;
    case 2:
        mvTotal -= currentValue;
        break;
    case 3:
        mvTotal *= currentValue;
        break;
    case 4:
        mvTotal /= currentValue;
        break;
    }

    QString labelText = ui->label->text();
    QString formatRate;
    float addRate;


    switch (actionType) {
    case 5:
        addRate = mvTotal / 100 * mvSettings.value("TipRate").toDouble();
        mvTotal += addRate;
        mvAction = 0;
        formatRate.setNum(addRate, 'f', 2);
        labelText = "Tip " + formatRate;
        ui->labelSmall->setText(labelText);
        break;
    case 6:
        addRate = mvTotal / 100 * mvSettings.value("TaxRate").toDouble();
        mvTotal += addRate;
        mvAction = 0;
        formatRate.setNum(addRate, 'f', 2);
        labelText = "Tax " + formatRate;
        ui->labelSmall->setText(labelText);
        break;
    default:
        mvAction = actionType;
        break;
    }

    mvClear = true;

    ui->lineEdit->setText(QString::number(mvTotal, 'f', 2));
}

void MainWindow::updateScreen(int valueType)
{
    if (mvClear) {
        ui->lineEdit->clear();
    }

    if (mvUpdated) {
        ui->label->clear();
        mvUpdated = false;
    }

    ui->labelSmall->clear();

    switch (valueType) {
    case 0:
        ui->lineEdit->insert("0");
        break;
    case 1:
        ui->lineEdit->insert("1");
        break;
    case 2:
        ui->lineEdit->insert("2");
        break;
    case 3:
        ui->lineEdit->insert("3");
        break;
    case 4:
        ui->lineEdit->insert("4");
        break;
    case 5:
        ui->lineEdit->insert("5");
        break;
    case 6:
        ui->lineEdit->insert("6");
        break;
    case 7:
        ui->lineEdit->insert("7");
        break;
    case 8:
        ui->lineEdit->insert("8");
        break;
    case 9:
        ui->lineEdit->insert("9");
        break;
    case 10:
        ui->lineEdit->insert(".");
        break;
    case 11:
        ui->lineEdit->backspace();
        break;
    case 12:
        ui->lineEdit->clear();
        ui->label->clear();
        ui->labelSmall->clear();
        mvTotal = 0;
        break;
    }

    mvClear = false;
}

void MainWindow::convertCurrency(QString fromCurrency, QString toCurrency)
{
    double currentValue = ui->lineEdit->text().toDouble();
    double fromRate;
    double toRate;
    double conversionRate;
    bool fromEuro;
    bool toEuro;

    if (fromCurrency == "EUR") {
        fromEuro = true;
    } else {
        fromRate = mvSettings.value(fromCurrency).toDouble();
        fromEuro = false;
    }

    if (toCurrency == "EUR") {
        toEuro = true;
    } else {
        toRate = mvSettings.value(toCurrency).toDouble();
        toEuro = false;
    }

    if (fromEuro) {
        currentValue *= toRate;
    } else if (toEuro) {
        conversionRate = 1 / fromRate;
        currentValue *= conversionRate;
    } else {
        conversionRate = 1 / fromRate;
        conversionRate *= toRate;
        currentValue *= conversionRate;
    }

    mvTotal = currentValue;
    ui->labelSmall->clear();
    ui->lineEdit->setText(QString::number(mvTotal, 'f', 2));
    mvClear = true;
}

void MainWindow::updateCurrency()
{
    QNetworkAccessManager manager;
    QEventLoop loop;
    QTimer *timer = new QTimer(this);
    QNetworkRequest *request = new QNetworkRequest(QUrl("http://www.ecb.europa.eu/stats/eurofxref/eurofxref-daily.xml"));
    QNetworkReply *reply = manager.get(*request);

    connect(reply, SIGNAL(finished()), &loop, SLOT(quit()));
    connect(timer, SIGNAL(timeout()), &loop, SLOT(quit()));

    ui->label->setText("Updating...");

    loop.exec();
    timer->start(10000);
    xml.clear();
    xml.addData(reply->readAll());
 
    delete reply;

    while (!xml.atEnd()) {
        if (xml.isStartElement()) {
            if (xml.name() == "Cube") {
                QXmlStreamAttributes attrs = xml.attributes();
                QStringRef currencyTime = attrs.value("time");
                QStringRef currencyName = attrs.value("currency");
                QStringRef currencyRate = attrs.value("rate");
                if (!currencyTime.isEmpty()) {
                    mvSettings.setValue("CurrencyTime", currencyTime.toString());
                }
                if (!currencyName.isEmpty()) {
                    mvSettings.setValue(currencyName.toString(), currencyRate.toString());
                }
            }
        }
        xml.readNext();
    }
    
    QDate date = mvSettings.value("CurrencyTime").toDate();
    QString updated = date.toString();

    ui->label->setText(updated);
    mvUpdated = true;
}

void MainWindow::updateButtons()
{
    QString currency1 = mvSettings.value("Currency1").toString();
    QString currency2 = mvSettings.value("Currency2").toString();

    currency1 += " -> " + mvSettings.value("Currency2").toString();
    currency2 += " -> " + mvSettings.value("Currency1").toString();

    ui->pushButton_Currency1->setText(currency1);
    ui->pushButton_Currency2->setText(currency2);
}

void MainWindow::on_pushButton_1_clicked()
{
    updateScreen(1);
}

void MainWindow::on_pushButton_2_clicked()
{
    updateScreen(2);
}

void MainWindow::on_pushButton_3_clicked()
{
    updateScreen(3);
}

void MainWindow::on_pushButton_4_clicked()
{
    updateScreen(4);
}

void MainWindow::on_pushButton_5_clicked()
{
    updateScreen(5);
}

void MainWindow::on_pushButton_6_clicked()
{
    updateScreen(6);
}

void MainWindow::on_pushButton_7_clicked()
{
    updateScreen(7);
}

void MainWindow::on_pushButton_8_clicked()
{
    updateScreen(8);
}

void MainWindow::on_pushButton_9_clicked()
{
    updateScreen(9);
}

void MainWindow::on_pushButton_0_clicked()
{
    updateScreen(0);
}

void MainWindow::on_pushButton_Dot_clicked()
{
    updateScreen(10);
}

void MainWindow::on_pushButton_Del_clicked()
{
    updateScreen(11);
}

void MainWindow::on_pushButton_Clear_clicked()
{
    updateScreen(12);
}

void MainWindow::on_pushButton_Enter_clicked()
{
    updateValue(0);
}

void MainWindow::on_pushButton_Plus_clicked()
{
    updateValue(1);
}

void MainWindow::on_pushButton_Minus_clicked()
{
    updateValue(2);
}

void MainWindow::on_pushButton_Multiply_clicked()
{
    updateValue(3);
}

void MainWindow::on_pushButton_Divide_clicked()
{
    updateValue(4);
}

void MainWindow::on_pushButton_Tip_clicked()
{
    updateValue(5);
}

void MainWindow::on_pushButton_Tax_clicked()
{
    updateValue(6);
}


void MainWindow::on_pushButton_Currency1_clicked()
{
    QString currency1 = mvSettings.value("Currency1").toString();
    QString currency2 = mvSettings.value("Currency2").toString();
    convertCurrency(currency1, currency2);
    ui->label->setText(currency2);
}

void MainWindow::on_pushButton_Currency2_clicked()
{
    QString currency1 = mvSettings.value("Currency1").toString();
    QString currency2 = mvSettings.value("Currency2").toString();
    convertCurrency(currency2, currency1);
    ui->label->setText(currency1);
}

void MainWindow::on_pushButton_SetCurrency_clicked()
{
    currencyDialog = new Currency;
    currencyDialog->exec();
    updateButtons();
}

void MainWindow::on_actionHelp_triggered()
{
    helpDialog = new Help;
    helpDialog->exec();
}

void MainWindow::on_actionAbout_triggered()
{
    aboutDialog = new About;
    aboutDialog->exec();
}

void MainWindow::on_actionDonate_triggered()
{
    QDesktopServices::openUrl(QUrl("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=sascha.makela@gmail.com&lc=LT&item_name=STM%20Software%20-%20Currency%20Converter&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted"));
}

void MainWindow::on_pushButton_Update_clicked()
{
    ui->lineEdit->clear();
    ui->labelSmall->clear();
    updateCurrency();
}
