#include "currency.h"
#include "ui_currency.h"

Currency::Currency(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Currency)
{
    ui->setupUi(this);

    ui->lineEdit_taxRate->setValidator(new QDoubleValidator(0, 100, 1, this));
    ui->lineEdit_tipRate->setValidator(new QDoubleValidator(0, 100, 1, this));
    ui->lineEdit_taxRate->setText(mvSettings.value("TaxRate").toString());
    ui->lineEdit_tipRate->setText(mvSettings.value("TipRate").toString());
    mvCurrency1 = mvSettings.value("Currency1").toString();
    mvCurrency2 = mvSettings.value("Currency2").toString();
    ui->label_Currency1->setText(mvCurrency1);
    ui->label_Currency2->setText(mvCurrency2);
}

Currency::~Currency()
{
    delete ui;
}

void Currency::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Currency::on_listWidget1_clicked(QModelIndex index)
{
    mvCurrency1 = ui->listWidget1->currentItem()->text();
    ui->label_Currency1->setText(mvCurrency1.left(3));
}

void Currency::on_listWidget2_clicked(QModelIndex index)
{
    mvCurrency2 = ui->listWidget2->currentItem()->text();
    ui->label_Currency2->setText(mvCurrency2.left(3));
}

void Currency::on_pushButton_Apply_clicked()
{
    mvSettings.setValue("Currency1", mvCurrency1.left(3));
    mvSettings.setValue("Currency2", mvCurrency2.left(3));
    mvSettings.setValue("TaxRate", ui->lineEdit_taxRate->text().toFloat());
    mvSettings.setValue("TipRate", ui->lineEdit_tipRate->text().toFloat());
    mvSettings.sync();
    this->close();
}
