/*
*  currency exchange widget for the maemo desktop.
*  Copyright (C) 2010 binop consulting group
*  
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*  
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*  
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include "cJSON.h"
#include "lib-currency-home-widget.h"

extern char * get_html(char *url);
extern char *currencies[];
char *get_icon_string(char *st);

void get_values_json(CurrencyWidget **p) {

        char *json_string;
        char url[50];    
   
        int to_type = (*p)->curset->type - 1;
        int from_type = (*p)->curset->active_currency->type - 1;



        
        // Convert to lower case string 
        char from[4], to[4];
        
        int j;
        for ( j = 0; j < 4 ; j++) {
            from[j] = tolower(currencies[to_type][j]);
            to[j] = tolower(currencies[from_type][j]);
        }

        sprintf(url, "%s%s/%s/1", SERVER, to, from);
        char *html = get_html(url);

        if ( strstr(html, "ok") == 0 || strstr(html, "unable") != 0 || html == NULL || strstr(html, from) == 0 ) {
            strcpy((*p)->curset->name, currencies[(*p)->curset->type - 1]);
            strcpy((*p)->curset->active_currency->name, currencies[(*p)->curset->active_currency->type - 1]);
            (*p)->curset->not_updated = 1;
            char *tmp = get_icon_string((*p)->curset->active_currency->name);
            strcpy((*p)->curset->active_currency->icon, tmp);
            free(tmp);
            free(html);
            return;
        }

        cJSON *root = cJSON_Parse(html);

        cJSON *result = cJSON_GetObjectItem(root, "result");
        double value  = cJSON_GetObjectItem(result, "value")->valuedouble;
        char st[20];
        snprintf(st,7,"%lf",value);
        st[7] = '\0'; 
       
        (*p)->curset->not_updated = 0;
        strcpy((*p)->curset->active_currency->name, currencies[(*p)->curset->active_currency->type - 1]);
        strcpy((*p)->curset->name, currencies[(*p)->curset->type - 1]);
        strncpy((*p)->curset->active_currency->value, st, 20);


        // set the icon path
        char *tmp = get_icon_string((*p)->curset->active_currency->name);
        strcpy((*p)->curset->active_currency->icon, tmp);

        time(&(*p)->curset->last_update);
        
        
        // Cleanup 
        cJSON_Delete(root);
        free(tmp);
        free(html);
}

char *get_icon_string(char *cur) {

    int i;
    char st[4];
    char *result = malloc (sizeof(char) * 60);

    if ( !result) {
        fprintf(stderr, "Could not allocatate string!");
        exit(EXIT_FAILURE);
    }

    result[0] = '\0';


    for ( i = 0; i < 4 ; i++ ) {
        st[i] = tolower(cur[i]);
    }

    sprintf(result, "%s%s.png", ICONS_DIR, st);

    return result;
}


