/*
*  calendar home widget for the maemo desktop.
*  Copyright (C) 2010 binop consulting group
*  
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*  
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*  
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "lib-currency-home-widget.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

extern char * get_html();
extern void load_config(CurrencyWidget **plug);

void init_currency(currency **cur);
void get_curset(CurrencyWidget **p);
void dealloc_curset(currency_set  **curset);
void dealloc_currency(currency **);



void  get_curset(CurrencyWidget **p) {

        int j; 
        (*p)->curset = malloc(sizeof(currency_set));

        if ( !(*p)->curset )
        {
                fprintf(stderr, "Could not allocate memory for structure currency_set");
                exit(EXIT_FAILURE);
        }

        (*p)->curset->name  = NULL;
        (*p)->curset->active_currency = NULL;

        // load config from file
        load_config(&(*p));
        // get values from server and parse them
        get_values_json(&(*p)->curset);
}


/* dealloc currency_set */
void dealloc_curset(currency_set **p) {
      
        if ( (*p) == NULL) {
                fprintf(stderr, "curset already NULL, cannot deallocate");
                exit(EXIT_FAILURE);
        }

        dealloc_currency(&(*p)->active_currency);
        free((*p)->active_currency);
        
        free((*p)->name);
        free((*p));
}
        
/* Malloc currency  */
void init_currency(currency **cur) {

        (*cur)  = malloc(sizeof(currency));

        
        (*cur)->name = malloc(4 * sizeof(char));
        (*cur)->value = malloc( 20* sizeof(char)); 
        (*cur)->icon = malloc(FILENAME_MAX); 
        if ((*cur)->name == NULL || (*cur)->value == NULL || (*cur)->icon == NULL) {
                fprintf(stderr, "Memory could not be allocated!");
                exit(EXIT_FAILURE);
        }
}



void dealloc_currency(currency **cur) {
        
        free((*cur)->name);
        free((*cur)->value);
        free((*cur)->icon);
}



/* Initialize currency widget, first initialize settings structures, then create the
 * appropriate currency_set structures */
void init_currency_widget(CurrencyWidget **p) {
        get_curset( &(*p));
}

/* Dealloc CurrencyWidget Structure, Not used */
void dealloc_currency_widget(CurrencyWidget **p) {

        dealloc_curset(&(*p)->curset);
        free((*p)->id);
}
