/***********************************************************************
**
**   waypointcatalog.h
**
**   This file is part of Cumulus.
**
************************************************************************
**
**   Copyright (c):  2001 by Harald Maier
**          modified 2002 by Andre Somers
**          modified 2008 by Axel Pauli
**
**   This file is distributed under the terms of the General Public
**   Licence. See the file COPYING for more information.
**
**   $Id: waypointcatalog.h 3091 2008-10-17 21:38:01Z axel $
**
***********************************************************************/

#ifndef WAYPOINT_CATALOG_H
#define WAYPOINT_CATALOG_H

#include <QString>
#include <QList>

#include "waypoint.h"


class WaypointCatalog
{
  public:

  WaypointCatalog();

  ~WaypointCatalog();

  /** read in catalog from file name */
  bool read( QString *catalog, QList<wayPoint>& wpList );

  /** write out catalog to file name */
  bool write( QString *catalog, QList<wayPoint>& wpList );
};

#endif
