/***************************************************************************
                          gpgsa.h  -  description
                             -------------------
    begin                : 24.10.2009
    copyright            : (C) 2009 by Axel Pauli
    email                : axel@kflog.org

    $Id: gpgsa.h 4199 2010-08-02 19:01:47Z axel $

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GPGSA_H_
#define GPGSA_H_

#include <QString>
#include <QStringList>

  /**
  GSA - GPS DOP and active satellites

          1 2 3                    14 15  16  17  18
          | | |                    |  |   |   |   |
   $--GSA,a,a,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x.x,x.x*hh<CR><LF>

   Field Number:
    1) Selection mode
    2) Mode
    3) ID of 1st satellite used for fix
    4) ID of 2nd satellite used for fix
    ...
    14) ID of 12th satellite used for fix
    15) PDOP in meters
    16) HDOP in meters
    17) VDOP in meters
    18) checksum
   */

// $GPGSA,A,3,14,32,17,20,11,23,28,,,,,,1.7,1.1,1.2*3C

class GPGSA
{

public:

  GPGSA();

  int send( QStringList& satIds, QString& pdop, QString& hdop, QString &vdop, int fd );

private:

  uint calcCheckSum (int pos, const QString& sentence);
};

#endif
