/***********************************************************************
**
**   settingspageinformation.h
**
**   This file is part of Cumulus.
**
************************************************************************
**
**   Copyright (c):  2003-2010 by Axel Pauli (axel@kflog.org)
**
**   This file is distributed under the terms of the General Public
**   License. See the file COPYING for more information.
**
**   $Id: settingspageinformation.h 4121 2010-06-21 21:38:56Z axel $
**
***********************************************************************/

/**
 * \author Axel Pauli
 *
 * \brief The class manages the popup window display times and the alarm sound.
 *
 */

#ifndef  SettingsPageInformation_H
#define  SettingsPageInformation_H

#include <QWidget>
#include <QSpinBox>
#include <QCheckBox>
#include <QPushButton>
#include <QLineEdit>

class SettingsPageInformation : public QWidget
{
  Q_OBJECT

  private:

  Q_DISABLE_COPY ( SettingsPageInformation )

  public:

  SettingsPageInformation(QWidget *parent=0);

  virtual ~SettingsPageInformation();


  public slots: // Public slots
  /**
   * Called to initiate saving to the configuration file.
   */
  void slot_save();

  /**
   * Called to initiate loading of the configuration file
   */
  void slot_load();

  private slots:
  /**
   * Called to restore the factory settings
   */
  void slot_setFactoryDefault();

  /**
   * Called to open a selection file dialog for the sound tool
   */
  void slot_openToolDialog();

 private:

  QLineEdit*   soundTool;
  QSpinBox*    spinAirfield;
  QSpinBox*    spinAirspace;
  QSpinBox*    spinWaypoint;
  QSpinBox*    spinWarning;
  QSpinBox*    spinInfo;
  QSpinBox*    spinSuppress;
  QCheckBox*   checkAlarmSound;
  QCheckBox*   calculateNearestSites;
  QPushButton* buttonReset;

  bool loadConfig; // control loading of config data
};

#endif // SettingsPageInformation_h
