/***********************************************************************
**
**   preflightgliderpage.h
**
**   This file is part of Cumulus.
**
************************************************************************
**
**   Copyright (c):  2003 by André Somers, 2008 Axel Pauli
**
**   This file is distributed under the terms of the General Public
**   Licence. See the file COPYING for more information.
**
**   $Id: preflightgliderpage.h 3348 2009-04-23 18:28:45Z axel $
**
***********************************************************************/

#ifndef PREFLIGHT_GLIDER_PAGE_H
#define PREFLIGHT_GLIDER_PAGE_H

#include <QWidget>
#include <QLineEdit>
#include <QSpinBox>

#include "gliderlistwidget.h"

/**
 * This widget represents the glider-selection page for the PreFlight dialog.
 *
 * @author André Somers
 */
class PreFlightGliderPage : public QWidget
  {
    Q_OBJECT

  public:

    PreFlightGliderPage(QWidget *parent=0);
    ~PreFlightGliderPage();
    void save();

  protected:

    void showEvent(QShowEvent *);

  private:

    GliderListWidget *list;
    QLineEdit        *edtCoPilot;
    QSpinBox         *spinLoad;
    QSpinBox         *spinWater;
    Glider           *lastGlider;

    void getCurrent();

  private slots:

    void slot_gliderChanged();
    void slot_gliderDeselected();
  };

#endif
