/***********************************************************************
**
**   preflightgliderpage.h
**
**   This file is part of Cumulus.
**
************************************************************************
**
**   Copyright (c):  2003 by André Somers, 2008-2010 Axel Pauli
**
**   This file is distributed under the terms of the General Public
**   License. See the file COPYING for more information.
**
**   $Id: preflightgliderpage.h 4502 2010-12-09 22:32:02Z axel $
**
***********************************************************************/

/**
 * \class PreFlightGliderPage
 *
 * \author André Somers, Axel Pauli
 *
 * \brief A widget for pre-flight glider settings.
 *
 * \date 2003-2010
 *
 */

#ifndef PREFLIGHT_GLIDER_PAGE_H
#define PREFLIGHT_GLIDER_PAGE_H

#include <QWidget>
#include <QLineEdit>
#include <QSpinBox>

#include "gliderlistwidget.h"

class PreFlightGliderPage : public QWidget
{
  Q_OBJECT

  private:

  Q_DISABLE_COPY ( PreFlightGliderPage )

public:

  PreFlightGliderPage(QWidget *parent=0);
  ~PreFlightGliderPage();
  void save();

protected:

  void showEvent(QShowEvent *);

private:

  GliderListWidget *list;
  QLineEdit        *edtCoPilot;
  QSpinBox         *spinLoad;
  QSpinBox         *spinWater;
  Glider           *lastGlider;

  void getCurrent();

private slots:

  void slot_gliderChanged();
  void slot_gliderDeselected();
};

#endif
