import QtQuick 1.0

Rectangle {
    id: menu_window
    smooth: True
    width: workspace.width
    height: workspace.height
    color:  "black"
    opacity: 0.8
    y: 800
    z: 5

        MouseArea {
            anchors.fill: parent
            onClicked: {
                workspace.state = "menu2normal"
            }
        }


    Rectangle {
        id: menu_background
        width: parent.width
        height: 350
        gradient: Gradient {
            GradientStop {position: 0.0; color: "#e7e8e9"}
            GradientStop {position: 0.85; color: "#d0d2d2"}
                }
        anchors.bottom: parent.bottom

        Rectangle {
            id: menu_button
            border.color: "#aaaaaa"
            border.width: 2
            width: 440
            height: 100
            radius: 15
            anchors.horizontalCenter: menu_background.horizontalCenter
            anchors.bottom: menu_button2.top
            anchors.bottomMargin: 10
            gradient: Gradient {
                GradientStop {position: 0.0; color: "white"}
                GradientStop {position: 0.85; color: "#e7e8e9"}
            }
            MouseArea {
                id: menu_button_clicked
                anchors.fill: parent
                onClicked: {
                    workspace.state = "settings"
                }
            }

            Text {
                id: menu_button_text
                text: "Settings"
                font.bold: True
                font.family: "Nokia Pure Text"
                font.pointSize: 24
                anchors.verticalCenter: parent.verticalCenter
                anchors.left: parent.left
                anchors.leftMargin: 20
                color: menu_button_clicked.pressed ? "#aaaaaa" : "black"
            }
        }

        Rectangle {
            id: menu_button2
            border.color: "#aaaaaa"
            border.width: 2
            width: 440
            height: 100
            radius: 15
            anchors.horizontalCenter: menu_background.horizontalCenter
            anchors.bottom: menu_background.bottom
            anchors.bottomMargin: 10
            gradient: Gradient {
                GradientStop {position: 0.0; color: "white"}
                GradientStop {position: 0.85; color: "#e7e8e9"}
            }
            MouseArea {
                id: menu_button2_clicked
                anchors.fill: parent
                onClicked: {
                    workspace.state = "menu2normal"
                    pyfunc.ende()
                }
            }

            Text {
                id: menu_button2_text
                text: "Exit"
                font.bold: True
                font.family: "Nokia Pure Text"
                font.pointSize: 24
                anchors.verticalCenter: parent.verticalCenter
                anchors.left: parent.left
                anchors.leftMargin: 20
                color: menu_button2_clicked.pressed ? "#aaaaaa" : "black"
            }
        }

        Rectangle {
            id: menu_button3
            border.color: "#aaaaaa"
            border.width: 2
            width: 440
            height: 100
            radius: 15
            anchors.horizontalCenter: menu_background.horizontalCenter
            anchors.bottom: menu_button.top
            anchors.bottomMargin: 10
            gradient: Gradient {
                GradientStop {position: 0.0; color: "white"}
                GradientStop {position: 0.85; color: "#e7e8e9"}
            }
            MouseArea {
                id: menu_button3_clicked
                objectName: "reset_button"
                anchors.fill: parent
                onClicked: {
                    workspace.state = "menu2normal"
                }
            }

            Text {
                id: menu_button3_text
                text: "Reset time data"
                font.bold: True
                font.family: "Nokia Pure Text"
                font.pointSize: 24
                anchors.verticalCenter: parent.verticalCenter
                anchors.left: parent.left
                anchors.leftMargin: 20
                color: menu_button3_clicked.pressed ? "#aaaaaa" : "black"
            }
        }
    }

}
