/**
Copyright (c) 2012, DRAX <drax@drax.biz>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.
*/

// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Item
{
	//this should be invoked when initialization completes
	//it is not required to use, but it would be nicer to implement
	//some loading screen when heavy processing is done
	signal loadingDone()
	signal show()
	signal hidden()

	//this should initialize all required data
	function initialize()
    {
        console.debug("initialize() method is NOT IMPLEMENTED YET")
        return false
    }

	//this must be implemented to work properly
	function getStateName()
	{
		console.debug("getStateName() method is NOT IMPLEMENTED YET")
		return null
	}

	//this should be implemented when application want to use keyboard keys
	//it wouldn't be good to force focus and grab keyboard input for itself
	function processKey(event)
	{
		console.debug("processKey(event) method is NOT IMPLEMENTED YET")
		return false
	}

	//each window should implement its own way for processing screen orientation
	signal orientationPortrait
	signal orientationLandscape

	property bool landscape: true
	onWidthChanged: calculateOrientation()
	onHeightChanged: calculateOrientation()

	function calculateOrientation()
	{
		if (!landscape && width > height)
		{
			landscape = true
			orientationLandscape()
		}
		else if (landscape && width < height)
		{
			landscape = false
			orientationPortrait()
		}
	}

	opacity: 0  //by default it is hidden (a bit useful at states usage)
	onOpacityChanged: if (opacity == 0) hidden(); else if (opacity == 1) show()

	visible: true
    anchors.fill: parent



    property int transitionDuration: 250
	property bool doAnimations: true
	property bool smooth: true

    Behavior on opacity //on this way we dont need transition between states
    {
        NumberAnimation
        {
            id: numAnim
            property: "opacity";
			duration: (doAnimations ? transitionDuration : 0)
            easing.type: Easing.InOutQuad
        }
    }
}
