/**
Copyright (c) 2012, DRAX <drax@drax.biz>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.
*/

// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Rectangle
{
	id: scoreWidget

	//signal emmits when score widget is hidden
	signal hidden()
	property int totalScore: -1
	onTotalScoreChanged: totalScoreText.text = totalScore

	property bool doAnimations: true

	Component.onCompleted: reset()

	function addScore(score)
	{
		scoreText.text = score
		totalScore += score
	}

	function reset()
	{
		totalScore = 0
		addScore(0)
	}

	anchors.fill: parent
	color: "#33000000"
	opacity: 0
	z: 1000

	Behavior on opacity
	{
		NumberAnimation { duration: (doAnimations ? 200 : 0); easing.type: Easing.InOutQuad }
	}

	onOpacityChanged: if (opacity == 0) hidden()

	Rectangle
	{
		height: 210
		width: 310
		color: "#000000"
		radius: 7
		border.width: 2
		border.color: "#ffffff"
		anchors.verticalCenter: parent.verticalCenter
		anchors.horizontalCenter: parent.horizontalCenter

		smooth: parent.smooth

		Text
		{
			id: scoreTitleText
			color: "#ffffff"
			text: qsTr("This round score")
			anchors.top: parent.top
			anchors.topMargin: 10
			anchors.horizontalCenter: parent.horizontalCenter
			font.bold: true
			font.pointSize: 24
			verticalAlignment: Text.AlignVCenter
			horizontalAlignment: Text.AlignHCenter
		}

		Text
		{
			id: scoreText
			color: "#ffffff"
			text: ""
			anchors.top: scoreTitleText.bottom
			anchors.topMargin: 10
			anchors.horizontalCenter: parent.horizontalCenter
			font.bold: true
			font.pointSize: 24
			verticalAlignment: Text.AlignVCenter
			horizontalAlignment: Text.AlignHCenter
		}

		Text {
			id: totalScoreTitleText
			x: -7
			y: 106
			color: "#ffffff"
			text: qsTr("Total Score")
			anchors.horizontalCenterOffset: 0
			anchors.horizontalCenter: parent.horizontalCenter
			anchors.top: scoreText.bottom
			anchors.topMargin: 15
			font.bold: true
			font.pointSize: 24
			horizontalAlignment: Text.AlignHCenter
			verticalAlignment: Text.AlignVCenter
		}

		Rectangle {
			id: separator
			x: 19
			y: 104
			height: 4
			color: "#ffffff"
			anchors.right: parent.right
			anchors.rightMargin: 10
			anchors.left: parent.left
			anchors.leftMargin: 10

			smooth: parent.smooth
		 }

		 Text {
			 id: totalScoreText
			 x: 97
			 y: 152
			 color: "#ffffff"
			 text: ""
			 anchors.horizontalCenterOffset: 0
			 anchors.horizontalCenter: parent.horizontalCenter
			 anchors.top: totalScoreTitleText.bottom
			 anchors.topMargin: 10
			 font.bold: true
			 font.pointSize: 24
			 horizontalAlignment: Text.AlignHCenter
			 verticalAlignment: Text.AlignVCenter
		 }
	}

	MouseArea
	{
		id: mousearea1
		anchors.fill: parent
		onReleased: scoreWidget.opacity = 0
	}
}
