/**
Copyright (c) 2012, DRAX <drax@drax.biz>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.
*/

// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Item
{
	id: valueBox

	property int max: 99
	property int min: -99
	property int value: 0
	property string text: qsTr("INFO")

	property bool doAnimations: true
	property bool smooth: true

	onMaxChanged:
	{
		if (max < min)
			max = min
		if (value > max)
			value = max
	}

	onMinChanged:
	{
		if (min > max)
			min = max
		if (value < min)
			value = min
	}

	onValueChanged: if (value > max) value = max; else if (value < min) value = min

	width: infoText.width + infoText.anchors.leftMargin + infoText.anchors.rightMargin +
		   plusButton.width + plusButton.anchors.leftMargin + plusButton.anchors.rightMargin +
		   valueText.width + valueText.anchors.leftMargin + valueText.anchors.rightMargin +
		   minusButton.width + minusButton.anchors.leftMargin + minusButton.anchors.rightMargin
	height: 70

	Timer
	{
		id: timer

		property bool positive: true
		property alias value: valueBox.value

		running: false
		interval: 50
		repeat: true
		onTriggered:
		{
			if (positive)
				value = parseInt(value) + 1
			else
				value = parseInt(value) - 1
		}
	}

	TextDefault {
		id: infoText
		text: valueBox.text
		anchors.top: parent.top
		anchors.topMargin: 0
		anchors.bottom: parent.bottom
		anchors.bottomMargin: 0
		anchors.left: parent.left
		anchors.leftMargin: 0
	}

	Button {
		id: plusButton
		x: 125
		y: 0
		width: 70
		height: 70
		text: "+"
		anchors.left: infoText.right
		anchors.leftMargin: 5
		anchors.top: parent.top
		anchors.topMargin: 0
		mouseArea.onPressAndHold:
		{
			timer.positive = true
			timer.start()
		}
		mouseArea.onReleased: if (timer.running) timer.stop(); else value++

		doAnimations: valueBox.doAnimations
		smooth: valueBox.smooth
	}

	TextDefault {
		id: valueText
		width: 60
		text: value
		font.pointSize: 30
		anchors.left: plusButton.right
		anchors.leftMargin: plusButton.anchors.leftMargin
		anchors.bottom: parent.bottom
		anchors.bottomMargin: 0
		anchors.top: parent.top
		anchors.topMargin: 0
	}

	Button {
		id: minusButton
		width: 70
		height: 70
		text: "-"
		anchors.left: valueText.right
		anchors.leftMargin: valueText.anchors.leftMargin
		anchors.top: parent.top
		anchors.topMargin: 0
		mouseArea.onPressAndHold:
		{
			timer.positive = false
			timer.start()
		}
		mouseArea.onReleased: if (timer.running) timer.stop(); else value--

		doAnimations: valueBox.doAnimations
		smooth: valueBox.smooth
	}

}
