/**
Copyright (c) 2012, DRAX <drax@drax.biz>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.
*/

// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Rectangle
{
	id: backgroundRectangle

	property bool doAnimations: true
	property int updateInterval: 1000
	width: 100
	height: 62
	color: "#292929"
	radius: 7
	smooth: true

	property alias text: textContainer.text
	property alias textColor: textContainer.color
	property alias textSize: textContainer.font.pointSize
	//this overrides text if set to true
	property bool showPercentage: false
	onShowPercentageChanged:
	{
		if (showPercentage)
			setProgress(getProgress())
		else
			text = ""
	}

	property double progress: 0

	//WARNING: DIFFERENCE is READ-ONLY, no changes are allowed
	property double differenceREADONLY: ((backgroundRectangle.height - barRectangle.anchors.bottomMargin * 3) / 100)

	function setProgress(num)
	{
		progress = num
		barRectangle.height = progress * differenceREADONLY
		if (getProgress() > 100)
			setProgress(100)
		if (showPercentage)
			text = getProgress() + "%"
	}

	function getProgress()
	{
		return parseInt(progress);
	}

	function increaseProgress(oneIfNotDefined)
	{
		if (!oneIfNotDefined)
			oneIfNotDefined = 1
		setProgress(progress + oneIfNotDefined)
	}

	onEnabledChanged:
	{
		if (enabled)
			opacity = 1
		else
			opacity = 0.5
	}

	Behavior on opacity
	{
		NumberAnimation
		{
			duration: (doAnimations ? 200 : 0)
			easing.type: Easing.InOutQuad
		}
	}

	Rectangle {
		id: barRectangle
		smooth: parent.smooth
		gradient: Gradient
		{
			GradientStop
			{
				position: 0
				SequentialAnimation on color
				{
					loops: (doAnimations ? Animation.Infinite : 0)
					ColorAnimation { from: "#0077ff"; to: "#00aaff"; duration: 800 }
					ColorAnimation { from: "#00aaff"; to: "#0077ff"; duration: 800 }
				}
			}
			GradientStop
			{
				position: 1
				SequentialAnimation on color
				{
					loops: (doAnimations ? Animation.Infinite : 0)
					ColorAnimation { from: "#0000ff"; to: "#3333ff"; duration: 800 }
					ColorAnimation { from: "#3333ff"; to: "#0000ff"; duration: 800 }
				}
			}
		}

		Behavior on height
		{
			NumberAnimation
			{
				duration: (doAnimations ? backgroundRectangle.updateInterval : 0)
				easing.type: Easing.Linear
			}
		}

		radius: parent.radius
		anchors.left: parent.left
		anchors.leftMargin: 3
		anchors.right: parent.right
		anchors.rightMargin: 3
		anchors.bottom: parent.bottom
		anchors.bottomMargin: 3
	}

	Text
	{
		id: textContainer

		property bool textChangedLocked: false
		anchors.fill: parent
		color: "#ffffff"
		text: ""
		onTextChanged:
		{
			if (!textChangedLocked)
			{
				textChangedLocked = true
				var tmp = textContainer.text
				var tmpRes = ""
				var i=0
				for (; i<tmp.length - 1; i++)
					tmpRes += tmp.charAt(i) + "\n"
				tmpRes += tmp.charAt(i)
				textContainer.text = tmpRes
				textChangedLocked = false
			}
		}

		smooth: parent.smooth
		font.bold: true
		font.pointSize: 8
		verticalAlignment: Text.AlignVCenter
		horizontalAlignment: Text.AlignHCenter
	}
}
