/**
Copyright (c) 2012, DRAX <drax@drax.biz>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.
*/

// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1
import "ComponentCreator.js" as CC
import "GeneralFunctions.js" as GF

Flow
{
	id: panel

    //make sure that you set this before using this component
    property TextInput solutionTextIinput
	property string availableLetters: ""
	property int letterCount: 0

	property int buttonWidth: 70
	property int buttonHeight: 70

	property bool doAnimations: true
	smooth: true

    function setLetters(letters)
    {
		availableLetters = ""
		var letterPlaces = getLetterPlaces()
		if (letters.length !== letterPlaces)
		{
			console.debug("(Might happen due asyncronous destruction) Number of letters doesn't match with required number (given: ",
						  letters.length, " - required: ", letterPlaces, ")");
//            return false;
		}
		var tmp = getButtonLettersChildren()
		for (var i=0; i<letters.length; i++)
		{
			var tmpLetter = letters[i].toUpperCase()
			tmp[i].letter = tmpLetter
			if (!availableLetters.match(tmpLetter))
				availableLetters = availableLetters + tmpLetter
		}
		setLetterButtonsEnabled(true)
		return true;
    }

    function setLetterButtonsEnabled(yesOrNo)
    {
        var tmp = getButtonLettersChildren()
        for (var i=0; i<tmp.length; i++)
            tmp[i].enabled = yesOrNo
    }

	function setOneLetterButtonEnabled(letter, yesOrNo)
	{
		letter = letter.toUpperCase()
		var tmp = getButtonLettersChildren()
		for (var i=0; i<tmp.length; i++)
		{
			var tmpBut = tmp[i]
			if (tmpBut.enabled != yesOrNo && tmpBut.letter == letter)
			{
				tmpBut.enabled = yesOrNo
				return true
			}
		}
		return false
	}

    function getLetterPlaces()
    {
		return getButtonLettersChildren().length
    }

	function getUnusedLettersCount()
	{
		var childs = getButtonLettersChildren()
		var count = 0
		for (var i=0; i<childs.length; i++)
			if (childs[i].enabled)
				count++
		return count
	}

    function getButtonLettersChildren()
    {
		return children
    }

	//common settings used
	anchors.bottom: parent.bottom
	anchors.horizontalCenter: parent.horizontalCenter
	anchors.bottomMargin: 10
	flow: Flow.LeftToRight
    spacing: 10
	visible: true

	//FIXME: Ovo radi dosta dobro, samo pri "ivicama" hoce malo da prekoraci (kada se menja dimenzija tj sirina prozora)
	width: ((buttonWidth + spacing) *
		   (children.length / GF.truncate((children.length / GF.truncate(((parent.width - spacing) / (buttonWidth + spacing)) + 0.99)) + 0.99))) - spacing


	onLetterCountChanged:
	{
		CC.initializeComponent("ButtonLetter", false)

		var childs = children

		//optimized button generation (although since there is about 10 buttons max, it is not noticable)
		if (letterCount > childs.length)
			for (var i=childs.length; i<letterCount; i++)
				createButton()
		else if (letterCount < childs.length)
			for (var i=childs.length - 1; i>=letterCount; i--)
				//WARNING: destruction is delayed - so you can't relay on childs.length after this method is done (asyncronus destruction)
				childs[i].destroy()
	}

	function createButton()
	{
		CC.createObject(panel, {
							"width": function(){return buttonWidth},
							"height": function(){return buttonHeight},
							"textInput": function(){return solutionTextIinput},
							"doAnimations": function(){return panel.doAnimations},
							"smooth": function(){return panel.smooth}
						})
	}

}
