/**
Copyright (c) 2012, DRAX <drax@drax.biz>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.
*/

// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1
import "ComponentCreator.js" as CC

//TODO: napraviti ovo da bude SINGLETON, optimalnije je po pitanju memorije
Rectangle
{
	id: rectangle
	color: "#383838"
	radius: 15
	anchors.bottom: lettersPanel.top
	anchors.right: parent.right
	anchors.left: parent.left
	anchors.top: parent.top
	anchors.bottomMargin: 10

	property bool doAnimations: true
	smooth: true

	property alias gridChildren: grid.children
	property alias buttonSize: grid.buttonSize

	function initialize(rowNumOPTIONAL, columnNumOPTIONAL, sizeOPTIONAL)
	{
		if (sizeOPTIONAL)
			grid.buttonSize = sizeOPTIONAL;
		if (!rowNumOPTIONAL || rowNumOPTIONAL < 0)
			rowNumOPTIONAL = (rectangle.height - 4 * grid.anchors.margins) / (grid.buttonSize + grid.spacing)
		if (!columnNumOPTIONAL || columnNumOPTIONAL < 0)
			columnNumOPTIONAL = (rectangle.width - 4 * grid.anchors.margins) / (grid.buttonSize + grid.spacing)
		//comma makes problem in grid view (strange/unknown behavior)
		rowNumOPTIONAL = parseInt(rowNumOPTIONAL)
		columnNumOPTIONAL = parseInt(columnNumOPTIONAL)
		return grid.initialize(rowNumOPTIONAL, columnNumOPTIONAL)
	}

	function getRowsCount()
	{
		return grid.rows
	}

	function getColumnsCount()
	{
		return grid.columns
	}

	function getChildAt(childX, childY)
	{
		//ima vise pokusaja, tacnije pokusava da uhvati dete (child) najblize tom kliku (ako ga ima)
		//pokusaji su +/- razdaljina koliko je i izmedju samih dugmadi (decova)
		var button = grid.childAt(childX + flickable.contentX - flickable.anchors.leftMargin,
								  childY + flickable.contentY - flickable.anchors.topMargin)
		if (!button)
			button = grid.childAt(childX + flickable.contentX - flickable.anchors.leftMargin - grid.space,
								  childY + flickable.contentY - flickable.anchors.topMargin - grid.space)
		if (!button)
			button = grid.childAt(childX + flickable.contentX - flickable.anchors.leftMargin + grid.space,
								  childY + flickable.contentY - flickable.anchors.topMargin + grid.space)
		return button
	}

	function getChildren()
	{
		return grid.children
	}

	Flickable
	{
		id: flickable
		anchors.fill: parent
		anchors.margins: 10
		contentWidth: grid.width
		contentHeight: grid.height
		//hide elements that are outside of content area
		clip: true

		Grid
		{
			id: grid

			property int minSize: 45
			property int maxSize: 75
			property int buttonSize: 55
			onButtonSizeChanged: if (buttonSize < minSize) buttonSize = minSize; else if (buttonSize > maxSize) buttonSize = maxSize

			property int space
			anchors.verticalCenter: parent.verticalCenter
			anchors.horizontalCenter: parent.horizontalCenter
			anchors.margins: space
			spacing: space
			columns: -1
			rows: -1

			Component.onCompleted:
			{
				//initialize spacing
				space = 5

				//initialize object creation
				CC.initializeComponent("ButtonLetterDocker", false)
			}

			function createObject(index)
			{
				var tmp = CC.createObject(grid, {
									"index": index,
									"width": function(){return buttonSize},
									"height": function(){return buttonSize},
									"letter": "",
									"doAnimations": function(){return rectangle.doAnimations},
									"smooth": function(){return rectangle.smooth}
								})
			}

			function initialize(rowNum, columnNum)
			{
				if (rowNum < 0 || columnNum < 0)
					return false

				//mini optimization
				var requestedCount = rowNum * columnNum
				var actualCount = rows * columns

				//it is faster to clear letter than to recreate whole buttonSize
				//however this is done only when possible (old rows and columns count is same as currently requested)
				if (requestedCount === actualCount)
				{
					for (var i=0; i<grid.children.length; i++)
					{
						var tmp = grid.children[i]
						//first "isFinal" must be set to "false" in order to change "letter"
						tmp.isFinal = false
						tmp.letter = ""
					}
					columns = columnNum
					rows = rowNum
				}
				else if (requestedCount > actualCount)
				{
					//first we clear table, and add new components that are missing (if invoked later, it will clear new components too)
					initialize(rows, columns) //clear table
					for (var i=grid.children.length; i<requestedCount; i++)
						createObject(i)
					columns = columnNum
					rows = rowNum
				}
				else if (requestedCount < actualCount)
				{
					for (var i=grid.children.length - 1; i>=requestedCount; i--)
						grid.children[i].destroy()
					columns = columnNum
					rows = rowNum
					//we clear table (if invoked earlier, it will clear components that needs to be destroyed too)
					initialize(rows, columns) //clear table
				}
				return true
			}
		}
	}
}
