/**
Copyright (c) 2012, DRAX <drax@drax.biz>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.
*/

#include <QtGui/QApplication>
#include <QtDeclarative>

#include "qmlapplicationviewer.h"
#include "WordsList.h"
#include "LanguageLoader.h"
#include "ConfigurationManager.h"
#include "AudioPlayer.h"
#include "NetworkClient.h"
#include "NetworkServer.h"

QApplication* qtapp;

Q_DECL_EXPORT int main(int argc, char *argv[])
{
	qtapp = createApplication(argc, argv);
	qtapp->setApplicationName("Crosswords");
	QScopedPointer<QApplication> app(qtapp);
	qmlRegisterType<WordsList>("crosswords.WordsList", 1, 0, "WordsList");
	qmlRegisterType<LanguageLoader>("crosswords.LanguageLoader", 1, 0, "LanguageLoader");
	qmlRegisterType<ConfigurationManager>("crosswords.ConfigurationManager", 1, 0, "ConfigurationManager");
	qmlRegisterType<AudioPlayer>("crosswords.AudioPlayer", 1, 0, "AudioPlayer");
	//When object is injected in context, it doesn't require to be imported or registered
	qmlRegisterType<NetworkClient>("crosswords.NetworkClient", 1, 0, "NetworkClient");
	qmlRegisterType<NetworkServer>("crosswords.NetworkServer", 1, 0, "NetworkServer");


	//TODO: napraviti ovo dinamicki da se ucitava u toku izvrsavanja igre (da ne zahteva restart)
	ConfigurationManager* cm = new ConfigurationManager();
	LanguageLoader::installTranslatorToApplication(qtapp);
	LanguageLoader::setLanguageStatic(cm->getValue("language"));
	delete cm;

	QmlApplicationViewer viewer;
	viewer.setOrientation(QmlApplicationViewer::ScreenOrientationAuto);
	viewer.setSource(QUrl("qrc:///main.qml"));
    viewer.resize(800, 480);

	//Injecting custom objects
//	QDeclarativeContext* mainContext = viewer.rootContext();
//	mainContext->setContextProperty("networkClient", new NetworkClient());
//	mainContext->setContextProperty("networkServer", new NetworkServer());

	//for each system differend properties are used
	//and it is defined for each target separately
	QObject* mainQML = dynamic_cast<QObject*>(viewer.rootObject());
#if !defined(ENABLE_QUIT_BUTTON)
	//by default it is set to: true
	mainQML->setProperty("quitButtonVisible", false);

	//TODO: mozda uzmesto postavljanja vrednosti true/false da se napravi element kad treba, a kad ne teba nista (za nijansu je optimalnije)
#endif

	//running
#if defined(FULLSCREEN)
	viewer.showFullScreen();
#else
	viewer.showExpanded();
#endif

	return app->exec();
}
