#ifndef CLIENTPROCESSOR_H
#define CLIENTPROCESSOR_H

/**
Copyright (c) 2012, DRAX <drax@drax.biz>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.
*/

#include <QObject>
#include <QByteArray>
#include <QtNetwork/QTcpSocket>
#include <QMutex>

#include "NetworkDictionary.h"
#include "NetworkFunctions.h"

class NetworkServer;

class ClientProcessor : public QObject
{
		Q_OBJECT
	private:
		QTcpSocket* clientSocket;
		QList<ClientProcessor*>* clients;
		NetworkServer* networkServer;
		QMutex mutex;

		QString clientName;
		bool isMyTurn;
		qint16 myScore;

	public:
		explicit ClientProcessor(QTcpSocket* clientSocket, QList<ClientProcessor*>* clients, NetworkServer* networkServer);
		~ClientProcessor();
		QString getClientName();
		bool sendMessage(QByteArray& byteMessage);
		bool sendMessage(QString& message);
		bool sendMessage(Network::NetworkDictionary code, QString message = "");
		void myTurn(bool yesOrNo);
		void addScore(qint16 score, bool doubleScore, qint8 penaltyScore);
		qint16 getScore();

	public slots:
		void closeConnection();

	private slots:
		void readData();

};
#endif // CLIENTPROCESSOR_H
