#ifndef NETWORKFUNCTIONS_H
#define NETWORKFUNCTIONS_H

/**
Copyright (c) 2012, DRAX <drax@drax.biz>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.
*/

#include <QString>

namespace Network
{
	/**
	 * Parameters are Network::CODE_SEPARATOR separated
	 * @brief cutFirstParameter
	 * @param parameters
	 * @return
	 */
	static QString cutFirstParameter(QString &parameters)
	{
		qint8 index = parameters.indexOf(Network::CODE_SEPARATOR);
		if (index < 0)
		{
			//last or single parameter (perhaps no parameters?)
			QString lastParameter = parameters;
			parameters = "";
			return lastParameter;
		}
		QString firstParameter = parameters.left(index);
		index += Network::CODE_SEPARATOR.length();
		parameters = parameters.mid(index);
		return firstParameter;
	}

	static bool parseBool(QString value)
	{
		return value.toLower() == "true";
	}

	static QString toBool(bool value)
	{
		return (value ? "true" : "false");
	}
}

#endif // NETWORKFUNCTIONS_H
