#ifndef NETWORKDICTIONARY_H
#define NETWORKDICTIONARY_H

/**
Copyright (c) 2012, DRAX <drax@drax.biz>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.
*/

namespace Network
{
	static const qint16 GAME_ANNOUNCING_PORT = 20000;

	static const QString CODE_SEPARATOR = "|";

	static const QString END_OF_MESSAGE = "/";

	enum NetworkDictionary
	{
		//game announcing
		GAME_ANNOUNCE = 1,
		PROTOCOL,//for future versions of game, to avoid incompatability

		GAME_PARAMETERS = 2,//used for sending to player game parameters

		//game states
		GAME_START_LOADING = 10,//at this stage players should start loading game based on given parameters form server
		GAME_LOADING_FINISHED,//send when loading is finished (after all players finish loading host should invoke TURN codes)
		GAME_REQUEST_PAUSE,//client is requesting
		GAME_REQUEST_RESUME,//client is requesting
		GAME_PAUSED,//server is informing clients
		GAME_RESUMED,//server is informing clients
		GAME_FULL,//should be send to any new player that tries to join in full game
		GAME_STARTED,//should be sent to any player that tries to join on already started game
		GAME_FINISHED_FULL_TABLE,
		GAME_FINISHED_ROUND_LIMIT_REACHED,
		GAME_FINISHED_SCORELESS_ROUND_LIMIT_REACHED,

		//game control
//		YOUR_TURN,//informs player that has god turn to play
		CURRENT_TURN = 30,//informs players to who has been granted turn
		TURN_ENDED,//player should send this when he/she finishes round

		//game functions
		MOVE_IN_TABLE = 40,//moves letter within table (can also to move from table to panel)
		MOVE_FROM_PANEL,//moves letter from panel to table (NOT VICE-VERSA, use code above for that)
//		MOVE,//gives fromx, fromy, tox, toy mouse positions where to move (server should process them as it was user clicked)
		MOVE_ROLLBACK,//rollback move, it should send positions which need to be rollbacked (CAREFULL WITH THAT - MIGHT MAKE COLLISION/OVERRIDE)
		SET_LETTER,//server orders to client that it must put letter in given index

		//client requests
		GET_PLAYERS_LIST = 50,
		PLAYERS_LIST,

		//players
		PLAYER_KICKED = 60,
		PLAYER_KICKED_NEED_DIFFERENT_PLAYER_NAME,
		PLAYER_LEFT_GAME,
		YOUR_SCORE,//gives round score, is double score and penalty score
		GAME_FOUND_WORD,//gives found word and its count
		MESSAGE,//intended for displaying message to players
		PLAYER_NAME//used for indentification when joining to host
	};

}

#endif // NETWORKDICTIONARY_H
