#include "hen.h"
#include <QPainter>
#include <QGraphicsSceneMouseEvent>
#include <QCoreApplication>
#include <QKeyEvent>
#include <QGraphicsScene>
#include <QGraphicsView>
#include <QDebug>
#include <QGraphicsSceneMouseEvent>

Hen::Hen(Position position, bool is_livewallpaper)
    :QGraphicsObject(0),mPosition(position),mIsPressed(false)
{
    this->livewallpaper = is_livewallpaper;
    switch( mPosition) {
    case UpperLeft:
        mPixmap = QPixmap(":/image/hen_left_upper.png");
        mPressedPixmap = QPixmap(":/image/hen_left_upper_pressed.png");
        setPos(0,40);
        break;
    case LowerLeft:
        setPos(0,180);
        mPixmap = QPixmap(":/image/hen_left_lower.png");
        mPressedPixmap = QPixmap(":/image/hen_left_lower_pressed.png");
        break;
    case UpperRight:
        setPos(668,50);
        mPixmap = QPixmap(":/image/hen_right_upper.png");
        mPressedPixmap = QPixmap(":/image/hen_right_upper_pressed.png");
        break;
    case LowerRight:
        setPos(668,180);
        mPixmap = QPixmap(":/image/hen_right_lower.png");
        mPressedPixmap = QPixmap(":/image/hen_right_lower_pressed.png");
        break;
    }
}

void Hen::paint ( QPainter * painter, const QStyleOptionGraphicsItem * /*option*/, QWidget * /*widget*/ )
{
    if( !mIsPressed)
        painter->drawPixmap(0,0,mPixmap);
    else
        painter->drawPixmap(0,0,mPressedPixmap);
}

QRectF Hen::boundingRect() const
{
    return QRectF(0,0,132,114);
}

Position Hen::position() const
{
    return mPosition;
}

void Hen::setPressed(bool pressed)
{
    mIsPressed = pressed;
    update();
}

void Hen::touchStarted()
{
    mIsPressed = true;
    update();
}

void Hen::touchEnded()
{
    mIsPressed = false;
    update();
    emit touched( mPosition );
}

void Hen::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    touchStarted();
    event->accept();
    if (this->livewallpaper)
        touchEnded();
    //QGraphicsObject::mousePressEvent(event);
}

void Hen::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
{
    touchEnded();
    event->accept();
    //QGraphicsObject::mouseReleaseEvent(event);
}

//void Hen::mouseMoveEvent(QGraphicsSceneMouseEvent *event)
//{
//    mIsPressed = false;
//    update();
//    QGraphicsObject::mouseMoveEvent(event);
//}
