#include "hatchingegg.h"
#include <QPainter>
#include <QGraphicsScene>

HatchingEgg::HatchingEgg(Egg* egg, QGraphicsScene* scene)
    :QGraphicsObject(0),mEggImage(":/image/egg-break.png"),mCurrentFrame(0),mDelay(0)
{
    this->setPos( egg->pos());
    scene->addItem(this);
}

void HatchingEgg::paint ( QPainter * painter, const QStyleOptionGraphicsItem * /*option*/, QWidget * /*widget*/ )
{
     painter->drawPixmap(0,0,mEggImage,mCurrentFrame*34,0,34,28);
}

QRectF HatchingEgg::boundingRect() const
{
    return QRectF(0,0,34,28);
}

void HatchingEgg::nextFrame()
{
    mDelay += 33;
    if( mDelay < 33 * 4 || mCurrentFrame >= 5 ) {
        return;
    }

    mDelay = 0;
    mCurrentFrame = ++mCurrentFrame;
    update();
    if( mCurrentFrame >= 5 ) {
        emit hatched(this);
    }
}
