#ifndef EGG_H
#define EGG_H

#include <QGraphicsObject>
#include <QPixmap>

class Egg : public QGraphicsObject
{
    Q_OBJECT
public:
    Egg( QGraphicsItem* base,int speed );

    void paint ( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget = 0 );

    QRectF boundingRect() const;

    void move(); //void roll();

    bool isBroken() const;

    QGraphicsItem* base() const;

signals:

    void aboutToFall();

private:

    QGraphicsItem* mBase;
    QPixmap mEggImage;
    int mDelay;
    int mCurrentFrame;
    int mSpeed;
    bool mAboutToFall;
    int mXDir;
    int mYDir;
};

#endif // EGG_H
