#include "egg.h"
#include <QPainter>
#include <QDebug>

Egg::Egg(QGraphicsItem* base,int speed )
    :QGraphicsObject(0),mBase( base),mEggImage(":/image/rolling_eggs.png"),mDelay(0),mCurrentFrame(0),mSpeed(speed),mAboutToFall(false), mXDir(1),mYDir(0)
{
    //qDebug() <<" Speed:" << mSpeed;
    setX( base->x() + 100);
    setY( base->y() - 20 );

    if( base->x() >= 600 ) {
        mEggImage = QPixmap(":/image/rolling_eggs_right.png");
        mXDir = -1;
        setX( base->x() + base->boundingRect().width() - 100);
    }
}

void Egg::paint(QPainter *painter, const QStyleOptionGraphicsItem */*option*/, QWidget */*widget*/)
{
    painter->drawPixmap(0,0,mEggImage,mCurrentFrame*20,0,20,20);
}

QRectF Egg::boundingRect() const
{
    return QRect(0,0,20,20);
}

void Egg::move()
{
    mDelay += 33;
    if( mDelay < 33 * 4) {
        return;
    }
    mDelay = 0;

    moveBy( mSpeed*mXDir, mSpeed*mYDir );

    if( mYDir != 1 )
        mCurrentFrame = ++mCurrentFrame % 8;

    if( mXDir == 1 && x() - 10 > mBase->x()+ mBase->boundingRect().width()) {
        mYDir = 1;
        mXDir = 0;

        if(!mAboutToFall) {
            mAboutToFall = true;
            emit aboutToFall();
        }
    } else if( mXDir == -1 && x() + 20 < mBase->x() ) {
        mYDir = 1;
        mXDir = 0;

        if(!mAboutToFall) {
            mAboutToFall = true;
            emit aboutToFall();
        }
    } else if( y() > 400 ) {
        mXDir = 0;
        mYDir = 0;
    }
}

bool Egg::Egg::isBroken() const
{
    return ( y() > 400 );
}

QGraphicsItem* Egg::base() const
{
    return mBase;
}
