#include "textbutton.h"
#include <QFont>
#include <QDebug>
#include <QPainter>
#include <QGraphicsSceneMouseEvent>

TextButton::TextButton( const QString& buttonText,int fontSize  )
    :QGraphicsObject(0),mIsPressed(false)
{
    mTextItem = new QGraphicsTextItem();
    mTextItem->setParent(this);
    QFont font = mTextItem->font();
    font.setPointSize( font.pointSize() + fontSize);
    mTextItem->setFont(font);
    mTextItem->setPlainText( buttonText );

    setPressed(false);
}

void TextButton::setPressed(bool pressed)
{
    mIsPressed = pressed;
    QColor color = pressed ? Qt::darkGreen:Qt::black;
    mTextItem->setDefaultTextColor( color );
    update();
}

void TextButton::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    setPressed(true);
    event->accept();
    //QGraphicsObject::mousePressEvent(event);
}

void TextButton::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
{
    setPressed(false);
    emit clicked();
    event->accept();
    //QGraphicsObject::mouseReleaseEvent(event);
}

void TextButton::paint ( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget)
{
    mTextItem->paint(painter,option,widget);
}

QRectF TextButton::boundingRect() const
{
    return mTextItem->boundingRect();
}
