#include "scorecardscreen.h"
#include <QGraphicsTextItem>
#include <QGraphicsScene>
#include <QPainter>
#include "textbutton.h"
#include "roundrectbutton.h"
#include "common.h"

ScorecardScreen::ScorecardScreen(QGraphicsScene* scene, int score)
    :AbscractScreen(scene)
{
    QGraphicsTextItem* title = createTextItem(40,true);
    title->setDefaultTextColor(QColor(255,255,195));

    QGraphicsTextItem* firstLine = createTextItem(10);
    QGraphicsTextItem* secondLine = createTextItem(10);

    RoundRectButton* newGameBtn = createRoundRectButton("New Game",20,300);
    connect(newGameBtn,SIGNAL(clicked()),this,SIGNAL(startNewGame()));

    RoundRectButton* mainMenuBtn  = createRoundRectButton("Main Menu",20,300);
    connect(mainMenuBtn,SIGNAL(clicked()),this,SIGNAL(showMainMenu()));

    QString greeting;
    QString firstLineText;
    QString secondLineText;
    if( score >= Util::highScore() ) {
        greeting = QString("Congratulations!!");
        firstLineText = QString("New High Score!!");
        secondLineText = QString("Score:%1").arg(score);
        Util::setHighScore( score );
    }else {
        greeting = QString("Good Job!!");
        firstLineText = QString("Score:%1").arg(score);
        secondLineText = QString("Current High Score:%1").arg(Util::highScore());
    }

    title->setPlainText(greeting);
    firstLine->setPlainText(firstLineText);
    secondLine->setPlainText(secondLineText);

    title->setPos(400 - title->boundingRect().width()/2,100);
    firstLine->setPos(400 - firstLine->boundingRect().width()/2,200);
    secondLine->setPos(400 - secondLine->boundingRect().width()/2,250);
    newGameBtn->setPos(50,350);
    mainMenuBtn->setPos(800 - 50 - mainMenuBtn->boundingRect().width(),350);
}
