#include "mainwindow.h"
#include "ui_mainwindow.h"

#include "n900.h"
#include "cpufreq.h"

#include <QMessageBox>

MainWindow::MainWindow(QWidget *parent) :
        QMainWindow(parent),
        ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    connect(ui->pushButtonRefresh, SIGNAL(clicked()), this, SLOT(RefreshInfo()));
    //do something somehow
    //connect(ui->comboBoxCPU, SIGNAL(currentIndexChanged(int)), SLOT(on_comboBoxCPU_Select()));
    RefreshInfo();
    ui->labelTimeInStates->hide();
    InitCPU();
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::RefreshInfo()
{
    ui->labelTemperature->setText(QString(tr("Temperature: ")) + QString::number(omap_get_real_temperature()) + QChar(0x2103) + QString(tr(" real / "))+ QString::number(omap_get_raw_temperature()) + QString(tr(" raw")));
}

void MainWindow::InitCPU()
{
    unsigned int cpu, nr_cpus;
    unsigned long min, max;
    unsigned int min_pctg = 0;
    unsigned int max_pctg = 0;
    struct cpufreq_policy *policy;
    struct cpufreq_available_frequencies *freqs;
    struct cpufreq_available_governors *governors;
    unsigned int i;

    // CPU's
    ui->comboBoxCPU->clear();
    nr_cpus = count_cpus();
    //nr_cpus=1;
    if(nr_cpus==1) {
        ui->comboBoxCPU->addItem(QString::number(0),0);
        ui->comboBoxCPU->hide();
        ui->labelCPU->hide();
    } else {
        for (cpu=0; cpu < nr_cpus; cpu++) {
            ui->comboBoxCPU->addItem(QString::number(cpu),cpu);
        }
    }
    //ui->label_3->setText(QString::number(nr_cpus));
    // CPU's END

    // policy
    policy = cpufreq_get_policy(ui->comboBoxCPU->currentText().toInt());
    if (policy) {

        if (cpufreq_get_hardware_limits(ui->comboBoxCPU->currentText().toInt(), &min, &max)) {
            max = 0;
        } else {
            min_pctg = (policy->min * 100) / max;
            max_pctg = (policy->max * 100) / max;
        }
    }
    // policy END
    // do not forget cpufreq_put_policy

    // Governors
    ui->comboBoxCPUGovernor->clear();
    governors = cpufreq_get_available_governors(ui->comboBoxCPU->currentText().toInt());
    if (governors) {
        i=0;
        while (governors->next) {
            ui->comboBoxCPUGovernor->addItem(governors->governor,i);
            governors = governors->next;
            i++;
        }
        ui->comboBoxCPUGovernor->addItem(governors->governor,i);
        cpufreq_put_available_governors(governors);
    }
    ui->comboBoxCPUGovernor->setCurrentIndex(ui->comboBoxCPUGovernor->findText(QString(policy->governor)));
    // Governors END

    // CPU Frequencies
    ui->comboBoxCPUFreq->clear();
    freqs = cpufreq_get_available_frequencies(ui->comboBoxCPU->currentText().toInt());
    if (freqs) {
        while (freqs->next) {
            ui->comboBoxCPUFreq->addItem(QString::number(freqs->frequency),int(freqs->frequency));
            freqs = freqs->next;
        }
        ui->comboBoxCPUFreq->addItem(QString::number(freqs->frequency),int(freqs->frequency));
        //unsigned long hwfreq = cpufreq_get_freq_hardware(ui->comboBoxCPU->currentText().toInt());
        //ui->comboBoxCPUFreq->setCurrentIndex();
        cpufreq_put_available_frequencies(freqs);
    }
    ui->comboBoxCPUFreq->setCurrentIndex(ui->comboBoxCPUFreq->findText(QString::number(policy->max)));
    cpufreq_put_policy(policy);
    // CPU Frequencies END

    // up_threshold
    ui->lineEditUpThreshold->clear();
    ui->lineEditUpThreshold->setText(QString::number(cpufreq_get_up_threshold(ui->comboBoxCPU->currentText().toInt())));
    // up_threshold END

    // sampling_rate
    ui->lineEditSamplingRate->clear();
    ui->lineEditSamplingRate->setText(QString::number(cpufreq_get_sampling_rate(ui->comboBoxCPU->currentText().toInt())));
    // sampling_rate END

    // ignore_nice_load
    i = cpufreq_get_ignore_nice_load(ui->comboBoxCPU->currentText().toInt());
    if(i==-1) {
        ui->checkBoxIgnoreNiceLoad->hide();
    } else {
        ui->checkBoxIgnoreNiceLoad->show();
        if(i)
            ui->checkBoxIgnoreNiceLoad->setChecked(true);
        else
            ui->checkBoxIgnoreNiceLoad->setChecked(false);
    }
    // ignore_nice_load END

    // SmartReflex
    i = cpufreq_get_SmartReflex();
    if(i==-1) {
        ui->checkBoxSmartReflex->hide();
    } else {
        ui->checkBoxSmartReflex->show();
        if(i)
            ui->checkBoxSmartReflex->setChecked(true);
        else
            ui->checkBoxSmartReflex->setChecked(false);
    }
    // SmartReflex END
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::on_pushButtonClear_clicked()
{
    ui->comboBoxCPU->clear();
    ui->comboBoxCPUFreq->clear();
    ui->comboBoxCPUGovernor->clear();
    ui->lineEditUpThreshold->clear();
    InitCPU();
}

void MainWindow::on_pushButtonApply_clicked()
{
    struct cpufreq_policy *cur_pol = cpufreq_get_policy(ui->comboBoxCPU->currentText().toInt());
    struct cpufreq_policy *new_pol = new cpufreq_policy();
    new_pol->min = 0;
    new_pol->max = 0;
    new_pol->governor = NULL;
    new_pol->max = ui->comboBoxCPUFreq->currentText().toInt();
    new_pol->governor = ui->comboBoxCPUGovernor->currentText().toAscii().data();
    if (!cur_pol) {
        return;
    }

    if (!new_pol->min)
        new_pol->min = cur_pol->min;

    if (!new_pol->max)
        new_pol->max = cur_pol->max;

    if (!new_pol->governor)
        new_pol->governor = cur_pol->governor;

    //TODO add error check
    cpufreq_set_policy(ui->comboBoxCPU->currentText().toInt(), new_pol);

    if(strcmp(new_pol->governor,"userspace")==0)
    //{
        cpufreq_set_frequency(ui->comboBoxCPU->currentText().toInt(), new_pol->max);
        //ui->label_3->setText("Ok");
    //} else {
        //ui->label_3->setText("No");
    //}

    //TODO add error check
    if(strcmp(new_pol->governor,"ondemand")==0)
    {
        cpufreq_set_up_threshold(ui->comboBoxCPU->currentText().toInt(),ui->lineEditUpThreshold->text().toULong());
        cpufreq_set_sampling_rate(ui->comboBoxCPU->currentText().toInt(),ui->lineEditSamplingRate->text().toULong());
        if(ui->checkBoxIgnoreNiceLoad->isVisible())
            cpufreq_set_ignore_nice_load(ui->comboBoxCPU->currentText().toInt(), (int) ui->checkBoxIgnoreNiceLoad->isChecked());

        if(ui->checkBoxSmartReflex->isVisible()) {
            if(ui->checkBoxSmartReflex->isChecked()) {
                cpufreq_set_SmartReflex(3);
            } else {
                cpufreq_set_SmartReflex(0);
            }
        }
    }
    cpufreq_put_policy(cur_pol);
    free(new_pol);

    //QMessageBox::about(this,"About","hello");
    //QMessageBox::about(0, "Trolltech", "<a href='http://www.trolltech.com'>Trolltech</a>");
}

void MainWindow::on_pushButtonAbout_clicked()
{
    QMessageBox::about(this,tr("About"),tr("cpufreqUI version ") + QString(CPUFREQUI_VERSION) + tr("<br>Copyright (C) 2010 Alexander R. a.k.a. SR"));
}
