#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

#include "n900.h"

#define MAX_LINE_LEN 255

int omap_get_real_temperature()
{
    char buf[MAX_LINE_LEN];
    int value;
    char *endp;
    int fd;
    size_t numread;

    if ( ( fd = open("/sys/devices/platform/omap34xx_temp/temp1_input", O_RDONLY) ) == -1 )
            return 0;

    numread = read(fd, buf, MAX_LINE_LEN - 1);
    if ( numread < 1 )
    {
            close(fd);
            return 0;
    }

    buf[numread] = '\0';
    close(fd);

    value = strtol(buf, &endp, 0);

    if ( endp == buf || errno == ERANGE )
            return 0;

    return value;
}

int omap_get_raw_temperature()
{
    char buf[MAX_LINE_LEN];
    int value;
    char *endp;
    int fd;
    size_t numread;

    if ( ( fd = open("/sys/devices/platform/omap34xx_temp/temp1_input_raw", O_RDONLY) ) == -1 )
            return 0;

    numread = read(fd, buf, MAX_LINE_LEN - 1);
    if ( numread < 1 )
    {
            close(fd);
            return 0;
    }

    buf[numread] = '\0';
    close(fd);

    value = strtol(buf, &endp, 0);

    if ( endp == buf || errno == ERANGE )
            return 0;

    return value;
}
