/*
 * This file is part of Countdown Home Plugin.
 *
 * Copyright (C) 2009 Andrew Olmsted. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
*  
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/* countdown-home-widget.h */

#ifndef _COUNTDOWN_HOME_WIDGET
#define _COUNTDOWN_HOME_WIDGET

#include <libhildondesktop/libhildondesktop.h>
#include <time.h> /* For tm. */

G_BEGIN_DECLS

#define COUNTDOWN_TYPE_HOME_WIDGET countdown_home_widget_get_type()

#define COUNTDOWN_HOME_WIDGET(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), COUNTDOWN_TYPE_HOME_WIDGET, CountdownHomeWidget))

#define COUNTDOWN_HOME_WIDGET_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), COUNTDOWN_TYPE_HOME_WIDGET, CountdownHomeWidgetClass))

#define COUNTDOWN_IS_HOME_WIDGET(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), COUNTDOWN_TYPE_HOME_WIDGET))

#define COUNTDOWN_IS_HOME_WIDGET_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), COUNTDOWN_TYPE_HOME_WIDGET))

#define COUNTDOWN_HOME_WIDGET_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), COUNTDOWN_TYPE_HOME_WIDGET, CountdownHomeWidgetClass))

typedef struct _CountdownHomeWidget        CountdownHomeWidget;
typedef struct _CountdownHomeWidgetClass   CountdownHomeWidgetClass;
typedef struct _CountdownHomeWidgetPrivate CountdownHomeWidgetPrivate;

struct _CountdownHomeWidget
{
  HDHomePluginItem parent;

  CountdownHomeWidgetPrivate *priv;
};

struct _CountdownHomeWidgetClass
{
  HDHomePluginItemClass  parent;
};

GType countdown_home_widget_get_type (void);

G_END_DECLS

#endif /* _COUNTDOWN_HOME_WIDGET */

