#ifndef COUNTDOWN_PLUGIN_H
#define COUNTDOWN_PLUGIN_H

#include <glib-object.h>

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

#define COUNTDOWN_TYPE_PLUGIN countdown_plugin_get_type()

#define COUNTDOWN_PLUGIN(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), COUNTDOWN_TYPE_PLUGIN, CountdownPlugin))

#define COUNTDOWN_PLUGIN_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), COUNTDOWN_TYPE_PLUGIN, CountdownPluginClass))

#define COUNTDOWN_IS_PLUGIN(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), COUNTDOWN_TYPE_PLUGIN))

#define COUNTDOWN_IS_PLUGIN_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), COUNTDOWN_TYPE_PLUGIN))

#define COUNTDOWN_PLUGIN_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), COUNTDOWN_TYPE_PLUGIN, CountdownPluginClass))

typedef struct {
    HDHomePluginItem hitem;
    GtkWidget *homeWidget;
    GtkWidget *contents;
	GtkWidget *upButton, *downButton;
    GtkListStore *entries;
    guint refresh;
	guint offset;
    guint eventID;
} CountdownPlugin;

typedef struct {
  HDHomePluginItemClass parent_class;
} CountdownPluginClass;

GType countdown_plugin_get_type (void);

CountdownPlugin* countdown_plugin_new (void);

G_END_DECLS

#endif
