#include <gtk/gtk.h>
#include <glib.h>
#include <hildon/hildon.h>
 
#include <libhildondesktop/libhildondesktop.h>

#include "lib-countdown-home-widget.h"

#define HOME_DIR g_get_home_dir()

HD_DEFINE_PLUGIN_MODULE (CountdownPlugin, countdown_plugin,      HD_TYPE_HOME_PLUGIN_ITEM)

gboolean update_content (CountdownPlugin *desktop_plugin);

void writeCountdownSettings (CountdownPlugin *desktop_plugin)
{
	//g_warning ("writeCountdownSettings");
	GKeyFile *keyFile;
	gchar *fileData;
	FILE *iniFile;
	gsize size;
	GtkTreeIter iter;
	gboolean exists;
	gchar *filename;
	gint i=0;
	
	keyFile = g_key_file_new();
	exists = gtk_tree_model_get_iter_first (GTK_TREE_MODEL (desktop_plugin->entries), &iter);
	while (exists)
	{
		gchar *title, *date, *time;
		gboolean showWhich[5];
		gchar entry[5];
		snprintf(entry, 5, "%d", i++);
		gtk_tree_model_get(GTK_TREE_MODEL (desktop_plugin->entries),&iter,0,&title,1,&date,2,&time,4,&showWhich[0],5,&showWhich[1],6,&showWhich[2],7,&showWhich[3],8,&showWhich[4],-1);
		g_key_file_set_string(keyFile,entry,"title",title);
		g_key_file_set_string(keyFile,entry,"date",date);
		g_key_file_set_string(keyFile,entry,"time",time);
		g_key_file_set_boolean_list(keyFile,entry,"show",showWhich,5);
		exists=gtk_tree_model_iter_next(GTK_TREE_MODEL (desktop_plugin->entries),&iter);
		g_free(title);
		g_free(date);
		g_free(time);
	}
	
	g_key_file_set_integer (keyFile, "config", "refresh", desktop_plugin->refresh);
	
	filename = g_strconcat (HOME_DIR, "/.countdown_home.ini", NULL);
	fileData = g_key_file_to_data (keyFile, &size, NULL);
	iniFile = fopen (filename, "w");
	fputs (fileData, iniFile);
	fclose (iniFile);
	g_key_file_free (keyFile);
	g_free (fileData);
	g_free (filename);
}

void addNewCountdown_clicked(GtkButton *button, CountdownPlugin *desktop_plugin)
{
	//g_warning ("addNewCountdown_clicked");
    GtkWidget *dialog, *content_area;
    GtkWidget *titleEntry, *dateButton, *timeButton;
    GtkWidget *titleCaption, *dateCaption, *timeCaption;
    GtkWidget *toggleYears, *toggleWeeks, *toggleDays, *toggleHours, *toggleMinutes;
    GtkWidget *displayCaption;
    GtkSizeGroup *group = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);

    dialog = gtk_dialog_new_with_buttons ("Add Countdown",
        NULL, GTK_DIALOG_DESTROY_WITH_PARENT,
        "Save", GTK_RESPONSE_ACCEPT, NULL);
    content_area = gtk_dialog_get_content_area (GTK_DIALOG (dialog));
    
    titleEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
    hildon_entry_set_placeholder (HILDON_ENTRY (titleEntry), "What do you want to call this?");
    titleCaption = hildon_caption_new (group, "Title", titleEntry, NULL, HILDON_CAPTION_MANDATORY);
	hildon_caption_set_separator (HILDON_CAPTION (titleCaption), "");
    gtk_container_add (GTK_CONTAINER (content_area), titleCaption);

    dateButton = hildon_date_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_title_alignment (HILDON_BUTTON (dateButton), 0.5, 0.5);
    hildon_button_set_value_alignment (HILDON_BUTTON (dateButton), 0.5, 0.5);
    dateCaption = hildon_caption_new (group, "Date", dateButton, NULL, HILDON_CAPTION_MANDATORY);
	hildon_caption_set_separator (HILDON_CAPTION (dateCaption), "");
    gtk_container_add (GTK_CONTAINER (content_area), dateCaption);

    timeButton = hildon_time_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_title_alignment (HILDON_BUTTON (timeButton), 0.5, 0.5);
    hildon_button_set_value_alignment (HILDON_BUTTON (timeButton), 0.5, 0.5);
    timeCaption = hildon_caption_new (group, "Time", timeButton, NULL, HILDON_CAPTION_MANDATORY);
	hildon_caption_set_separator (HILDON_CAPTION (timeCaption), "");
    gtk_container_add (GTK_CONTAINER (content_area), timeCaption);

    GtkHBox *hbox = GTK_HBOX (gtk_hbox_new (0, FALSE));
    toggleYears = gtk_toggle_button_new_with_label ("Year");
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggleYears), TRUE);
    toggleWeeks = gtk_toggle_button_new_with_label ("Week");
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggleWeeks), TRUE);
    toggleDays = gtk_toggle_button_new_with_label ("Day");
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggleDays), TRUE);
    toggleHours = gtk_toggle_button_new_with_label ("Hour");
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggleHours), TRUE);
    toggleMinutes = gtk_toggle_button_new_with_label ("Minute");
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggleMinutes), TRUE);
    gtk_container_add (GTK_CONTAINER (hbox), toggleYears);
    gtk_container_add (GTK_CONTAINER (hbox), toggleWeeks);
    gtk_container_add (GTK_CONTAINER (hbox), toggleDays);
    gtk_container_add (GTK_CONTAINER (hbox), toggleHours);
    gtk_container_add (GTK_CONTAINER (hbox), toggleMinutes);
    displayCaption = hildon_caption_new (group, "Display", GTK_WIDGET (hbox), NULL, HILDON_CAPTION_MANDATORY);
	hildon_caption_set_separator (HILDON_CAPTION (displayCaption), "");
    gtk_container_add (GTK_CONTAINER (content_area), displayCaption);
    
    gtk_widget_show_all (dialog);

    int response=gtk_dialog_run (GTK_DIALOG (dialog));
    if (response == GTK_RESPONSE_ACCEPT)
    {
        const gchar *title = hildon_entry_get_text (HILDON_ENTRY (titleEntry));
        guint year, month, day;
        guint hours, minutes;
        gboolean tYears, tWeeks, tDays, tHours, tMinutes;
        gchar *printDate, *printTime, *compTime;
		GtkTreeIter iter;

        hildon_date_button_get_date (HILDON_DATE_BUTTON (dateButton), &year, &month, &day);
        hildon_time_button_get_time (HILDON_TIME_BUTTON (timeButton), &hours, &minutes);

        printDate = g_strdup_printf ("%02d/%02d/%02d",year,month+1,day);
        printTime = g_strdup_printf ("%02d:%02d", hours, minutes);
        compTime = g_strdup_printf ("%d", hours*(60*60) + minutes*60);

        tYears = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (toggleYears));
        tWeeks = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (toggleWeeks));
        tDays = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (toggleDays));
        tMinutes = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (toggleMinutes));
        tHours = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (toggleHours));

		gtk_list_store_append (GTK_LIST_STORE (desktop_plugin->entries), &iter);
		gtk_list_store_set (GTK_LIST_STORE (desktop_plugin->entries), &iter, 0, title, 1, printDate, 2, compTime, 3, printTime, -1);
		gtk_list_store_set (GTK_LIST_STORE (desktop_plugin->entries), &iter, 4, tYears, 5, tWeeks, 6, tDays, 7, tHours, 8, tMinutes, -1);

        g_free (printDate);
        g_free (printTime);
        g_free (compTime);
		
		writeCountdownSettings (desktop_plugin);
		update_content (desktop_plugin);
    }
    gtk_widget_destroy (dialog);
}

void modifyCountdown_clicked (GtkButton *button, CountdownPlugin *desktop_plugin)
{
	//g_warning ("modifyCoundown_clicked");
	gint index = g_ascii_strtoll (gtk_widget_get_name (GTK_WIDGET (button)), NULL, 10);
	GtkWidget *dialog, *content_area;
    GtkWidget *titleEntry, *dateButton, *timeButton;
    GtkWidget *titleCaption, *dateCaption, *timeCaption;
    GtkWidget *toggleYears, *toggleWeeks, *toggleDays, *toggleHours, *toggleMinutes;
    GtkWidget *displayCaption;
    GtkSizeGroup *group = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);

    dialog = gtk_dialog_new_with_buttons ("Edit Countdown",
        NULL, GTK_DIALOG_DESTROY_WITH_PARENT,
        "Save", GTK_RESPONSE_ACCEPT, "Delete", GTK_RESPONSE_NO, NULL);
    content_area = gtk_dialog_get_content_area (GTK_DIALOG (dialog));
    
    titleEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
    hildon_entry_set_placeholder (HILDON_ENTRY (titleEntry), "What do you want to call this?");
    titleCaption = hildon_caption_new (group, "Title", titleEntry, NULL, HILDON_CAPTION_MANDATORY);
	hildon_caption_set_separator (HILDON_CAPTION (titleCaption), "");
    gtk_container_add (GTK_CONTAINER (content_area), titleCaption);

    dateButton = hildon_date_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_title_alignment (HILDON_BUTTON (dateButton), 0.5, 0.5);
    hildon_button_set_value_alignment (HILDON_BUTTON (dateButton), 0.5, 0.5);
    dateCaption = hildon_caption_new (group, "Date", dateButton, NULL, HILDON_CAPTION_MANDATORY);
	hildon_caption_set_separator (HILDON_CAPTION (dateCaption), "");
    gtk_container_add (GTK_CONTAINER (content_area), dateCaption);

    timeButton = hildon_time_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_title_alignment (HILDON_BUTTON (timeButton), 0.5, 0.5);
    hildon_button_set_value_alignment (HILDON_BUTTON (timeButton), 0.5, 0.5);
    timeCaption = hildon_caption_new (group, "Time", timeButton, NULL, HILDON_CAPTION_MANDATORY);
	hildon_caption_set_separator (HILDON_CAPTION (timeCaption), "");
    gtk_container_add (GTK_CONTAINER (content_area), timeCaption);

    GtkHBox *hbox = GTK_HBOX (gtk_hbox_new (0, FALSE));
    toggleYears = gtk_toggle_button_new_with_label ("Year");
    toggleWeeks = gtk_toggle_button_new_with_label ("Week");
    toggleDays = gtk_toggle_button_new_with_label ("Day");
    toggleHours = gtk_toggle_button_new_with_label ("Hour");
    toggleMinutes = gtk_toggle_button_new_with_label ("Minute");
    gtk_container_add (GTK_CONTAINER (hbox), toggleYears);
    gtk_container_add (GTK_CONTAINER (hbox), toggleWeeks);
    gtk_container_add (GTK_CONTAINER (hbox), toggleDays);
    gtk_container_add (GTK_CONTAINER (hbox), toggleHours);
    gtk_container_add (GTK_CONTAINER (hbox), toggleMinutes);
    displayCaption = hildon_caption_new (group, "Display", GTK_WIDGET (hbox), NULL, HILDON_CAPTION_MANDATORY);
	hildon_caption_set_separator (HILDON_CAPTION (displayCaption), "");
    gtk_container_add (GTK_CONTAINER (content_area), displayCaption);
    
	GtkTreeIter iter;
	if (gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (desktop_plugin->entries), &iter, NULL, index))
	{
		gchar *titleText, *dateText, *timeText;
		gboolean tYears, tWeeks, tDays;
		gboolean tHours, tMinutes;
		gint year, month, day;
		gint hour, minute;
		GDate date;
		gint time;
		
		gtk_tree_model_get (GTK_TREE_MODEL (desktop_plugin->entries), &iter, 0, &titleText, 1, &dateText, 2, &timeText, 4, &tYears, 5, &tWeeks, 6, &tDays, 7, &tHours, 8, &tMinutes, -1);
		
		g_date_set_parse (&date, dateText);
		year = g_date_get_year (&date);
		month = g_date_get_month (&date) - 1;
		day = g_date_get_day (&date);
		time = g_ascii_strtoll (timeText, NULL, 10);
		hour = time/(60 *60);
		minute = time/60 - hour*60;
		
		hildon_entry_set_text (HILDON_ENTRY (titleEntry), titleText);
		hildon_date_button_set_date (HILDON_DATE_BUTTON (dateButton), year, month, day);
		hildon_time_button_set_time (HILDON_TIME_BUTTON (timeButton), hour, minute);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggleYears), tYears);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggleWeeks), tWeeks);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggleDays), tDays);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggleHours), tHours);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggleMinutes), tMinutes);
	}
	
    gtk_widget_show_all (dialog);

    int response=gtk_dialog_run (GTK_DIALOG (dialog));
    if (response == GTK_RESPONSE_ACCEPT)
    {
        const gchar *title = hildon_entry_get_text (HILDON_ENTRY (titleEntry));
        guint year, month, day;
        guint hours, minutes;
        gboolean tYears, tWeeks, tDays, tHours, tMinutes;
        gchar *printDate, *printTime, *compTime;
		GtkTreeIter iter;

        hildon_date_button_get_date (HILDON_DATE_BUTTON (dateButton), &year, &month, &day);
        hildon_time_button_get_time (HILDON_TIME_BUTTON (timeButton), &hours, &minutes);

        printDate = g_strdup_printf ("%02d/%02d/%02d",year,month+1,day);
        printTime = g_strdup_printf ("%02d:%02d", hours, minutes);
        compTime = g_strdup_printf ("%d", hours*(60*60) + minutes*60);

        tYears = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (toggleYears));
        tWeeks = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (toggleWeeks));
        tDays = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (toggleDays));
        tMinutes = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (toggleMinutes));
        tHours = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (toggleHours));

		if (gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (desktop_plugin->entries), &iter, NULL, index))
		{
			gtk_list_store_set (GTK_LIST_STORE (desktop_plugin->entries), &iter, 0, title, 1, printDate, 2, compTime, 3, printTime, -1);
			gtk_list_store_set (GTK_LIST_STORE (desktop_plugin->entries), &iter, 4, tYears, 5, tWeeks, 6, tDays, 7, tHours, 8, tMinutes, -1);
		}

        g_free (printDate);
        g_free (printTime);
        g_free (compTime);
		
		writeCountdownSettings (desktop_plugin);
		update_content (desktop_plugin);
    }
	else if (response == GTK_RESPONSE_NO)
	{
		if (gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (desktop_plugin->entries), &iter, NULL, index))
		{
			gtk_list_store_remove (desktop_plugin->entries, &iter);
		}
		writeCountdownSettings (desktop_plugin);
		update_content (desktop_plugin);
	}
    gtk_widget_destroy (dialog);
}

void selection_changed (HildonTouchSelector *selector, GtkWidget *button)
{
	gchar *current_selection = NULL;
	current_selection = hildon_touch_selector_get_current_text (selector);
	hildon_button_set_title (HILDON_BUTTON (button), g_strconcat (current_selection, " minute(s)", NULL));
	g_free (current_selection);
}

void globalOptions (HDHomePluginItem *hitem, CountdownPlugin *desktop_plugin)
{
	//g_warning ("globalOptions");
    GtkWidget *dialog, *content_area;
    GtkWidget *refreshButton;
    GtkWidget *refreshCaption;
    GtkSizeGroup *group = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);

    dialog = gtk_dialog_new_with_buttons ("Global Countdown Settings",
        NULL, GTK_DIALOG_DESTROY_WITH_PARENT,
        "Save", GTK_RESPONSE_ACCEPT, NULL);
    content_area = gtk_dialog_get_content_area (GTK_DIALOG (dialog));
    
	GtkWidget *selector = hildon_touch_selector_new_text ();
	
	int i;
	for (i=0; i<=60; i++)
	{
		gchar *text = g_strdup_printf ("%d", i);
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), text);
	}
	
	hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, desktop_plugin->refresh);
	
	refreshButton = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
	gchar *current_selection = hildon_touch_selector_get_current_text (HILDON_TOUCH_SELECTOR (selector));
	hildon_button_set_title (HILDON_BUTTON (refreshButton), g_strconcat (current_selection, " minute(s)", NULL));
	g_signal_connect (G_OBJECT (selector), "changed", G_CALLBACK (selection_changed), refreshButton);
	
	hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (refreshButton), HILDON_TOUCH_SELECTOR (selector));
	
	refreshCaption = hildon_caption_new (group, "Update every", refreshButton, NULL, HILDON_CAPTION_MANDATORY);
	hildon_caption_set_separator (HILDON_CAPTION (refreshCaption), "");
	
    gtk_container_add (GTK_CONTAINER (content_area), refreshCaption);

    gtk_widget_show_all (dialog);

    int response=gtk_dialog_run (GTK_DIALOG (dialog));
    if (response == GTK_RESPONSE_ACCEPT)
    {
        desktop_plugin->refresh = hildon_picker_button_get_active (HILDON_PICKER_BUTTON (refreshButton));
		
		if (desktop_plugin->eventID != 0)
		{
			g_source_remove (desktop_plugin->eventID);
			if (desktop_plugin->refresh > 0)
				desktop_plugin->eventID = g_timeout_add (desktop_plugin->refresh*1000*60, (GSourceFunc)update_content, desktop_plugin);
		}
		
		writeCountdownSettings (desktop_plugin);
		update_content (desktop_plugin);
    }
    gtk_widget_destroy (dialog);
}
 
void setup_make_view ( CountdownPlugin *desktop_plugin )
{
	//g_warning("setup_make_view");	
    gchar *filename;
    gboolean fileExists;
    GKeyFile *keyFile;
    GtkTreeIter iter;

	desktop_plugin->entries = gtk_list_store_new (9, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);

    keyFile = g_key_file_new();
    filename = g_strconcat (HOME_DIR, "/.countdown_home.ini", NULL);
    fileExists = g_key_file_load_from_file (keyFile, filename, G_KEY_FILE_KEEP_COMMENTS, NULL);

    if (fileExists)
    {
        int i=0;
        gchar *entry;
        gboolean found;
        GError *error=NULL;
        entry = g_strdup_printf ("%d", i);
        found = g_key_file_has_group (keyFile, entry);
        while (found)
        {
            gchar *title, *date, *time, *readableTime;
            guint seconds, minutes, hours;
            gboolean *showWhich;
            gsize length;

            sprintf (entry, "%d", i);
			title=g_key_file_get_string(keyFile,entry,"title",&error);
			if (error)
			{
				title="TITLE MISSING!";
			g_error_free(error);
			error=NULL;
			}
			date=g_key_file_get_string(keyFile,entry,"date",&error);
			if (error)
			{
				date="INCORRECT DATE!";
			g_error_free(error);
			error=NULL;
			}
			time=g_key_file_get_string(keyFile,entry,"time",&error);
			if (error)
			{
				time="0";
				g_error_free(error);
				error=NULL;
			}
			showWhich=g_key_file_get_boolean_list(keyFile,entry,"show",&length,&error);
			if (error)
			{
				gboolean show[5]={TRUE,TRUE,TRUE,TRUE,TRUE};
				showWhich=show;
				g_error_free(error);
				error=NULL;
			}

			seconds=g_ascii_strtoll(time,NULL,10);
			hours=seconds/(60*60);
			minutes=seconds/(60)-(hours*60);
			readableTime=g_strdup_printf("%02d:%02d",hours,minutes);
			
			//g_warning("added entry from keyFile... title: %s", title);
			
			gtk_list_store_append(desktop_plugin->entries, &iter);
			gtk_list_store_set(desktop_plugin->entries, &iter,0,title,1,date,2,time,3,readableTime,4,showWhich[0],5,showWhich[1],6,showWhich[2],7,showWhich[3],8,showWhich[4],-1);
			snprintf(entry,5,"%d",++i);
			found=g_key_file_has_group(keyFile,entry);
			g_free(readableTime);
			g_free(title);
			g_free(date);
			g_free(time);
			g_free(showWhich);
        }
        desktop_plugin->refresh = g_key_file_get_integer (keyFile, "config", "refresh", &error);
        if (error)
        {
            desktop_plugin->refresh = 1;
            g_error_free (error);
            error = NULL;
        }
    }
    else
    {
        desktop_plugin->refresh = 1;
    }

    g_key_file_free (keyFile);
    g_free (filename);
}

void countdown_scroll_up (GtkButton *button, CountdownPlugin *desktop_plugin)
{
	//g_warning ("countdown_scroll_up");
	desktop_plugin->offset--;
	update_content (desktop_plugin);
}

void countdown_scroll_down (GtkButton *button, CountdownPlugin *desktop_plugin)
{
	//g_warning ("countdown_scroll_down");
	desktop_plugin->offset++;
	update_content (desktop_plugin);
}

void countdown_content_create (CountdownPlugin *desktop_plugin)
{
	//g_warning ("countdown_content_create");
    desktop_plugin->contents = gtk_vbox_new (0, FALSE);
	GtkVBox *scrollArea = GTK_VBOX (gtk_vbox_new (0, TRUE));
    //GtkLabel *label = GTK_LABEL (gtk_label_new ("Countdown widget"));

    GtkWidget *addNewCountdown;
    addNewCountdown = hildon_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_AUTO_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_text (HILDON_BUTTON (addNewCountdown), "Create new", NULL);

    GtkHBox *buttons = GTK_HBOX (gtk_hbox_new (0, TRUE));
	GtkHBox *hbox = GTK_HBOX (gtk_hbox_new (0, TRUE));
	gtk_box_pack_start (GTK_BOX (hbox), desktop_plugin->contents, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), GTK_WIDGET (scrollArea), FALSE, FALSE, 0);
	
	desktop_plugin->upButton = gtk_button_new ();
	desktop_plugin->downButton = gtk_button_new ();
	g_signal_connect (desktop_plugin->upButton, "clicked", G_CALLBACK (countdown_scroll_up), desktop_plugin);
	g_signal_connect (desktop_plugin->downButton, "clicked", G_CALLBACK (countdown_scroll_down), desktop_plugin);
	
	gtk_button_set_image (GTK_BUTTON (desktop_plugin->upButton), gtk_image_new_from_stock (GTK_STOCK_GO_UP, HILDON_ICON_SIZE_FINGER));
	gtk_button_set_image (GTK_BUTTON (desktop_plugin->downButton), gtk_image_new_from_stock (GTK_STOCK_GO_DOWN, HILDON_ICON_SIZE_FINGER));
	gtk_box_pack_start (GTK_BOX (scrollArea), desktop_plugin->upButton, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (scrollArea), desktop_plugin->downButton, TRUE, TRUE, 0);
	
    gtk_container_add (GTK_CONTAINER (buttons), GTK_WIDGET (addNewCountdown));
    
    g_signal_connect (addNewCountdown, "clicked", G_CALLBACK (addNewCountdown_clicked), desktop_plugin);
    
    //gtk_box_pack_start (GTK_BOX (desktop_plugin->homeWidget), GTK_WIDGET (label), FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (desktop_plugin->homeWidget), GTK_WIDGET (hbox), FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (desktop_plugin->homeWidget), GTK_WIDGET (buttons), FALSE, FALSE, 0);
    gtk_widget_show_all (desktop_plugin->homeWidget);
	gtk_widget_hide (desktop_plugin->upButton);
	gtk_widget_hide (desktop_plugin->downButton);
}

gboolean update_content (CountdownPlugin *desktop_plugin)
{
	//g_warning ("update_content");
	GtkWidget *vbox;
	GDate *startDate=NULL, *endDate=NULL;
	gint startSec=0, endSec=0;
	time_t now;
	struct tm *timeinfo;
	GtkTreeIter iter;
	gint count=0, totalRows=0;
	gboolean exists=FALSE;
	GtkSizeGroup *titleGroup, *valueGroup;
	titleGroup = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	valueGroup = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	
	startDate = g_date_new();
	time (&now);
	g_date_set_time_t (startDate, now);
	timeinfo = localtime (&now);
	startSec = timeinfo->tm_hour*(60*60) + timeinfo->tm_min*60;
	
	endDate = g_date_new ();

	vbox = gtk_vbox_new (FALSE, 0);
	
	totalRows=gtk_tree_model_iter_n_children (GTK_TREE_MODEL (desktop_plugin->entries), NULL);
	if (totalRows <= 3)
	{
		desktop_plugin->offset = 0;
	}
	
	exists = gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (desktop_plugin->entries), &iter, NULL, desktop_plugin->offset);
	while (exists)
	{
		GtkWidget *countdownButton;
		gchar *title="", *date="", *time="";
		gint years=0, weeks=0, days=0;
		gint hours=0, minutes=0, seconds=0;
		gint totDays=0;
		gboolean showYears, showWeeks, showDays;
		gboolean showHours, showMinutes;
		gchar *tempContent="";
		gchar **content = g_new0 (gchar*, 6);
		gchar *contentLabelText="";
		gint index=0;
		gchar *tail="";
		gboolean firstShown;
		
		gtk_tree_model_get (GTK_TREE_MODEL (desktop_plugin->entries), &iter, 0, &title, 1, &date, 2, &time, 4, &showYears, 5, &showWeeks, 6, &showDays, 7, &showHours, 8, &showMinutes, -1);

		seconds = g_ascii_strtoll (time, NULL,  10);
		
		g_date_set_parse (endDate, date);
		if (!g_date_valid (endDate))
		{
			title = g_strconcat (content[index++], "(INCORRECT DATE!)", NULL);
			totDays = 0;
		}
		else
		{
			totDays = g_date_days_between (startDate, endDate);
		}
		
		endSec = seconds;
		seconds = endSec-startSec;
		
		if (totDays > 0)
		{
			tail = g_strdup_printf ("left");
			if (seconds < 0)
			{
				totDays--;
				seconds = (60*60*24)+seconds;
			}
		}
		else if (totDays < 0)
		{
			tail = g_strdup_printf ("ago");
			if (seconds > 0)
			{
				totDays++;
				seconds = (60*60*24)-seconds;
			}
		}
		else
		{
			if (seconds < 0)
			{
				tail = g_strdup_printf ("ago");
			}
			else
			{
				tail = g_strdup_printf ("left");
			}
		}
		
		firstShown = FALSE;

		totDays=ABS(totDays);
		seconds=ABS(seconds);
		
		if (showYears)
		{
			years=totDays/365;
			if ((firstShown)||(years!=0)||((!showWeeks)&&(!showDays)&&(!showHours)&&(!showMinutes)))
			{
				firstShown = TRUE;
				tempContent = g_strdup_printf ("%d", ABS (years));
				content[index++] = g_strconcat (tempContent, " years ", NULL);
				g_free (tempContent);
			}
		}
		if (showWeeks)
		{
			weeks = (totDays-(years*365))/7;
			if ((firstShown)||(weeks!=0)||((!showDays)&&(!showHours)&&(!showMinutes)))
			{
				firstShown = TRUE;
				tempContent = g_strdup_printf ("%d", ABS (weeks));
				content[index++] = g_strconcat (tempContent, " weeks ", NULL);
				g_free (tempContent);
			}
		}
		if (showDays)
		{
			days = totDays-(weeks*7)-(years*365);
			if ((firstShown)||(days!=0)||((!showHours)&&(!showMinutes)))
			{
				firstShown = TRUE;
				tempContent = g_strdup_printf ("%d", ABS (days));
				content[index++] = g_strconcat (tempContent, " days ", NULL);
				g_free (tempContent);
			}
		}
		if (showHours)
		{
			hours = ((totDays-(days+(weeks*7)+(years*365)))*(24))+seconds/(60*60);
			if ((firstShown)||(hours!=0)||(!showMinutes))
			{
				firstShown = TRUE;
				tempContent = g_strdup_printf ("%d", ABS (hours));
				content[index++] = g_strconcat (tempContent, " hours ", NULL);
				g_free (tempContent);
			}
		}
		if (showMinutes)
		{
			minutes=((totDays-(days+(weeks*7)+(years*365)))*(24*60))+((seconds/60)-(hours*60));
			firstShown = TRUE;
			tempContent = g_strdup_printf ("%d", ABS (minutes));
			content[index++] = g_strconcat (tempContent, " mins ", NULL);
			g_free (tempContent);
		}
		content[index] = g_strconcat (tail, NULL);
		
		countdownButton = hildon_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_AUTO_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
		contentLabelText = g_strjoinv (NULL, content);
		hildon_button_set_text (HILDON_BUTTON (countdownButton), title, contentLabelText);
		hildon_button_set_title_alignment (HILDON_BUTTON (countdownButton), 0.0, 0.5);
		hildon_button_set_value_alignment (HILDON_BUTTON (countdownButton), 0.0, 0.5);
		hildon_button_add_size_groups (HILDON_BUTTON (countdownButton), titleGroup, valueGroup, NULL);
		gtk_window_set_opacity (gtk_widget_get_ancestor (countdownButton, GTK_TYPE_WINDOW), 0.5);
		
		g_signal_connect (countdownButton, "clicked", G_CALLBACK (modifyCountdown_clicked), desktop_plugin);
		
		gtk_box_pack_start (GTK_BOX (vbox), countdownButton, FALSE, FALSE, 0);
		g_free (contentLabelText);
		
		gchar *name=g_strdup_printf("%d",count++);
		
		gtk_widget_set_name (countdownButton, name);
		
		g_free (title);
		g_free (date);
		g_free (time);
		g_free (name);
		g_free (tail);
		g_strfreev (content);
		
		exists = gtk_tree_model_iter_next (GTK_TREE_MODEL (desktop_plugin->entries), &iter);
		if (exists)
		{
			if (count >= 3)
			{
				exists = FALSE;
			}
		}
	}

	if (totalRows > 3)
	{
		gtk_widget_show (desktop_plugin->downButton);
		gtk_widget_show (desktop_plugin->upButton);
		
		if (desktop_plugin->offset == 0)
		{
			gtk_widget_set_sensitive (desktop_plugin->upButton, FALSE);
		}
		else
		{
			gtk_widget_set_sensitive (desktop_plugin->upButton, TRUE);
		}
		
		if (desktop_plugin->offset + 3 >= totalRows)
		{
			gtk_widget_set_sensitive (desktop_plugin->downButton, FALSE);
		}
		else
		{
			gtk_widget_set_sensitive (desktop_plugin->downButton, TRUE);
		}
	}
	else
	{
		gtk_widget_hide (desktop_plugin->downButton);
		gtk_widget_hide (desktop_plugin->upButton);
	}

	gtk_container_foreach (GTK_CONTAINER (desktop_plugin->contents), (GtkCallback) gtk_widget_destroy, NULL);
	gtk_container_add (GTK_CONTAINER (desktop_plugin->contents), vbox);
	gtk_widget_show_all (desktop_plugin->contents);
	
	g_date_free (startDate);
	g_date_free (endDate);

	return TRUE;
}

static void
countdown_plugin_check_desktop (GObject *gobject, GParamSpec *pspec, CountdownPlugin *desktop_plugin)
{
	//g_warning ("countdown_plugin_expose");
	gchar *name = pspec->name;
	gboolean status;
	g_object_get (gobject, name, &status, NULL);
	if (status)
	{
		update_content (desktop_plugin);
		if (desktop_plugin->eventID == 0)
		{
			if (desktop_plugin->refresh > 0)
				desktop_plugin->eventID = g_timeout_add (desktop_plugin->refresh*1000*60, (GSourceFunc)update_content, desktop_plugin);
		}
	}
	else if (desktop_plugin->eventID != 0)
	{
		g_source_remove (desktop_plugin->eventID);
		desktop_plugin->eventID = 0;
	}
}

static void
countdown_plugin_realize (GtkWidget *widget)
{
	GdkScreen *screen;

	screen = gtk_widget_get_screen (widget);
	gtk_widget_set_colormap (widget,
				   gdk_screen_get_rgba_colormap (screen));

	gtk_widget_set_app_paintable (widget,
						TRUE);

	GTK_WIDGET_CLASS(g_type_class_peek_parent
				 (GTK_FRAME_GET_CLASS(widget)))->realize(widget);
}

static gboolean
countdown_plugin_expose_event (GtkWidget *widget, GdkEventExpose *event)
{
	//g_warning ("countdown_plugin_expose_event");
	cairo_t *cr;
	
	if (GTK_WIDGET_DRAWABLE(widget) == FALSE){
		return FALSE;
	}

	//g_warning ("continuing...");
    /* Create cairo context */
    cr = gdk_cairo_create (GDK_DRAWABLE (widget->window));
    gdk_cairo_region (cr, event->region);
    cairo_clip (cr);

    /* Draw alpha background */
    cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
    cairo_set_source_rgba (cr, 0.0, 0.0, 0.0, 0.0);
    cairo_paint (cr);

    /* Free context */
    cairo_destroy (cr);
	
	return GTK_WIDGET_CLASS(g_type_class_peek_parent
                         (GTK_FRAME_GET_CLASS(widget)))->expose_event(widget, event);
	//return TRUE;
}

static void
countdown_plugin_finalize (GObject *object)
{
	//g_warning ("countdown_plugin_finalize");
	CountdownPlugin *desktop_plugin = COUNTDOWN_PLUGIN (object);
	if (desktop_plugin->eventID)
	{
		g_source_remove (desktop_plugin->eventID);
	}
	G_OBJECT_CLASS (countdown_plugin_parent_class)->finalize (object);
}

static void
countdown_plugin_init (CountdownPlugin *desktop_plugin)
{
	//g_warning ("countdown_plugin_init");
	//GdkScreen *screen = gtk_widget_get_screen (GTK_WIDGET (desktop_plugin));
	//gtk_widget_set_colormap (GTK_WIDGET (desktop_plugin), gdk_screen_get_rgba_colormap (screen));
	//gtk_widget_set_app_paintable (GTK_WIDGET (desktop_plugin), TRUE);
	desktop_plugin->offset = 0;
	desktop_plugin->eventID = 0;
	hd_home_plugin_item_set_settings (&desktop_plugin->hitem, TRUE);
	g_signal_connect (&desktop_plugin->hitem, "show-settings", G_CALLBACK (globalOptions), desktop_plugin);
	
	desktop_plugin->homeWidget = gtk_vbox_new (0, FALSE);
	gtk_container_add (GTK_CONTAINER (desktop_plugin), desktop_plugin->homeWidget);
	gtk_widget_show_all (desktop_plugin->homeWidget);
	//gtk_widget_set_size_request (GTK_WIDGET (desktop_plugin), 300, 300);

	setup_make_view (desktop_plugin);
	g_object_ref (desktop_plugin->entries);

	countdown_content_create (desktop_plugin);
	//update_content(desktop_plugin);
	//if (desktop_plugin->refresh > 0)
	//	desktop_plugin->eventID = g_timeout_add (desktop_plugin->refresh*1000*60, (GSourceFunc)update_content, desktop_plugin);

	g_signal_connect (&desktop_plugin->hitem, "notify::is-on-current-desktop", G_CALLBACK (countdown_plugin_check_desktop), desktop_plugin);
	//g_signal_connect (&desktop_plugin->hitem, "destroy", G_CALLBACK (countdown_plugin_finalize), desktop_plugin);
}

static void
countdown_plugin_class_init (CountdownPluginClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);
  GtkWidgetClass *widget_class = GTK_WIDGET_CLASS (klass);

  object_class->finalize = countdown_plugin_finalize;
 
  //widget_class->realize = countdown_plugin_realize;
  //widget_class->expose_event = countdown_plugin_expose_event;
}

static void
countdown_plugin_class_finalize (CountdownPluginClass *class) {
	//g_warning ("countdown_plugin_class_finalize");
	
} 
