--[[ Copyright (c) 2010 lwglwsss

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE. --]]

-- Note: This file contains UTF-8 text. Make sure your editor is set to UTF-8.

Language("Simplified Chinese", "zh", "chi", "zho")
Inherit("english")
Inherit("original_strings", 0)

-- override


-- new strings


fax = {
  welcome = {
    beta1 = {
     utf8 "欢迎来到CorsixTH，牛蛙经典游戏主题医院的一个开源复刻版。",
     utf8 "这是可玩的beta 1 CorsixTH。很多房间，疾病和功能已经实现，但仍有许多未完成的事情。",
     utf8 "如果你喜欢这个项目，您可以帮助我们开发，通过报告bug或者自己写一些代码。",
     utf8 "不过现在，先玩游戏吧！对于那些不熟悉主题医院操作的：从布置走廊菜单中订购接待台和建造一般诊断室，还要建造必要的各种治疗室。",
     "-- The CorsixTH team, th.corsix.org",
     utf8 "PS：你能找到彩蛋吗？",
    },
    beta2 = {
     utf8 "欢迎来到beta 2的CorsixTH，牛蛙经典游戏主题医院的一个开源复刻版。",
     utf8 "自上一个版本以来很多的新功能已开始实现。可以看一下未完成功能列表的更新日志。",
     utf8 "不过首先玩游戏吧！会有一条消息等着你。先关闭这个对话框然后点一下底部面板冒出来的问号。",
     "-- The CorsixTH team, th.corsix.org",
    },
  },
  tutorial = {
   utf8 "欢迎来到你的第一座医院！",
   utf8 "你需要教程吗？",
   utf8 "是的，我需要教程。",
   utf8 "不，我已经知道怎么做了。",
  },
}

misc.not_yet_implemented = utf8 "(未完成)"
misc.no_heliport = utf8 "要么没有疾病尚未被发现，或地图上没有直升机场。"

main_menu = {
  new_game = utf8 "新游戏",
  custom_level = utf8 "自定义关卡",
  load_game = utf8 "读取游戏",
  options = utf8 "选项",
  exit = utf8 "退出",
}

tooltip.main_menu = {
  new_game = utf8 "开始一个全新的游戏",
  custom_level = utf8 "通过自定义关卡打造您的医院",
  load_game = utf8 "读取已保存的游戏",
  options = utf8 "调整各种设置",
  exit = utf8 "不要退啊！",
}

load_game_window = {
  back = utf8 "返回",
}

tooltip.load_game_window = {
  load_game_number = utf8 "读取游戏 %d",
  load_autosave = utf8 "读取自动存盘",
  back = utf8 "关闭读取游戏窗口",
}

errors = {
  dialog_missing_graphics = utf8 "对不起，演示数据文件不包含此对话框。",
  save_prefix = utf8 "存储游戏出错",
  load_prefix = utf8 "读取游戏出错",
}

totd_window = {
  tips = {
   utf8 "每个医院开张需要一个接待台和一个一般诊断室。此后，它取决于什么样的病人去看望您的医院。药房始终是一个不错的选择。",
   utf8 "类似充气机的设备需要维护。聘请一两个勤杂工去修理你的机器，否则你的员工会有危险，病人会受到伤害。",
   utf8 "过了一会儿，你的员工会感到累。一定要建立一个员工休息室，这样他们就可以放松。",
   utf8 "放足够的暖气，让您的员工和病人温暖，否则他们将不高兴。",
   utf8 "一个医生的技术水平极大地影响了他的诊断质量和速度。放一个专家在一般诊断室，你就不会需要很多额外的诊断室。",
   utf8 "实习医生，医生可以通过专家培训在培训室学习改善他们的技术。如果专家具有特殊资格（外科医生，精神病医生或研究人员），他还将在这方面的知识传递给他的学生。",
   utf8 "你想通过传真机拨欧洲紧急电话号码(112)？确保您的声音开着。",
   utf8 "选项菜单尚未实现，但你可以通过游戏目录下的config.txt调整如分辨率和语言的一些设置。",
   utf8 "你选择了英语以外的语言，但在游戏里有很多英文吗？帮助我们把它翻译成您的语言！",
   utf8 "CorsixTH团队正在寻找增援！你感兴趣编码，翻译或制作图形吗？通过我们的论坛，邮件列表或IRC频道(corsix-th)联系我们。",
   utf8 "如果你找到了bug，请在这里报告bug：th-issues.corsix.org",
   utf8 "CorsixTH首次公布于2009年7月24日。在2009年12月24日，第一次放出可玩的beta 1 。经过3个月（2010年3月24日），我们很自豪的放出beta 2。",
  },
  previous = utf8 "上一个提示",
  next = utf8 "下一个提示",
}

tooltip.totd_window = {
  previous = utf8 "显示上一个提示",
  next = utf8 "显示下一个提示",
}


misc = {
  hospital_open = utf8 "医院开门",
  save_success = utf8 "游戏存档成功",
  save_failed = utf8 "错误：无法存档",
  low_res = utf8 "低清晰度",
  grade_adverb = {
    extremely = utf8 "极端的",
    mildly = utf8 "柔和的",
    moderately = utf8 "适当的",
  },
  send_message = utf8 "向玩家%d发送信息",
  out_of_sync = utf8 "游戏失去同步",
  balance = utf8 "难度选择：",
  load_failed = utf8 "存档游戏没有被读取",
  mouse = utf8 "老鼠",
  done = utf8 "完成",
  force = utf8 "力量",
  pause = utf8 "暂停",
  send_message_all = utf8 "向所有玩家发送信息",
}
staff_descriptions = {
  good = {
    [1] = utf8 "手脚勤快并努力的员工。",
    [2] = utf8 "很有责任心。非常细心。",
    [3] = utf8 "掌握了很多技术。",
    [4] = utf8 "很友善并爱笑。",
    [5] = utf8 "富有活力。",
    [6] = utf8 "很有礼貌并和蔼可亲。",
    [7] = utf8 "富有才干和能力。",
    [8] = utf8 "工作能力极强。",
    [9] = utf8 "意志坚强。",
    [10] = utf8 "微笑着为病人服务。",
    [11] = utf8 "迷人的，有礼貌的并爱帮助别人。",
    [12] = utf8 "专注于工作。",
    [13] = utf8 "本性善良，工作努力。",
    [14] = utf8 "忠实且待人友善。",
    [15] = utf8 "细心并能够独立处理紧急事件。",
  },
  misc = {
    [1] = utf8 "打高尔夫球。",
    [2] = utf8 "潜水运动。",
    [3] = utf8 "冰雕。",
    [4] = utf8 "喝葡萄酒。",
    [5] = utf8 "拉力车赛。",
    [6] = utf8 "蹦跳。",
    [7] = utf8 "收集啤酒垫子。",
    [8] = utf8 "喜欢跳水。",
    [9] = utf8 "喜欢冲浪运动。",
    [10] = utf8 "喜欢游泳。",
    [11] = utf8 "蒸馏威士忌酒。",
    [12] = utf8 "DIY专家。",
    [13] = utf8 "喜欢欣赏法国电影。",
    [14] = utf8 "玩地下城守护者游戏。",
    [15] = utf8 "拥有HGV执照。",
    [16] = utf8 "摩托车比赛。",
    [17] = utf8 "弹奏古典提琴。",
    [18] = utf8 "训练营救员。",
    [19] = utf8 "喜欢养狗。",
    [20] = utf8 "听收音机。",
    [21] = utf8 "经常洗澡。",
    [22] = utf8 "工作指导。",
    [23] = utf8 "种植蔬菜。",
    [24] = utf8 "义务巡警。",
    [25] = utf8 "展览。",
    [26] = utf8 "收集二战武器。",
    [27] = utf8 "重新摆放家具。",
    [28] = utf8 "听刺激音乐。",
    [29] = utf8 "杀虫。",
    [30] = utf8 "喜剧演员。",
    [31] = utf8 "议会调查人员。",
    [32] = utf8 "园艺家。",
    [33] = utf8 "走私假手表。",
    [34] = utf8 "唱歌。",
    [35] = utf8 "喜欢日间电视。",
    [36] = utf8 "喜欢鲑鱼。",
    [37] = utf8 "向观光者介绍博物馆。",
  },
  bad = {
    [1] = utf8 "动作缓慢，且爱烦恼。",
    [2] = utf8 "懒惰。",
    [3] = utf8 "培训很少且没有精神。",
    [4] = utf8 "待人粗鲁。",
    [5] = utf8 "态度恶劣。",
    [6] = utf8 "耳聋。且身上有一股卷心菜的味道。",
    [7] = utf8 "不用心工作。",
    [8] = utf8 "鲁莽而且容易犯错误。",
    [9] = utf8 "容易犯错误。",
    [10] = utf8 "心理变态。",
    [11] = utf8 "粗心大意。",
    [12] = utf8 "懒散。",
    [13] = utf8 "愚蠢。",
    [14] = utf8 "狡猾且有破坏欲。",
    [15] = utf8 "傲慢自大。",
  },
}
staff_list = {
  morale = utf8 "士气",
  tiredness = utf8 "疲劳程度",
  skill = utf8 "技能",
  total_wages = utf8 "工资总额",
}
research = {
  allocated_amount = utf8 "已分配量",
  funds_allocation = utf8 "资金配置",
  categories = {
    improvements = utf8 "改良",
    drugs = utf8 "药品研究",
    diagnosis = utf8 "诊断仪器",
    cure = utf8 "治疗仪器",
    specialisation = utf8 "专项",
  },
}
room_classes = {
  diagnosis = utf8 "诊断室",
  clinics = utf8 "诊所",
  facilities = utf8 "附属设施",
  treatment = utf8 "治疗室",
}
buy_objects_window = {
  price = utf8 "价格：",
  choose_items = utf8 "选择物品",
  total = utf8 "总共：",
}
place_objects_window = {
  pick_up_object = utf8 "点击物品可以将其拾起，也可以选择不同的选项",
  place_objects_in_corridor = utf8 "将物品放在走廊上",
  place_windows = utf8 "请设置一些窗户，点击鼠标表示确定",
  confirm_or_buy_objects = utf8 "您可以确认该房间，或买入或移动其中的一些物品",
  drag_blueprint = utf8 "拉伸蓝图直到您满意的尺寸",
  place_door = utf8 "设置房门",
  place_objects = utf8 "可以设置并移动这些物品直到满意为止，随后再确定",
}
rooms_long = {
  ultrascan = utf8 "终极扫描仪房间",
  research_room = utf8 "研究部门",
  general = utf8 "一般",
  gps_office = utf8 "一般诊断室",
  inflation = utf8 "充气房间",
  staffroom = utf8 "员工休息室",
  jelly_vat = utf8 "胶桶",
  scanner = utf8 "扫描仪房间",
  emergency = utf8 "紧急事件",
  decontamination = utf8 "净化",
  corridors = utf8 "走廊",
  cardiogram = utf8 "心电图仪房间",
  ward = utf8 "病房",
  training_room = utf8 "培训室",
  psychiatric = utf8 "精神病诊断治疗室",
  operating_theatre = utf8 "手术中心",
  dna_fixer = utf8 "DNA修复装置",
  tongue_clinic = utf8 "舌头松弛诊治所",
  hair_restoration = utf8 "毛发恢复装置",
  general_diag = utf8 "高级诊断室",
  pharmacy = utf8 "药房",
  fracture_clinic = utf8 "骨折诊所",
  toilets = utf8 "洗手间",
  electrolysis = utf8 "电分解诊所",
  x_ray = utf8 "X光房间",
  blood_machine = utf8 "血液机器房间",
}
queue_window = {
  num_in_queue = utf8 "队伍长度",
  num_entered = utf8 "访问者人数",
  max_queue_size = utf8 "最大长度",
  num_expected = utf8 "预期",
}
staff_class = {
  doctor = utf8 "医生",
  handyman = utf8 "清洁工",
  receptionist = utf8 "接待员",
  nurse = utf8 "护士",
  surgeon = utf8 "外科医生",
}
staff_title = {
  junior = utf8 "实习医生",
  psychiatrist = utf8 "精神病医生",
  consultant = utf8 "专家",
  surgeon = utf8 "外科医生",
  doctor = utf8 "医生",
  researcher = utf8 "研究员",
  nurse = utf8 "护士",
  receptionist = utf8 "接待员",
  general = utf8 "普通人",
}
tooltip = {
  hire_staff_window = {
    prev_person = utf8 "查看前一个人",
    cancel = utf8 "取消",
    psychiatrist = utf8 "精神病医生",
    salary = utf8 "工资",
    next_person = utf8 "查看后一个人",
    nurses = utf8 "查看可雇佣的护士",
    surgeon = utf8 "外科医生",
    handymen = utf8 "查看可雇佣的清洁工人",
    doctors = utf8 "查看可雇佣的医生",
    doctor_seniority = utf8 "医生资历（实习医生，医生，专家）",
    hire = utf8 "雇佣",
    researcher = utf8 "科研人员",
    qualifications = utf8 "医生的特殊技能",
    receptionists = utf8 "查看可雇佣的接待员",
    staff_ability = utf8 "员工能力",
  },
  casebook = {
    sent_home = utf8 "转走人数",
    cure_requirement = {
      possible = utf8 "您有能力治疗这种疾病",
      not_possible = utf8 "您还没有能力治疗该种疾病",
      ward_hire_nurse = utf8 "您需要一位护士在病房中照料病人",
      build_ward = utf8 "您需要建造一个病房来治疗该疾病",
      research_machine = utf8 "您需要研究一些仪器来治疗这种疾病",
      hire_staff = utf8 "您需要雇佣一名%s来治疗该疾病",
      build_room = utf8 "您需要修建一个房间来治疗这种疾病",
      hire_surgeon = utf8 "您需要雇佣第二位外科医生来完成手术",
      hire_surgeons = utf8 "您需要雇佣两名外科医生完成手术",
    },
    increase = utf8 "增加",
    up = utf8 "向上滚动",
    reputation = utf8 "治疗或诊断声望",
    research = utf8 "点击这里可以为治疗使用专门研究预算",
    close = utf8 "关闭治疗手册",
    earned_money = utf8 "总收入",
    cure_type = {
      psychiatrist = utf8 "由精神病医生完成治疗工作",
      drug_percentage = utf8 "治疗使用药品－其疗效为%d%%",
      drug = utf8 "治疗时将使用药品",
      machine = utf8 "该疾病需要仪器辅助治疗",
      surgery = utf8 "该疾病需要手术",
    },
    decrease = utf8 "减少",
    deaths = utf8 "事故人数",
    cured = utf8 "治愈人数",
    down = utf8 "向下滚动",
    treatment_charge = utf8 "花费",
  },
  handyman_window = {
    close = utf8 "取消请求",
    ability = utf8 "能力",
    face = utf8 "清洁工的面孔",
    prio_machines = utf8 "提高清洁工维修机器的优先级",
    prio_litter = utf8 "提高清洁工清除垃圾的优先级",
    happiness = utf8 "快乐程度",
    prio_plants = utf8 "提高清洁工给植物浇水的优先级",
    name = utf8 "清洁工的名字",
    tiredness = utf8 "疲劳程度",
    center_view = utf8 "切换到当前人物",
    salary = utf8 "工资",
    sack = utf8 "解雇",
    pick_up = utf8 "拾起",
  },
  staff_list = {
    ability_2 = utf8 "员工的能力水平",
    next_person = utf8 "选择名单下一页",
    detail = utf8 "细心程度",
    happiness = utf8 "显示员工满意程度",
    researcher_train = utf8 "已经接受了%d%%的研究技能培训",
    handymen = utf8 "查看医院中被雇佣清洁工人名单",
    tiredness = utf8 "显示员工疲劳程度",
    researcher = utf8 "合格研究人员",
    happiness_2 = utf8 "员工士气",
    pay_rise = utf8 "提高员工工资10%",
    bonus = utf8 "付给该员工10%奖金",
    prev_person = utf8 "选择名单上一页",
    nurses = utf8 "查看医院中被雇佣护士名单",
    psychiatrist = utf8 "合格精神病医生",
    salary = utf8 "该员工当前工资",
    ability = utf8 "显示员工能力水平",
    close = utf8 "退出并返回游戏",
    sack = utf8 "解雇员工",
    surgeon = utf8 "合格外科医生",
    tiredness_2 = utf8 "员工的疲劳程度",
    doctors = utf8 "查看医院中被雇佣医生名单",
    doctor_seniority = utf8 "医生资历",
    view_staff = utf8 "查看员工工作情况",
    surgeon_train = utf8 "已经接受了%d%%的外科培训",
    skills = utf8 "特殊技能",
    receptionists = utf8 "查看医院中被雇佣接待员名单",
    psychiatrist_train = utf8 "已经接受了%d%%的精神病治疗培训",
  },
  rooms = {
    ultrascan = utf8 "医生使用超级扫描仪房间诊断病人",
    research_room = utf8 "拥有研究技能的医生可以在研究部门开发新的药品和机器。",
    fracture_clinic = utf8 "护士使用骨折诊所治疗骨折病人",
    gps_office = utf8 "病人在一般诊断室内接受初始诊断",
    inflation = utf8 "医生使用充气机房间治疗头部肿胀病人",
    staffroom = utf8 "医生和护士在员工休息室内可以恢复疲劳",
    jelly_vat = utf8 "医生使用胶桶诊所治疗失衡患者",
    scanner = utf8 "医生使用扫描仪房间诊断病人",
    decontamination = utf8 "医生使用净化淋浴装置可以治疗放射病",
    pharmacy = utf8 "护士在药房为病人配药治疗",
    cardiogram = utf8 "医生使用心电图室诊断病人",
    ward = utf8 "病房对于诊断和治疗都是非常有用的。病人手术前要在病房中观察一段时间。病房需要护士",
    training_room = utf8 "专家使用培训室对其他医生进行培训",
    operating_theatre = utf8 "手术中心需要两名具备外科技能的医生",
    psychiatry = utf8 "精神病诊断治疗室可以治疗精神病患者同时也能帮助诊断其他病人，但是需要一位拥有精神病治疗技能的医生",
    hair_restoration = utf8 "医生使用毛发恢复房间治疗秃顶病人",
    tongue_clinic = utf8 "医生使用舌头松弛诊断室治疗舌头松弛症病人",
    dna_fixer = utf8 "医生使用DNA恢复装置房间治疗外星人DNA病人",
    general_diag = utf8 "医生使用高级诊断室为患者进行基本诊断。花费很少但效率很高",
    toilets = utf8 "建造洗手间可以防止病人把医院弄得一团糟！",
    electrolysis = utf8 "医生使用电分解房间治疗多毛症病人",
    x_ray = utf8 "医生使用X光房间诊断病人",
    blood_machine = utf8 "医生使用血液机器房间诊断病人",
  },
  bank_manager = {
    graph = utf8 "显示%s支付曲线",
    close = utf8 "关闭银行经理画面",
    hospital_value = utf8 "医院当前价值",
    graph_return = utf8 "返回上个画面",
    current_loan = utf8 "当前未偿还贷款",
    borrow_5000 = utf8 "向银行借款$5000",
    balance = utf8 "银行现金",
    interest_payment = utf8 "每月利息支付",
    inflation_rate = utf8 "年通货膨胀率",
    interest_rate = utf8 "年利率",
    repay_5000 = utf8 "向银行偿还$5000",
    show_graph = utf8 "显示%s支付曲线",
    insurance_owed = utf8 "%s欠款的金额",
  },
  buy_objects_window = {
    confirm = utf8 "购买物品",
    cancel = utf8 "取消",
    increase = utf8 "多买一个",
    total_value = utf8 "定购物品总值",
    price = utf8 "物品价格",
    decrease = utf8 "少买一个",
  },
  patient_window = {
    send_home = utf8 "把病人赶出医院",
    casebook = utf8 "查看有关疾病的详细情况",
    close = utf8 "取消请求",
    queue = utf8 "查看队伍详细资料",
    happiness = utf8 "快乐程度",
    warmth = utf8 "温暖程度",
    center_view = utf8 "切换到当前人物",
    thirst = utf8 "干渴程度",
    graph = utf8 "通过点击可以在健康情况和病史之间切换",
    abort_diagnosis = utf8 "无需诊断直接去治疗",
  },
  status = {
    percentage_cured = utf8 "您需要治疗%d%%个前来就诊的病人。当前您已经治疗了%d%%",
    thirst = utf8 "医院中所有人的总体干渴程度",
    close = utf8 "关闭总览画面",
    population_chart = utf8 "图表显示每个医院对当地居民的吸引程度",
    win_progress_own = utf8 "显示当前进展情况",
    reputation = utf8 "您的声望必须至少有%d。当前值为%d",
    population = utf8 "您至少需要总人口的%d%%来访问您的医院",
    warmth = utf8 "医院中所有人的总体温暖程度",
    percentage_killed = utf8 "任务要求最多只能杀死%d个就诊病人。到目前为止，您已经杀死了%d%%个病人。",
    balance = utf8 "您的现金必须至少有$%d。当前值为$%d",
    value = utf8 "您的医院价值必须至少有$%d。当前值为$%d",
    win_progress_other = utf8 "显示当前%s方面的进展情况",
    num_cured = utf8 "您的目标是治愈%d个病人。现在您已经治愈%d",
    happiness = utf8 "医院中所有人的总体快乐程度",
  },
  queue_window = {
    end_of_queue = utf8 "拖动一位病人到该按钮处，将使其移动到队尾",
    num_entered = utf8 "到目前为止该房间已处理病人数目",
    close = utf8 "关闭面板",
    num_in_queue = utf8 "排队等候的病人数目",
    num_expected = utf8 "即将加入队伍的病人数目",
    front_of_queue = utf8 "拖动一位病人到该按钮处，将使其移动到队首",
    dec_queue_size = utf8 "减少队伍的最大长度",
    max_queue_size = utf8 "接待员允许的最大排队人数",
    inc_queue_size = utf8 "增加队伍的最大长度",
    patient = utf8 "拖动病人将改变其排队位置。右击某个病人可以选择将其遣送回家或遣送到竞争对手的医院。",
    patient_dropdown = {
      send_home = utf8 "让病人离开医院",
      hospital_2 = utf8 "将病人送到其它医院",
      reception = utf8 "将病人送到接待员处",
      hospital_1 = utf8 "将病人送到其它医院",
      hospital_3 = utf8 "将病人送到其它医院",
    },
  },
  jukebox = {
    rewind = utf8 "向后",
    loop = utf8 "循环播放",
    stop = utf8 "停止播放",
    close = utf8 "关闭音乐盒",
    current_title = utf8 "音乐盒",
    play = utf8 "播放",
    fast_forward = utf8 "向前",
  },
  main_menu = {
    network = utf8 "开始网络游戏",
    quit = utf8 "退出",
    continue = utf8 "继续游戏",
    load_menu = {
      load_slot = utf8 "读取进度",
      empty_slot = utf8 "空",
    },
  },
  watch = {
    emergency = utf8 "紧急情况：剩余时间内尽快治愈所有急救病人。",
    hospital_opening = utf8 "建造计时器：它主要用来指示距离医院开门的时间多少。直接点击开门按钮就可以立即开门迎接客人。",
    epidemic = utf8 "传染病：剩余时间内尽快阻止传染病蔓延。当时间耗尽或一个被传染病人离开医院，则卫生巡查员将出现。通过按钮可以切换预防接种模式开或者关。点击病人就可以让护士为其接种。",
  },
  window_general = {
    confirm = utf8 "确定",
    cancel = utf8 "取消",
  },
  graphs = {
    deaths = utf8 "切换死亡人数",
    close = utf8 "关闭图表画面",
    scale = utf8 "比例尺",
    money_out = utf8 "切换支出",
    visitors = utf8 "切换访问人数",
    wages = utf8 "切换工资",
    balance = utf8 "切换现金",
    money_in = utf8 "切换收入",
    cures = utf8 "切换治愈人数",
    reputation = utf8 "切换医院价值",
  },
  machine_window = {
    repair = utf8 "呼叫清洁工维修机器",
    name = utf8 "名字",
    close = utf8 "取消请求",
    times_used = utf8 "机器被使用次数",
    status = utf8 "机器状况",
    replace = utf8 "改良机器",
  },
  toolbar = {
    reputation = utf8 "声望",
    casebook = utf8 "治疗手册",
    edit = utf8 "编辑房间/物品",
    staff_list = utf8 "员工管理",
    policy = utf8 "制度",
    date = utf8 "日期",
    charts = utf8 "图表",
    objects = utf8 "设置走廊",
    balance = utf8 "现金",
    research = utf8 "研究",
    hire = utf8 "雇佣员工",
    status = utf8 "状态",
    town_map = utf8 "城镇地图",
    rooms = utf8 "建造房屋",
    bank_button = utf8 "左击进入银行经理画面，右击进入银行帐户",
  },
  place_objects_window = {
    confirm = utf8 "确认",
    cancel = utf8 "取消",
    pick_up = utf8 "拾起物品",
    buy_sell = utf8 "买/卖物品",
  },
  objects = {
    chair = utf8 "椅子：供病人使用，以讨论病情。",
    litter = "Litter: Left on the floor by a patient because he did not find a bin to throw it in.",
    sofa = utf8 "沙发：摆放在员工休息室中，员工如果没有更好的放松方式，则可以坐在上面恢复疲劳。",
    operating_table = "30 OB_OP_TABLE",
    bed2 = utf8 "未使用",
    bench = utf8 "长椅：为病人提供一个座位，使其可以比较舒适地等待。",
    scanner = "14 OB_SCANNER",
    couch = "18 OB_COUCH",
    blood_machine = "42 OB_BLOOD_MC",
    table1 = utf8 "桌子（已删除）：摆放大量杂志，使等待的病人感到快乐。",
    video_game = utf8 "视频游戏：让您的员工在游戏中彻底放松。",
    lamp = utf8 "灯：照明用。",
    op_sink2 = "34 OB_OP_SINK_2",
    door = utf8 "房门：人们出入房间时必需。",
    auto_autopsy = utf8 "验尸机：对研究新的治疗方法有很大帮助。",
    reception_desk = utf8 "接待台：需要一名接待员为病人服务。",
    hair_restorer = "25 OB_HAIR_RESTORER",
    projector = "37 OB_PROJECTOR",
    crash_trolley = "20 OB_CRASH",
    tv = utf8 "电视：使员工不会错过喜爱的节目。",
    ultrascanner = "22 OB_ULTRASCAN",
    surgeon_screen = "35 OB_SURGEON_SCREEN",
    litter_bomb = utf8 "垃圾炸弹：来自对手医院的破坏活动",
    inflator = utf8 "充气机：治疗头部肿胀病患者。",
    table2 = "12 OB_BTABLE",
    desk = utf8 "办公桌：医生可以在上面放置电脑。",
    pool_table = utf8 "台球桌：帮助员工放松。",
    x_ray_viewer = "29 OB_XRAY_VIEWER",
    radiation_shield = "28 OB_RAD_SHIELD",
    bed = utf8 "床：病情严重的病人需要卧床。",
    swing_door2 = "53 OB_DOUBLE_DOOR2",
    console = "15 OB_SCANNER_CONSOLE",
    op_sink1 = "33 OB_OP_SINK_1",
    bookcase = utf8 "书柜：放置医生的参考资料。",
    drinks_machine = utf8 "饮料机：为病人止渴，也是收入来源之一。",
    comfortable_chair = "61 OB_COMFY_CHAIR",
    skeleton = utf8 "骨骼模型：主要用于培训。",
    computer = utf8 "计算机：关键的研究部件。",
    bin = utf8 "垃圾桶：放置垃圾。",
    pharmacy_cabinet = utf8 "药房：用来保存药品",
    radiator = utf8 "暖气：保持医院内的温度。",
    cast_remover = "24 OB_CAST_REMOVE",
    atom_analyser = utf8 "化学混合器：摆放在研究部门中，该机器可以加速全部研究进程。",
    plant = utf8 "植物：使病人快乐并净化空气。",
    jelly_moulder = "47 OB_JELLY_VAT",
    cardio = "13 OB_CARDIO",
    toilet = utf8 "洗手间：提供给病人使用。",
    electrolyser = "46 OB_ELECTRO",
    fire_extinguisher = utf8 "灭火器：降低治疗仪器爆炸所产生的危险。",
    bed3 = utf8 "未使用",
    swing_door1 = "52 OB_DOUBLE_DOOR1",
    lecture_chair = utf8 "演讲座位：接受培训的医生坐在上面，收听无聊的演讲。座位摆放得越多，则教室越大。",
    screen = "16 OB_SCREEN",
    toilet_sink = utf8 "洗手池：讲卫生的病人可以在洗手池中洗净脏手。如果没有足够的洗手池，病人将感到不高兴。",
    shower = "54 OB_DECON_SHOWER",
    gates_of_hell = "48 OB_HELL",
    entrance_right = "59 OB_ENT_RDOOR",
    entrance_left = "58 OB_ENT_LDOOR",
    slicer = "26 OB_SLICER",
    dna_fixer = "23 OB_DNA_FIXER",
    x_ray = "27 OB_XRAY",
    cabinet = utf8 "文件柜：包含了病人文件，备忘录以及研究档案。",
  },
  staff_window = {
    doctor_seniority = utf8 "资历－是实习医生，医生还是专家",
    psychiatrist = utf8 "精神病",
    close = utf8 "取消面板",
    ability = utf8 "能力",
    pick_up = utf8 "拾起",
    sack = utf8 "解雇",
    surgeon = utf8 "外科",
    happiness = utf8 "快乐程度",
    salary = utf8 "月薪",
    name = utf8 "员工名字",
    tiredness = utf8 "疲劳程度",
    center_view = utf8 "切换到当前人物",
    skills = utf8 "特殊技术",
    researcher = utf8 "研究",
    face = utf8 "面孔",
  },
  pay_rise_window = {
    accept = utf8 "满足要求",
    decline = utf8 "不付款－将他们解雇",
  },
  policy = {
    diag_termination = utf8 "对于一个病人的诊断将一直持续到设定的治疗结束百分比，或所有的诊断机器都已经尝试一遍",
    close = utf8 "关闭制度画面",
    staff_leave = utf8 "点击这里可以让处于空闲状态的员工帮助其他员工",
    diag_procedure = utf8 "如果医生的诊断结果为，治愈概率小于设定的遣送回家百分比，则该病人将被自动遣送回家。如果治愈概率大于设定的尝试治疗百分比，则该病人将被自动送去进行治疗",
    staff_rest = utf8 "员工休息时的最低疲劳程度",
    staff_stay = utf8 "点击这里可以使所有员工停留在设定的房间内",
  },
  statement = {
    close = utf8 "关闭银行帐户画面",
  },
  town_map = {
    close = utf8 "退出城镇地图画面",
    plants = utf8 "切换植物",
    fire_extinguishers = utf8 "切换灭火器",
    people = utf8 "切换人员",
    balance = utf8 "现金",
    heat_dec = utf8 "减少供热",
    heating_bill = utf8 "供暖费",
    radiators = utf8 "切换暖气",
    objects = utf8 "切换物品",
    heat_level = utf8 "供热强度",
    heat_inc = utf8 "增加供热",
  },
  build_room_window = {
    cost = utf8 "当前被选择房间价格",
    room_classes = {
      treatment = utf8 "选择处理类房间",
      diagnosis = utf8 "选择诊断类房间",
      facilities = utf8 "选择附属类房间",
      clinic = utf8 "选择治疗类房间",
    },
    close = utf8 "取消并返回游戏",
  },
  research = {
    cure_inc = utf8 "提高科研百分比",
    close = utf8 "关闭研究画面",
    specialisation_dec = utf8 "降低专门研究百分比",
    diagnosis_dec = utf8 "降低科研百分比",
    allocated_amount = utf8 "已分配预算",
    improvements_inc = utf8 "提高改良研究百分比",
    drugs_dec = utf8 "降低药品研究百分比",
    drugs_inc = utf8 "提高药品研究百分比",
    cure_dec = utf8 "降低疗效研究百分比",
    specialisation_inc = utf8 "提高专门研究百分比",
    improvements_dec = utf8 "降低改良研究百分比",
    diagnosis_inc = utf8 "提高仪器研究百分比",
  },
}
menu_charts = {
  briefing = utf8 " 任务简报 ",
  casebook = utf8 " 治疗手册 ",
  graphs = utf8 " 图表 ",
  policy = utf8 " 制度 ",
  bank_manager = utf8 " 银行经理 ",
  statement = utf8 " 银行帐户 ",
  staff_listing = utf8 " 员工列表 ",
  research = utf8 " 研究 ",
  status = utf8 " 状态 ",
}
newspaper = {
  [1] = {
    [1] = utf8 "医生震惊四座",
    [2] = utf8 "玩弄上帝",
    [3] = utf8 "科学狂人的震撼",
    [4] = utf8 "实验室地板上摆放着什么？",
    [5] = utf8 "查获一项危险的研究",
  },
  [2] = {
    [1] = utf8 "酗酒",
    [2] = utf8 "外科医生醉酒",
    [3] = utf8 "挑剔的顾问",
    [4] = utf8 "外科医生的酒量",
    [5] = utf8 "外科医生痛饮失态",
    [6] = utf8 "外科医生的灵魂",
  },
  [3] = {
    [1] = utf8 "粗鲁的医生",
    [2] = utf8 "医生臭名远扬",
    [3] = utf8 "医生完了",
    [4] = utf8 "贪得无厌的医生",
  },
  [4] = {
    [1] = utf8 "篡改数据",
    [2] = utf8 "器官买卖犯罪",
    [3] = utf8 "银行危机",
    [4] = utf8 "调查基金数据",
  },
  [5] = {
    [1] = utf8 "医学工作者盗墓",
    [2] = utf8 "医生盗墓",
    [3] = utf8 "医生盗墓，人赃并获",
    [4] = utf8 "医生死期不远了",
    [5] = utf8 "超级渎职",
    [6] = utf8 "医生盗墓",
  },
  [6] = {
    [1] = utf8 "医生？庸医！",
    [2] = utf8 "庸医露馅了",
    [3] = utf8 "令人诅咒的诊断",
    [4] = utf8 "笨蛋专家",
  },
  [7] = {
    [1] = utf8 "医生真情放纵",
    [2] = utf8 "医生自我“手术”",
    [3] = utf8 "医生完了",
    [4] = utf8 "医生大丑闻",
    [5] = utf8 "医生搞得一团糟",
  },
}
bank_manager = {
  current_loan = utf8 "当前贷款",
  balance = utf8 "现金",
  interest_payment = utf8 "应付利息",
  hospital_value = utf8 "医院价值",
  interest_rate = utf8 "利率",
  insurance_owed = utf8 "保险公司欠款",
  statistics_page = {
    balance = utf8 "现金",
    details = utf8 "细节",
    date = utf8 "日期",
    current_balance = utf8 "当前现金",
    money_in = utf8 "收入",
    money_out = utf8 "支出",
  },
  inflation_rate = utf8 "通货膨胀率",
}
progress_report = {
  quite_unhappy = utf8 "人们有点不高兴。",
  header = utf8 "进展报告",
  very_unhappy = utf8 "人们感到非常不高兴。",
  more_drinks_machines = utf8 "多摆放一些饮料机。",
  too_cold = utf8 "太冷了。多摆放一些暖气。",
  too_hot = utf8 "调节供热系统。太热了。",
  percentage_pop = utf8 "%人口",
  win_criteria = utf8 "视窗标准",
}
adviser = {
  tutorial = {
    hire_receptionist = utf8 "您也需要一位接待员来接待病人。",
    build_pharmacy = utf8 "恭喜！现在应建造一个药房并雇佣一位护士，使医院正常运转。",
    hire_doctor = utf8 "您需要一个医生来诊断和治疗病人。",
    place_receptionist = utf8 "移动接待员并将她放到任意位置。她将很聪明地自己走到接待台。",
    place_windows = utf8 "设置窗户的方法与设置房门的方法相同。您可以不需要窗户，但是当您的员工可以从窗户向外张望时，他们将感到快乐。",
    confirm_room = utf8 "左键单击闪动像标就可以开业了，也可以通过点击交叉按钮返回上一步。",
    rotate_and_place_reception = utf8 "点击鼠标右键可以旋转桌子，并用鼠标左键将其放在医院中合适位置。",
    build_reception = utf8 "你好。首先，您的医院需要一个接待台，您可以从布置走廊菜单中选取。",
    doctor_in_invalid_position = utf8 "嗨！您不能将医生放在那里。",
    receptionist_invalid_position = utf8 "您不能将接待员放在那里。",
    room_too_small_and_invalid = utf8 "蓝图尺寸太小了且处于非法位置。",
    window_in_invalid_position = utf8 "该窗口处于非法位置。请尝试蓝图墙壁上的其它位置。",
    choose_doctor = utf8 "在选择医生之前，应重点考虑其能力。",
    build_gps_office = utf8 "您必须建造一般诊断室才可以诊断病人。",
    select_doctors = utf8 "点击闪动的像标挑选可被雇佣的医生。",
    place_objects = utf8 "右击可以旋转房屋中的各种物品，再左击表示确认。",
    select_receptionists = utf8 "使用鼠标左键单击闪动的像标来查看当前可选择的接待员。像标下方的数字表示共有多少个接待员可供选择。",
    order_one_reception = utf8 "使用鼠标左键单击闪动的光条，可以定购一个接待台。",
    choose_receptionist = utf8 "判断哪一个接待员拥有好的能力与合适的工资，再左键单击闪动的像标来雇佣她。",
    place_doctor = utf8 "将医生放在医院中的任意位置。他将直奔一般诊断室，为病人诊断。",
    accept_purchase = utf8 "点击闪动的像标表示购买。",
    place_door = utf8 "沿着蓝图墙壁移动鼠标，寻找放置房门的合适位置。",
    next_receptionist = utf8 "这是接待员列表中的第一个。左键单击闪动的像标可以浏览下一个可供选用的接待员。",
    room_in_invalid_position = utf8 "该蓝图是非法的，红色区域表示蓝图与其它房间或墙壁重叠。",
    room_big_enough = utf8 "蓝图尺寸已经足够大了。当您松开鼠标按键表示确认。如果需要的话，以后还可以根据需要移动或改变其尺寸。",
    room_too_small = utf8 "该房间的蓝图为红色是因为其尺寸太小了。通过拖动使其尺寸增大。",
    click_gps_office = utf8 "点击闪动光条表示选择一般诊断室。",
    reception_invalid_position = utf8 "如果接待台是灰色的，则表示当前位置是非法的。应尝试移动或旋转它。",
    click_and_drag_to_build = utf8 "建造一般诊断室时应先决定具体的尺寸。点击并按住鼠标左键可以设置房间尺寸。",
    door_in_invalid_position = utf8 "房门设置位置非法。请尝试蓝图墙壁上的其它位置。",
    object_in_invalid_position = utf8 "该物品当前位置非法。请要么将其放到其它位置，要么对其进行旋转。",
    select_diagnosis_rooms = utf8 "点击闪动的像标将弹出诊断类房间列表。",
    prev_receptionist = utf8 "左键单击闪动的像标将可以浏览到前一个可供选择的接待员。",
  },
  epidemic = {
    hurry_up = utf8 "如果无法立即控制传染病那么您的医院将出大乱子。加油！",
    serious_warning = utf8 "传染病疫情越来越严重。您必须立即行动！",
    multiple_epidemies = utf8 "看来医院里同时有不只一种传染病。这将是一场空前灾难，加油！",
  },
  staff_advice = {
    need_handyman_machines = utf8 "如果希望维护医院内的各种医疗机器，则需要雇佣清洁工人。",
    need_doctors = utf8 "您需要更多的医生。请将最得力的医生放在排队等候人数最多的房间内。",
    need_handyman_plants = utf8 "您需要雇佣一位清洁工人来为植物浇水。",
    need_handyman_litter = utf8 "医院中出现了垃圾。请雇佣一个清洁工人打扫垃圾。",
    need_nurses = utf8 "您需要雇佣更多的护士。病房和药房都需要护士。",
    too_many_doctors = utf8 "您雇佣的医生太多了。其中有一些人当前正闲着。",
    too_many_nurses = utf8 "我认为您现在雇佣了太多的护士。",
  },
  earthquake = {
    damage = utf8 "地震损坏了医院中%d台机器，并使%d个人受伤。",
    alert = utf8 "地震警报。在地震过程中，医院中的机器将受损。如果它们没有得到及时维护将彻底毁坏。",
    ended = utf8 "我认为这是一个大家伙－按照理查标准为%d。",
  },
  multiplayer = {
    objective_completed = utf8 "您已经完成任务了。恭喜！",
    everyone_failed = utf8 "每个人都没有完成最终目标。因此每个人都要继续努力！",
    players_failed = utf8 "下面的玩家没有完成最终目标：",
    poaching = {
      in_progress = utf8 "我将让您了解这个人是否愿意为您工作。",
      not_interested = utf8 "哈哈！他们对为您工作不感兴趣－他们希望找寻自我价值。",
      already_poached_by_someone = utf8 "没门！有人想要挖走这个人。",
    },
    objective_failed = utf8 "任务失败。",
  },
  surgery_requirements = {
    need_surgeons_ward_op = utf8 "您需要雇佣两位外科医生，并修建一个病房和手术中心，这样才可以完成外科手术。",
    need_surgeon_ward = utf8 "为了完成外科手术，您还需要雇佣一名外科医生，以及修建一个病房。",
  },
  vomit_wave = {
    started = utf8 "请赶快处理医院中的呕吐物，否则呕吐现象会四处传播。也许您需要多雇佣几个清洁工人。",
    ended = utf8 "嗨！呕吐现象已被控制。今后一定要保持医院的清洁。",
  },
  level_progress = {
    nearly_won = utf8 "您已经距离胜利非常接近了。",
    three_quarters_lost = utf8 "您距离失败还差四分之三。",
    halfway_won = utf8 "您距离胜利还差一半。",
    halfway_lost = utf8 "您距离失败还差一半。",
    nearly_lost = utf8 "您距离失败只有一步之遥了。",
    three_quarters_won = utf8 "您距离胜利还差四分之三。",
  },
  staff_place_advice = {
    receptionists_only_at_desk = utf8 "接待员只能在接待台工作。",
    only_psychiatrists = utf8 "只有具有精神病治疗技能的医生才可以在精神病诊断治疗室中工作。",
    only_surgeons = utf8 "只有拥有外科技能的医生才可以在手术中心工作。",
    only_nurses_in_room = utf8 "只有护士可以在%s中工作",
    only_doctors_in_room = utf8 "只有医生可以在%s中工作",
    only_researchers = utf8 "只有拥有研究技能的医生才可以在研究部门工作。",
    nurses_cannot_work_in_room = utf8 "护士无法在%s中工作",
    doctors_cannot_work_in_room = utf8 "医生无法在%s中工作",
  },
  room_forbidden_non_reachable_parts = "Placing the room in this location would result in parts of the hospital not being reachable.",
  research = {
    machine_improved = utf8 "%s的疗效被您的研究部门增强了。",
    autopsy_discovered_rep_loss = utf8 "您的自动验尸机已经研制成功。对公众将产生副作用。",
    drug_fully_researched = utf8 "您已经研究%s到达100%了。",
    new_machine_researched = utf8 "一个新的%s刚刚被成功研究出来。",
    drug_improved = utf8 "治疗%s的药品被您的研究部门改良了。",
    new_available = utf8 "一种新的%s可以使用了。",
    new_drug_researched = utf8 "治疗%s的一种新药被研究成功。",
  },
  boiler_issue = {
    minimum_heat = utf8 "噢，终于找到您了。锅炉坏了。也就是说医院里的人将感到有点冷。",
    maximum_heat = utf8 "锅炉快失控了。暖气的供暖能力已经达到极限了。医院里的人都快被熔化了！多设置一些饮料机。",
    resolved = utf8 "好消息。锅炉和暖气现在工作正常。气温很快就可以恢复到正常水平。",
  },
  competitors = {
    staff_poached = utf8 "您的一位员工被其它医院挖走了。",
    hospital_opened = utf8 "竞争对手%s的医院在本区域内已经开张了。",
    land_purchased = utf8 "%s已经购买了一些土地。",
  },
  room_requirements = {
    research_room_need_researcher = utf8 "您需要为研究室雇佣一个拥有研究技巧的医生。",
    op_need_another_surgeon = utf8 "您至少还需要为手术中心雇佣一名外科医生。",
    op_need_ward = utf8 "您必须为外科手术前的患者建造病房。",
    reception_need_receptionist = utf8 "您必须为病人雇佣一位接待员。",
    psychiatry_need_psychiatrist = utf8 "您需要雇佣一位精神病医生，现在您已经建成了一个精神病诊断治疗室。",
    pharmacy_need_nurse = utf8 "您应该为药房雇佣一位护士。",
    ward_need_nurse = utf8 "您需要为病房雇佣一名护士。",
    op_need_two_surgeons = utf8 "请为手术中心雇佣两名外科医生完成手术。",
    training_room_need_consultant = utf8 "您应该为培训室雇佣一位专家，负责讲演。",
    gps_office_need_doctor = utf8 "您需要为一般诊断室雇佣一名医生。",
  },
  goals = {
    win = {
      money = utf8 "您还需要%d才能完成本关中的财政指标。",
      cure = utf8 "再治愈%d个病人您就可以满足本关任务的要求了。",
      reputation = utf8 "提高声望%d将达到胜利完成本任务的要求",
      value = utf8 "提高声望%d将达到胜利完成本任务的要求",
    },
    lose = {
      kill = utf8 "再杀死%d病人将导致本任务失败！",
    },
  },
  warnings = {
    charges_too_low = utf8 "治疗费用太低了。它将使更多的病人到医院就诊，但您无法从每个病人身上获取太多的利润。",
    charges_too_high = utf8 "治疗费用太高了。短期内它将产生很好的效益，但最终会把病人吓跑的。",
    plants_thirsty = utf8 "您需要对植物进行照料。它们正感到干渴。",
    staff_overworked = utf8 "您的员工已经劳累过度。他们的办事效率正在下降，并将有可能发生医疗事故。",
    queue_too_long_at_reception = utf8 "在接待台前排队等待的病人太多了。请再建一个接待台并雇佣一名接待员。",
    queue_too_long_send_doctor = utf8 "您的%s队伍太长了。请确认房间中是否有医生。",
    handymen_tired = utf8 "您的清洁工人太劳累了。立即让他们休息。",
    money_low = "Your money is getting low!",
    money_very_low_take_loan = utf8 "您的现金量太少了。您可以尝试贷款。",
    staff_unhappy = utf8 "您的工作人员不是很快乐。可以尝试给他们一些奖金，或为他们建造一个员工休息室。您也可以在医院制度画面中调整员工需要休息时的疲劳程度。",
    no_patients_last_month = utf8 "上个月，没有新的病人前来您的医院。太可怕了！",
    queues_too_long = utf8 "队伍太长了。",
    patient_stuck = utf8 "有人被卡住了，更好地规划您的医院。",
    patients_too_hot = utf8 "病人们感到太热了。要么拆除一些暖气，调低供热标准，要么为他们多设置一些饮料机。",
    doctors_tired = utf8 "您的医生太累了。立即让他们休息。",
    need_toilets = utf8 "病人需要洗手间。请在一些易找的地方建造洗手间。",
    machines_falling_apart = utf8 "您的机器快爆炸了。请立即让清洁工进行维修！",
    nobody_cured_last_month = utf8 "上个月几乎没有治愈一个病人。",
    patients_thirsty = utf8 "人们感到口渴。也许您应该向他们提供饮料机。",
    nurses_tired = utf8 "您的护士感到疲倦了。立即让她们休息。",
    machine_severely_damaged = utf8 "%s已经快彻底毁坏了。",
    reception_bottleneck = utf8 "接待台已无法满足需要。再雇佣一名接待员。",
    bankruptcy_imminent = utf8 "嗨！您快破产了。小心啊！",
    receptionists_tired = utf8 "您的接待员太疲劳了。立即让她们休息。",
    too_many_plants = utf8 "您已经布置了足够多的植物了。医院都快变成丛林了。",
    many_killed = utf8 "您已经杀死了%d个病人。您本应该治愈他们的病。",
    need_staffroom = utf8 "建造一个员工休息室使您的员工得以休息。",
    staff_too_hot = utf8 "您的工作人员感到太热了。请调低供热标准或拆除房间内的暖气。",
    patients_unhappy = utf8 "病人不喜欢您的医院。您必须为提高环境质量做一些事情。",
  },
  placement_info = {
    door_can_place = utf8 "如果您愿意的话可以在这里设置房门。",
    window_can_place = utf8 "你可以在这里设置窗户，这样很好。",
    door_cannot_place = utf8 "抱歉，您无法在这里设置房门。",
    object_can_place = utf8 "您可以在这里摆放物品。",
    reception_can_place = utf8 "您可以在这里放置接待台。",
    staff_cannot_place = utf8 "您无法在这里安置员工。对不起。",
    staff_can_place = utf8 "您可以在这里安置员工。",
    object_cannot_place = utf8 "嗨，您无法在这里摆放物品。",
    room_cannot_place = utf8 "您无法在这里建房。",
    room_cannot_place_2 = utf8 "您无法在这里建房。",
    window_cannot_place = utf8 "您实际上无法在这里设置窗户。",
    reception_cannot_place = utf8 "您无法在这里放置接待台。",
  },
  praise = {
    many_benches = utf8 "病人拥有足够的座位。太棒了。",
    many_plants = utf8 "太可爱了。您已经布置了足够的植物。病人将感到满意。",
    patients_cured = utf8 "已经治愈了%d个病人。",
  },
  information = {
    larger_rooms = utf8 "大的房间将使员工感觉到自己的重要，并提高他们的表现。",
    extra_items = utf8 "房间中摆放物品将使员工感到舒服并提高他们的表现。",
    epidemic = utf8 "在您的医院中发现了一种传染病。您必须立即处理！",
    promotion_to_doctor = utf8 "您的一个实习医生提升为医生了。",
    emergency = utf8 "紧急情况！快！快！快！",
    patient_abducted = utf8 "您的一位病人被外星人诱拐了。",
    first_cure = utf8 "干得好！您已经治愈了第一个病人。",
    promotion_to_consultant = utf8 "您的一名医生已经提升为专家了。",
    handyman_adjust = utf8 "您可以通过调整清洁工人工作的优先级使其打扫得更干净。",
    promotion_to_specialist = utf8 "您的一个医生被提升为%s。",
    patient_leaving_too_expensive = utf8 "一位病人没有为%s付款就离开了。这损失太大了。",
    vip_arrived = utf8 "小心！%s正准备访问您的医院！保持医院运转正常，这样才能使他感到愉快。",
    epidemic_health_inspector = utf8 "您的医院中出现传染病的消息已经到达了卫生部。卫生巡查员很快就要到达，快做准备。",
    first_death = utf8 "这是您第一次杀死病人。感觉如何？",
    pay_rise = utf8 "您的一个员工威胁要辞职。选择是否同意其请求，或将其解雇。点击屏幕左下方的像标可以查看威胁要辞职的员工信息。",
    place_windows = utf8 "设置窗户将使房间更加明亮，并振奋员工的精神。",
    fax_received = utf8 "在屏幕左下角刚刚弹出的像标表示一些重要事件的相关信息，或某些需要您决定的事情。",
  },
  build_advice = {
    placing_object_blocks_door = utf8 "设置该物品可以阻止其他人接近。",
    blueprint_would_block = utf8 "蓝图与其它房间重叠了。请尝试重新设置蓝图尺寸，或移动蓝图位置。",
    door_not_reachable = utf8 "病人无法进入那扇门。仔细想一想。",
    blueprint_invalid = utf8 "蓝图位置非法。",
  },
}
menu_debug_overlay = {
  byte_w_wall = "  BYTE W WALL  ",
  byte_6 = "  BYTE 6  ",
  byte_0_1 = "  BYTE 0 & 1  ",
  byte_7 = "  BYTE 7  ",
  byte_5 = "  BYTE 5  ",
  byte_floor = "  BYTE FLOOR  ",
  positions = "  POSITIONS  ",
  flags = "  FLAGS  ",
  parcel = "  PARCEL  ",
  byte_n_wall = "  BYTE N WALL  ",
  none = "  NONE  ",
}
dynamic_info = {
  patient = {
    emergency = utf8 "紧急情况：%s",
    guessed_diagnosis = utf8 "尝试诊断：%s",
    diagnosis_progress = utf8 "诊断过程",
    actions = {
      sent_to_other_hospital = utf8 "指派到其它医院",
      prices_too_high = utf8 "费用太高了－我要回家了",
      no_gp_available = "Waiting for you to build a GP's office",
      waiting_for_treatment_rooms = utf8 "等待为我建造一间治疗室",
      dying = utf8 "快死了！",
      no_diagnoses_available = utf8 "无法诊断－我要回家了",
      epidemic_sent_home = utf8 "被巡查员赶回家",
      cured = utf8 "治愈！",
      waiting_for_diagnosis_rooms = utf8 "等待建造更多的诊断室",
      epidemic_contagious = utf8 "我有传染病",
      awaiting_decision = utf8 "等待您的决定",
      sent_home = utf8 "遣送回家",
      fed_up = utf8 "受够了，要离开",
      no_treatment_available = utf8 "无法治疗－我要回家了",
      on_my_way_to = utf8 "在去%s的路上",
      queueing_for = utf8 "排队等待%s",
    },
    diagnosed = utf8 "诊断：%s",
  },
  health_inspector = utf8 "卫生巡查员",
  vip = utf8 "来访贵宾",
  object = {
    times_used = utf8 "使用次数%d",
    queue_size = utf8 "排队人数%d",
    strength = utf8 "力量%d",
    queue_expected = utf8 "即将加入队伍人数%d",
  },
  staff = {
    ability = utf8 "能力",
    psychiatrist_abbrev = utf8 "精神分析",
    actions = {
      waiting_for_patient = utf8 "等待病人",
      wandering = utf8 "正在到处走动",
      going_to_repair = utf8 "前往维修%s",
      heading_for = "Heading for %s",
    },
    tiredness = utf8 "疲劳",
  },
}
introduction_texts = {
  level1 = {
    [1] = utf8 "欢迎来到您的第一座医院！",
    [2] = utf8 "首先要摆放接待台，建造一般诊断室，并雇佣一名接待员和一名医生。",
    [3] = utf8 "随后就可以等待开张了。",
    [4] = utf8 "建造精神病诊断治疗室并雇佣一名精神病医生是一个好主意。",
    [5] = utf8 "药房和护士也是治疗病人所必需的。",
    [6] = utf8 "建造一个充气机房间就可以治疗头部肿胀患者。",
    [7] = utf8 "您需要治愈10个病人，并使声望保持在200以上。",
  },
  level2 = {
    [1] = utf8 "在该区域内还有一些其它的疾病。",
    [2] = utf8 "建造医院从而可以治疗更多的病人，并应该考虑建造研究部门。",
    [3] = utf8 "记住保持内部的清洁，从而使声望尽可能地高－您将遇到患有舌头松弛症的病人，因此需要建造舌头诊治房间。",
    [4] = utf8 "您也可以建造心电图房间来帮助诊断疾病。",
    [5] = utf8 "这些房间都需要经过研究才能够被建造。现在你可以购买其它土地扩展医院－使用城镇地图就可以购买土地。",
    [6] = utf8 "目标是声望300，银行现金为10000，且治愈40个病人。",
  },
  level3 = {
    [1] = utf8 "这次您将在一个富裕地区建造医院。",
    [2] = utf8 "卫生部希望您能够在这里赚取更多的利润。",
    [3] = utf8 "开始时您被要求获取好的声望，但是一旦医院步入正轨，就可以集中精力赚取更多的钱。",
    [4] = utf8 "有可能会发生紧急事件。",
    [5] = utf8 "也就是说一次会有大量病人就诊，且他们的病情都一样。",
    [6] = utf8 "在时间限制内如果能够治愈他们，则不仅可以拿到奖金，声望也会提高。",
    [7] = utf8 "一些疾病如猫王综合症等有可能发生，因此最好建造一间手术中心和附属病房。",
    [8] = utf8 "胜利条件是赚取$20,000。",
  },
  level4 = {
    [1] = utf8 "使所有的病人快乐，保持治疗的高效率并尽量降低死亡人数。",
    [2] = utf8 "声望是十分重要的，因此尽量赢得更高的声望。",
    [3] = utf8 "不要太多担心收入情况－当声望提高了，收入也自然会提高。",
    [4] = utf8 "您需要培训您的医生，拓宽他们的能力。",
    [5] = utf8 "这样他们就可以更好的为病人服务。",
    [6] = utf8 "胜利条件是声望达到500以上。",
  },
  level5 = {
    [1] = utf8 "医院将非常繁忙，处理各种各样的病人。",
    [2] = utf8 "医生都是刚刚毕业的实习医生，因此需要建造一间培训室对他们进行培训，提高能力。",
    [3] = utf8 "您只有3名专家可以帮助培训这些员工，因此一定要让专家快乐。",
    [4] = utf8 "另外要注意的是，医院的位置不是很好。",
    [5] = utf8 "经常会发生地震。",
    [6] = utf8 "地震将对医院中的机器产生损坏，从而影响医院的运营。",
    [7] = utf8 "使您声望达到400以上，现金达到$50,000。另外需要治愈200个病人。",
  },
  level6 = {
    [1] = utf8 "使用您的所有知识来建造一个运行平稳的医院，从而可以赚取利润并处理任何问题。",
    [2] = utf8 "您需要注意一点，医院周围的空气对细菌繁殖，传染病流行非常适宜。",
    [3] = utf8 "如果您没有保持医院的清洁，则将面对传染病的流行。",
    [4] = utf8 "赚取$150,000，并使医院价值超过$140,000。",
  },
  level7 = {
    [1] = utf8 "在这里您将受到卫生部的密切监察，因此要在赚钱的同时，努力提高自己的声望。",
    [2] = utf8 "我们无法处理太多的医疗事故－这对于医院的运营是十分不利的。",
    [3] = utf8 "确认所有员工都很快乐，并确认已经购买了所有需要的仪器装备。",
    [4] = utf8 "声望需要达到600，且银行里需要有$200,000。",
  },
  level8 = {
    [1] = utf8 "需要您来建造一座高效的医院。",
    [2] = utf8 "很多人都无事可做，因此需要适量的裁员以保持高效。",
    [3] = utf8 "记住治愈病人是很重要的一件事情，但是您更要从中赚钱。",
    [4] = utf8 "让恶心呕吐的病人靠近清洁工人。",
    [5] = utf8 "需要赚取$300,000就可以过关。",
  },
  level9 = {
    [1] = utf8 "当填满了卫生部的银行帐户并为部长大人购买了一辆轿车后，您现在又要开始新的工作了。",
    [2] = utf8 "在这里您要面对很多问题。",
    [3] = utf8 "只有拥有足够经验充分的员工和房间，您才能够顺利过关。",
    [4] = utf8 "医院价值需要达到$200,000，且银行帐户上要有$400,000。",
    [5] = utf8 "如果无法达到上述要求，则无法胜利完成任务。",
  },
  level10 = {
    [1] = utf8 "随着您的经验不断增长，卫生部要求您集中精力提高药品的治疗效果。",
    [2] = utf8 "有人对您颇有微辞，为此您必须使所有的药物都非常有效。",
    [3] = utf8 "另外，一定要降低医疗事故的发生次数，减少死亡人数。",
    [4] = utf8 "作为提示，您需要为建造胶桶留一些空地。",
    [5] = utf8 "使所有药物的疗效都达到80%，声望达到650且在银行帐户上有$500,000，这样就可以胜利过关。",
  },
  level11 = {
    [1] = utf8 "现在您有机会建造一座终极医院。",
    [2] = utf8 "该地区享有极高的声望，因此卫生部希望能够看到最好的医院建造在这里。",
    [3] = utf8 "我们希望您能够赚取大量的金钱，获得很高的声望，并能够成功地处理任何事件。",
    [4] = utf8 "这是一项非常重要的工作。",
    [5] = utf8 "这需要您的努力工作。",
    [6] = utf8 "注意一点，该区域常常会看到不明飞行物。因此请让您的员工做好准备迎接不速之客。",
    [7] = utf8 "您的医院价值需要达到$240,000，在银行帐户内需要$500,000，且声望需要达到700。",
  },
  level12 = {
    [1] = utf8 "您现在遇到了最大的挑战。",
    [2] = utf8 "我们为您的成功感到由衷地高兴，卫生部为您准备了一项顶级工作；他们需要有人建造另一个超级医院，赚钱的同时获取较高的声望。",
    [3] = utf8 "您可以购买任何需要的土地，治疗各种疾病赢得各种奖励。",
    [4] = utf8 "动心了吗？",
    [5] = utf8 "赚取$650,000，治愈750个病人，使声望达到800就可以胜利过关。",
  },
  level13 = {
    [1] = utf8 "您的高超管理技能被特殊机密部门获知。",
    [2] = utf8 "他们将向您提高特别奖金，因为他们有一座被老鼠困扰的医院需要有效管理。",
    [3] = utf8 "您必须杀死尽可能多的老鼠，并让清洁工人打扫干净。",
    [4] = utf8 "接受这个任务？",
  },
  level14 = {
    [1] = utf8 "这里还有一个挑战－一个充满惊奇的医院。",
    [2] = utf8 "如果您能够成功完成这个任务，则您将成为所有胜利者中的佼佼者。",
    [3] = utf8 "不要认为完成这个任务就象吃蛋糕一样，这将是您所遇到的最艰苦的工作。",
    [4] = utf8 "祝您好运！",
  },
  level15 = {
    [1] = utf8 "好的，下面是管理医院的一些技巧。//",
    [2] = utf8 "医生需要各种帮助来诊断病人。您可以",
    [3] = utf8 "建造另一个诊断类房间，例如高级诊断室。",
  },
  level16 = {
    [1] = utf8 "当对病人完成诊断后，需要建造处理和治疗类房间完成对病人的治疗工作。可以从",
    [2] = utf8 "建造药房开始。在药房中需要一名护士分配各种药品。",
  },
  level17 = {
    [1] = utf8 "最后的警告－时刻关注您的声望－这是真正吸引病人前来就诊的关键。",
    [2] = utf8 "如果您没有杀死太多的病人，且使就诊病人保持快乐，则不必太担心声望！",
    [3] = utf8 "决定权就在您的手中。祝您好运。",
  },
  level18 = {
  },
}
humanoid_name_starts = {
  [1] = utf8 "欧得",
  [2] = utf8 "黑尔",
  [3] = utf8 "安德",
  [4] = utf8 "本",
  [5] = utf8 "班",
  [6] = utf8 "比尔",
  [7] = utf8 "维",
  [8] = utf8 "瓦特",
  [9] = utf8 "宝得",
  [10] = utf8 "金",
  [11] = utf8 "巴",
  [12] = utf8 "派特",
  [13] = utf8 "曼",
  [14] = utf8 "宝艾",
  [15] = utf8 "沃",
  [16] = utf8 "杰克",
  [17] = utf8 "克来伯",
  [18] = utf8 "费什",
  [19] = utf8 "瓦特",
  [20] = utf8 "米尔",
  [21] = utf8 "白",
  [22] = utf8 "芬",
  [23] = utf8 "里奇",
  [24] = utf8 "斯科特",
  [25] = utf8 "伯尔",
  [26] = utf8 "派克",
  [27] = utf8 "科",
  [28] = utf8 "维特",
  [29] = utf8 "比恩",
  [30] = utf8 "宝恩",
  [31] = utf8 "伯格",
  [32] = utf8 "怀特",
  [33] = utf8 "科尔",
}
vip_names = {
  [1] = utf8 "伟大的查普顿市长",
  [2] = utf8 "南丁格尔",
  [3] = utf8 "来自荷兰的伯那德国王",
  [4] = utf8 "缅甸民主党领袖：昂山苏蒂",
  [5] = utf8 "克朗伯先生",
  [6] = utf8 "比利先生",
  [7] = utf8 "克劳福议员",
  [8] = utf8 "罗尼",
  [9] = utf8 "一个超级联赛球星",
  [10] = utf8 "拉里普罗斯特",
  health_minister = utf8 "卫生部部长",
}
fax = {
  epidemic_result = {
    fine_amount = utf8 "政府宣布全国紧急状态，并对您罚款%d。",
    close_text = utf8 "哈！",
    hospital_evacuated = utf8 "会议决定只能疏散您的医院。",
    succeeded = {
      part_1_name = utf8 "卫生巡查员听到了传闻，您的医院正在处理严重疾病%s。",
      part_2 = utf8 "然而他还没有能够找到证实传闻的证据。",
    },
    compensation_amount = utf8 "政府决定奖励您%d作为补偿谣言对您医院声誉所造成的损失。",
    failed = {
      part_1_name = utf8 "尝试掩盖病情，他们正面临着传染病%s爆发。",
      part_2 = utf8 "医院中的员工已经制止了传染病向医院附近居民传播。",
    },
    rep_loss_fine_amount = utf8 "报纸将整版报道此事。您的声望将大幅受损。另外，还要缴纳罚款%d。",
  },
  vip_visit_query = {
    choices = {
      invite = utf8 "向贵宾发出邀请。",
      refuse = utf8 "找借口阻止贵宾访问。",
    },
    vip_name = utf8 "%s希望能够访问您的医院！",
  },
  vip_visit_result = {
    telegram = utf8 "电报！",
    remarks = {
      good = {
        [1] = utf8 "医院经营得太棒了。感谢您能够邀请我来访问。",
        [2] = utf8 "嗯。医院经营得还可以。",
        [3] = utf8 "我很欣赏您的医院。",
      },
      super = {
        [1] = utf8 "医院太棒了。下次我生病一定要到那里去就诊。",
        [2] = utf8 "那就是我访问的医院。",
        [3] = utf8 "那是一个超级医院。并且我想知道更多一点。",
      },
      bad = {
        [1] = utf8 "我为什么烦恼？这比看一场持续4个小时的歌剧好多了！",
        [2] = utf8 "我为我所看到的感到恶心。这也是医院？胡说八道！",
        [3] = utf8 "我已经受够了！",
      },
      mediocre = {
        [1] = utf8 "喔，有点差劲。您应多做一些改进。",
        [2] = utf8 "喔，亲爱的。这个地方可不怎么样。",
        [3] = utf8 "这是一个比较一般的医院。但坦白地讲，我希望能够做得更好。",
      },
      very_bad = {
        [1] = utf8 "真是一个垃圾。我要争取关闭它。",
        [2] = utf8 "我从没有见过这样可怕的医院。真是丢人！",
        [3] = utf8 "我被震惊了。这也能称为医院！给我一点酒。",
      },
    },
    rep_boost = utf8 "您的声望在公众中是很好的。",
    vip_remarked_name = utf8 "%s访问医院结束后发表评论：",
    cash_grant = utf8 "您将得到奖金%d。",
    rep_loss = utf8 "您的声望因此受到损害。",
    close_text = utf8 "感谢您访问医院。",
  },
  disease_discovered_patient_choice = {
    need_to_build = utf8 "您必需建造一个%s才能处理该疾病。",
    need_to_employ = utf8 "雇佣一名%s就可以处理该情况。",
    what_to_do_question = utf8 "您打算怎样处理这个病人？",
    guessed_percentage_name = utf8 "您的员工正在尝试治疗该病人。我们有%d%%的几率治愈该病：%s",
    choices = {
      send_home = utf8 "送病人回家。",
      research = utf8 "将病人送到研究部门。",
      wait = utf8 "让病人在医院中等一会儿。",
    },
    disease_name = utf8 "发现了新情况。该疾病为%s",
    need_to_build_and_employ = utf8 "您需要建造一个%s，并雇佣一名%s才能处理该疾病。",
    can_not_cure = utf8 "您无法治疗该疾病。",
  },
  emergency_result = {
    earned_money = utf8 "最大奖金额为$%d，您得到了$%d。",
    close_text = utf8 "点击这里退出。",
    saved_people = utf8 "您挽救了%d个病人，总共需要治愈%d个。",
  },
  disease_discovered = {
    discovered_name = utf8 "您的员工发现了一种新的疾病。它是%s",
    need_to_employ = utf8 "雇佣一名%s就可以处理这种危机。",
    need_to_build_and_employ = utf8 "您需要建造一个%s，并雇佣一名%s才能处理该疾病。",
    need_to_build = utf8 "您必需建造一个%s才能处理该疾病。",
    close_text = utf8 "新发现了一种疾病。",
    can_cure = utf8 "您可以处理这种疾病。",
  },
  emergency = {
    locations = {
      [1] = utf8 "赛澈化学药品工厂。",
      [2] = utf8 "斯尼得大学。",
      [3] = utf8 "派拉奎特园艺中心。",
      [4] = utf8 "危险物质研究机构。",
      [5] = utf8 "莫理斯舞蹈家协会。",
      [6] = utf8 "青蛙与公牛酒店。",
      [7] = utf8 "大戴维殡葬馆。",
      [8] = utf8 "太子制革店。",
      [9] = utf8 "伯特二手石化产品商场。",
    },
    num_disease = utf8 "%d个病人患有%s，他们需要紧急治疗。",
    cure_possible_drug_name_efficiency = utf8 "您已经拥有了要求的设备和技能。您拥有他们所需要的药品。药品%s的疗效为%d%%。",
    cure_not_possible_employ = utf8 "您将需要雇佣一名%s",
    cure_not_possible = utf8 "现在您还不能治疗这种疾病。",
    cure_possible = utf8 "由于您拥有准备和技能，所以您应该可以处理这个紧急事件。",
    choices = {
      accept = utf8 "好的。我已做好准备处理紧急事件。",
      refuse = utf8 "不。我拒绝处理这个紧急事件。",
    },
    location = utf8 "在%s发生了事故",
    cure_not_possible_build = "You will need to build a %s",
    cure_not_possible_build_and_employ = "You will need to build a %s and employ a %s",
    bonus = utf8 "处理这个紧急事件的最大奖金额为%d。如果您失败了，则您的声望将大幅下降。",
  },
  debug_fax = {
    text4 = "FACTORS  : DOCS %d  NURSES %d  AREA %d  ROOMS %d  PRICING %d",
    text5 = "CONTRIBN : DOCS %d  NURSES %d  AREA %d  ROOMS %d  PRICING %d PERCENT",
    text3 = "FIGURES  : DOCS %d  NURSES %d  AREA %d  ROOMS %d  PRICING %d",
    text9 = "DISASTERS %d ALLOWED (MTHS) %d (%d)REDUCTION %d",
    close_text = utf8 "嗨，哈，哈！",
    text1 = "BEST COUNT %d",
    text6 = "THE FOLLOWING FACTORS ARE ALSO APPLIED",
    text8 = "AMENITIES %d PEEPS HANDLED %d REDUCTION %d",
    text2 = "TOTAL PEOPLE IN HOSPITAL %d CHECKING AGAINST %d",
    text10 = "KILLS %d ALLOWED (MTHS) %d (%d) REDUCTION %d",
    text11 = "PEOPLE THIS MONTH %d",
    text7 = "REPUTATION: %d EXPECTED %d REDUCTION %d",
  },
  epidemic = {
    cover_up_explanation_1 = utf8 "如果您想要掩盖传染，您将必须在有限时间内，即卫生巡查员到来之前，治愈所有被传染的病人。",
    cover_up_explanation_2 = utf8 "如果卫生巡查员到达，并发现了您正在试图掩盖传染，则他将对您采取严厉的惩罚。",
    choices = {
      cover_up = utf8 "在指定时间内且病人离开医院之前，尽量治愈所有被感染的病人。",
      declare = utf8 "宣布一种传染病。支付罚款且名誉受损。",
    },
    disease_name = utf8 "医生发现了传染病%s。",
    declare_explanation_fine = utf8 "如果您宣布出现传染，则您将支付罚款%d，且名誉受损。所有病人将自动被接种疫苗。",
  },
  diagnosis_failed = {
    choices = {
      send_home = utf8 "送病人回家。",
      take_chance = utf8 "尝试治疗病人。",
      wait = utf8 "让病人多等待一会儿，您需要多建造一些诊断室。",
    },
    situation = utf8 "我们已经对该病人尝试了所有可供使用的机器，但是仍然没有发现病因。",
    what_to_do_question = utf8 "我们将怎样处置这个病人？",
    partial_diagnosis_percentage_name = utf8 "我们有%d%%的概率确定该病人所患疾病类型。",
  },
}
transactions = {
  severance = utf8 "隔离花费",
  research = utf8 "研究花费",
  eoy_trophy_bonus = utf8 "年度物品奖励",
  buy_object = utf8 "购买物品",
  cure_colon = utf8 "治疗：",
  epidemy_coverup_fine = utf8 "隐瞒传染病罚款",
  final_treat_colon = utf8 "最终治疗",
  jukebox = utf8 "收入：投币音乐盒",
  loan_interest = utf8 "贷款利率",
  overdraft = utf8 "透支利率",
  wages = utf8 "工资",
  loan_repayment = utf8 "贷款偿还",
  personal_bonus = utf8 "支付个人奖金",
  drug_cost = utf8 "药品花费",
  cure = utf8 "治愈",
  heating = utf8 "供暖费",
  treat_colon = utf8 "治疗：",
  compensation = utf8 "政府赔偿金",
  epidemy_fine = utf8 "传染病罚款",
  buy_land = utf8 "购买土地",
  research_bonus = utf8 "研究奖金",
  general_bonus = utf8 "支付一般奖金",
  deposit = utf8 "治疗收入",
  eoy_bonus_penalty = utf8 "年度奖金/罚款",
  cheat = utf8 "骗钱",
  drinks = utf8 "收入：饮料机",
  vaccination = utf8 "接种疫苗",
  advance_colon = utf8 "高级：",
  vip_award = utf8 "贵宾现金奖励",
  hire_staff = utf8 "雇佣员工",
  bank_loan = utf8 "银行贷款",
  machine_replacement = utf8 "更换机器花费",
  emergency_bonus = utf8 "支付紧急事件奖金",
  build_room = utf8 "建造房屋",
  insurance_colon = utf8 "保险费：",
  sell_object = utf8 "卖出物品",
}
letter = {
  [1] = {
    [1] = utf8 "亲爱的%s//",
    [2] = utf8 "太令人惊奇了！您已经成功地经营了这个医院。",
    [3] = utf8 "卫生部的官员想要知道您是否有兴趣接手一个大项目。我们认为有一个工作",
    [4] = utf8 "对您很适合。薪水将达到$%d。怎么样。//",
    [5] = utf8 "您是否对%s医院的工作感兴趣？",
  },
  [2] = {
    [1] = utf8 "亲爱的%s//",
    [2] = utf8 "太棒了！您的医院经营得很好。我们又有了一些新的任务。",
    [3] = utf8 "如果您喜欢新的挑战，可以接受这项任务。您不要勉强，",
    [4] = utf8 "但这项工作确实很适合您。薪水是$%d//",
    [5] = utf8 "您希望接管%s医院吗？",
  },
  [3] = {
    [1] = utf8 "亲爱的%s//",
    [2] = utf8 "在您接管这座医院期间，管理非常成功。因此，我们对您寄予",
    [3] = utf8 "厚望，并为您找到了一个新的工作。薪水将达到$%d，同时我们",
    [4] = utf8 "也希望您喜欢新的挑战。//",
    [5] = utf8 "您希望接手%s医院吗？",
  },
  [4] = {
    [1] = utf8 "亲爱的%s//",
    [2] = utf8 "恭喜！部门官员对您的能力赞不绝口。您是卫生",
    [3] = utf8 "部的第一高手。我们觉得您一定喜欢更困难的工作。",
    [4] = utf8 "您的薪水将达到$%d，但决定权在您手中。//",
    [5] = utf8 "您是否愿意在%s医院工作？",
  },
  [5] = {
    [1] = utf8 "亲爱的%s//",
    [2] = utf8 "您好。我们尊重您不希望离开这个迷人的医院，但是提醒您要",
    [3] = utf8 "仔细考虑。您的薪水将达到$%d，如果您愿意到其它医院工作",
    [4] = utf8 "并将其运行得很好。//",
    [5] = utf8 "您现在是否愿意移动到%s医院？",
  },
  [6] = {
    [1] = utf8 "亲爱的%s//",
    [2] = utf8 "恭喜。我们理解您在这个可爱的运行良好医院中工作的快乐心情，",
    [3] = utf8 "但是我们认为您现在应该为未来考虑。您的薪水将达到$%d，如",
    [4] = utf8 "果您决定调任。这是很值得考虑的。//",
    [5] = utf8 "您是否愿意接手%s医院？",
  },
  [7] = {
    [1] = utf8 "亲爱的%s//",
    [2] = utf8 "您好！卫生部想要知道您经过重新考虑是否决定仍然留在当前的",
    [3] = utf8 "医院中。我们很欣赏您现在那个可爱的医院，但我们觉得您如果愿意接受这",
    [4] = utf8 "个极富挑战性的工作，也一定能干得很好，并且您的薪水将达到$%d。//",
    [5] = utf8 "您是否愿意接手%s医院？",
  },
  [8] = {
    [1] = utf8 "亲爱的%s//",
    [2] = utf8 "您好。您否定了我们上一封信中提供的",
    [3] = utf8 "新医院，以及薪水$%d。我们觉得不论怎样，您必须重新考虑这个",
    [4] = utf8 "决定。我们已经为您准备了一个很好的工作。//",
    [5] = utf8 "您是否愿意接手%s医院？怎么样？",
  },
  [9] = {
    [1] = utf8 "亲爱的%s//",
    [2] = utf8 "您已经成功地证明了自己是医学界有史以来最棒的管理者。这样的成就一定要给予奖励，因此我们决定任命您为所有医院的至尊主席。这是一项光荣的工作，且薪水可以达到$%d。不论您走到那里，都将受到人们的热烈欢迎。//",
    [3] = utf8 "感谢您的努力工作。希望您好好享受未来的半退休生活。//",
  },
  [10] = {
    [1] = utf8 "亲爱的%s//",
    [2] = utf8 "恭喜您在我们指派的每个医院中的成功管理。您的成功表现使您可以自由出入世界各大城市。您将获得退休金$%d，再加上一辆轿车，我们希望您在旅途中能够促进各个医院管理水平的提高。//",
    [3] = utf8 "我们都为您感到骄傲。我们中间每个人都为您挽救生命感到由衷的感谢。//",
  },
  [11] = {
    [1] = utf8 "亲爱的%s//",
    [2] = utf8 "您的工作十分成功，我们从您身上获得了灵感。谢谢您管理了这么多个医院，并使它们都运行得很出色。我们将给予您终身工资$%d，并提供政府敞蓬轿车使您可以从一个城市到另一个城市，发表演讲告诉公众您是怎样在这么短的时间内达到如此成就。//",
    [3] = utf8 "您是所有人的榜样，毫无例外，世界上每个人都以您为荣。//",
  },
  [12] = {
    [1] = utf8 "亲爱的%s//",
    [2] = utf8 "您的成就使您成为最好的医院管理者。卫生部将向您提供$%d作为奖励，并召开庆祝会。整个世界都在为您沸腾，太棒了！//",
    [3] = utf8 "请接受我们的安排。如果您不再希望辛苦工作，我们将向您提供一辆轿车，且无论走到那里，都有警察为您开路。//",
  },
}
casebook = {
  sent_home = utf8 "转走",
  deaths = utf8 "事故",
  treatment_charge = utf8 "治疗花费",
  reputation = utf8 "声望",
  research = utf8 "集中研究",
  cure = utf8 "治疗",
  cured = utf8 "恢复",
  earned_money = utf8 "收入",
  cure_desc = {
    hire_psychiatrists = utf8 "您需要雇佣一些精神病医生。",
    improve_cure = utf8 "提高疗效。",
    hire_nurses = utf8 "您需要雇佣一些护士。",
    build_ward = utf8 "您仍需要建造一个病房。",
    no_cure_known = utf8 "未治愈。",
    cure_known = utf8 "治愈。",
    build_room = utf8 "我建议您修建%s",
    hire_doctors = utf8 "您需要雇佣一些医生。",
    hire_surgeons = utf8 "您需要雇佣一些外科医生。",
  },
}
diseases = {
  diag_ward = {
    name = utf8 "病房诊断",
  },
  diag_ultrascan = {
    name = utf8 "超级扫描仪诊断",
  },
  autopsy = {
    name = utf8 "验尸",
  },
  third_degree_sideburns = {
    cause = utf8 "病因－向往20世纪70年代。",
    cure = utf8 "治疗－精神病医生必须使用最新科技，使病人认识到这些奇装异服都是垃圾。",
    name = utf8 "络腮胡子",
    symptoms = utf8 "症状－长头发，全身闪闪发光。",
  },
  discrete_itching = {
    cause = utf8 "病因－昆虫叮咬。",
    cure = utf8 "治疗－病人喝下胶状糖浆阻止皮肤发痒。",
    name = utf8 "搔痒症",
    symptoms = utf8 "症状－到处乱抓，引起全身发炎。",
  },
  the_squits = {
    cause = utf8 "病因－吃了变质的比萨饼。",
    cure = utf8 "治疗－服用粘性药剂修补病人的内脏。",
    name = utf8 "呕吐",
    symptoms = utf8 "症状－噢。想必您也可以猜得到。",
  },
  spare_ribs = {
    cause = utf8 "病因－坐在冰冷的石地板上。",
    cure = utf8 "治疗－由两名外科医生执行手术。",
    name = utf8 "瘦骨",
    symptoms = utf8 "症状－胸部感觉不适。",
  },
  diag_blood_machine = {
    name = utf8 "血液机器诊断",
  },
  king_complex = {
    cause = utf8 "病因－猫王的思想进入病人大脑并取而代之。",
    cure = utf8 "治疗－由精神病医生告诉病人其荒谬的举止。",
    name = utf8 "猫王综合症",
    symptoms = utf8 "症状－穿着举止怪异。",
  },
  diag_x_ray = {
    name = utf8 "X光诊断",
  },
  pregnancy = {
    cause = utf8 "病因－怀孕。",
    cure = utf8 "治疗－在手术中心中将婴儿取出，洗净送到病人面前。",
    name = utf8 "产妇",
    symptoms = utf8 "症状－不断增大的啤酒肚。",
  },
  fake_blood = {
    cause = utf8 "病因－病人常常开玩笑。",
    cure = utf8 "治疗－只有精神病医生才能使病人安静下来。",
    name = utf8 "假血",
    symptoms = utf8 "症状－流出红色液体。",
  },
  diag_psych = {
    name = utf8 "精神病诊断",
  },
  invisibility = {
    cause = utf8 "病因－被有放射性的蚂蚁叮咬。",
    cure = utf8 "治疗－在药房喝下彩色液体，将很快使病人恢复正常。",
    name = utf8 "隐身",
    symptoms = utf8 "症状－病人本身感觉不到任何不适，并常常和家里人开玩笑。",
  },
  golf_stones = {
    cause = utf8 "病因－吸入了高尔夫球内部的有毒气体。",
    cure = utf8 "治疗－由两名外科医生执行手术。",
    name = utf8 "高尔夫症",
    symptoms = utf8 "症状－神经错乱且胡言乱语。",
  },
  diag_general_diag = {
    name = utf8 "一般诊断",
  },
  infectious_laughter = {
    cause = utf8 "病因－观看古典喜剧。",
    cure = utf8 "治疗－一位精神病医生必须让病人了解其当前严重的病情。",
    name = utf8 "狂笑症",
    symptoms = utf8 "症状－不住狂笑。",
  },
  general_practice = {
    name = utf8 "一般诊断",
  },
  baldness = {
    cause = utf8 "病因－向公众说谎话。",
    cure = utf8 "治疗－使用仪器将头发缝合到病人的头上。",
    name = utf8 "秃顶",
    symptoms = utf8 "症状－脑门发亮，十分困窘。",
  },
  heaped_piles = {
    cause = utf8 "病因－站立在水冷却器旁边。",
    cure = utf8 "治疗－服用药剂。",
    name = utf8 "痔疮",
    symptoms = utf8 "症状－病人感觉就象坐在大理石上。",
  },
  unexpected_swelling = {
    cause = utf8 "病因－意外事件。",
    cure = utf8 "治疗－由两名外科医生实行手术。",
    name = utf8 "肿胀",
    symptoms = utf8 "症状－肿胀。",
  },
  jellyitis = {
    cause = utf8 "病因－日常饮食含有过多的胶状物并完成太多的练习。",
    cure = utf8 "治疗－将病人浸入到胶桶中。",
    name = utf8 "失衡症",
    symptoms = utf8 "症状－走路摇摇晃晃并不时摔倒。",
  },
  hairyitis = {
    cause = utf8 "病因－在月光下停留过长时间。",
    cure = utf8 "治疗－使用电分解机器去掉毛发并填补遗留的毛孔。",
    name = utf8 "多毛症",
    symptoms = utf8 "症状－嗅觉特别灵敏。",
  },
  alien_dna = {
    cause = utf8 "病因－拥有了外星人的DNA。",
    cure = utf8 "治疗－利用仪器快速清除病人体内的DNA。",
    name = utf8 "外星人DNA",
    symptoms = utf8 "症状－逐渐蜕变成外星人并阴谋摧毁我们的城市。",
  },
  bloaty_head = {
    cause = utf8 "病因－闻到了坏乳酪并喝了不干净的雨水。",
    cure = utf8 "治疗－打破肿胀脑袋，并使用充气机使脑袋恢复正常。",
    name = utf8 "头部肿胀",
    symptoms = utf8 "症状－非常不舒服。",
  },
  gastric_ejections = {
    cause = utf8 "病因－吃了过辣的四川菜。",
    cure = utf8 "治疗－服用特殊凝固剂从而阻止呕吐。",
    name = utf8 "反胃症",
    symptoms = utf8 "症状－半消化的食物被病人不时吐出。",
  },
  uncommon_cold = {
    cause = utf8 "病因－吸进了空气中的灰尘。",
    cure = utf8 "治疗－服用药房配制的特效药。",
    name = utf8 "感冒",
    symptoms = utf8 "症状－流鼻涕，打喷嚏。",
  },
  corrugated_ankles = {
    cause = utf8 "病因－驾驶时间过长。",
    cure = utf8 "治疗－服用少量毒草和香料制成的药剂，从而打通关节。",
    name = utf8 "脚踝弯曲",
    symptoms = utf8 "症状－脚踝感觉不舒服。",
  },
  sleeping_illness = {
    cause = utf8 "病因－内分泌失调。",
    cure = utf8 "治疗－由护士配制一剂威力强大的兴奋剂给病人服用。",
    name = utf8 "嗜睡症",
    symptoms = utf8 "症状－无论走到那里都想睡觉。",
  },
  sweaty_palms = {
    cause = utf8 "病因－害怕找工作时的面试。",
    cure = utf8 "治疗－精神病医生使病人走出心理误区。",
    name = utf8 "手心出汗症",
    symptoms = utf8 "症状－当与病人握手时，感觉就象攥着一块吸满了水的海绵。",
  },
  serious_radiation = {
    cause = utf8 "病因－不小心错误吞吃了含有钚元素的口香糖。",
    cure = utf8 "治疗－病人必须被放置在净化淋浴器内彻底清洗。",
    name = utf8 "放射病",
    symptoms = utf8 "症状－病人感到非常非常的不舒服。",
  },
  diag_cardiogram = {
    name = utf8 "心电图仪诊断",
  },
  diag_scanner = {
    name = utf8 "扫描仪诊断",
  },
  gut_rot = {
    cause = utf8 "病因－喝了太多的威士忌酒。",
    cure = utf8 "治疗－由护士配制药剂，交给病人服下。",
    name = utf8 "内脏腐烂",
    symptoms = utf8 "症状－不咳嗽，但胃壁也没有了。",
  },
  iron_lungs = {
    cause = utf8 "病因－城市中浑浊的空气。",
    cure = utf8 "治疗－两名外科医生在手术中心执行手术。",
    name = utf8 "铁肺",
    symptoms = utf8 "症状－浑身难受。",
  },
  broken_wind = {
    cause = utf8 "病因－饭后使用健身房的脚踏车进行运动。",
    cure = utf8 "治疗－服用药房配制的特效药。",
    name = utf8 "臭屁症",
    symptoms = utf8 "症状－使身后的人感到极度的不舒服。",
  },
  kidney_beans = {
    cause = utf8 "病因－饮料中加入了大量冰块。",
    cure = utf8 "治疗－由两名外科医生执行手术。",
    name = utf8 "肾豆",
    symptoms = utf8 "症状－疼痛且经常去厕所。",
  },
  transparency = {
    cause = utf8 "病因－舔了打开的容器的铅箔上的酸乳酪。",
    cure = utf8 "治疗－服用药房配制的特殊清凉彩色冲剂就可以治愈疾病。",
    name = utf8 "透明症",
    symptoms = utf8 "症状－肌肉变得透明，对光敏感。",
  },
  broken_heart = {
    cause = utf8 "病因－一些人比病人富有，年轻，瘦。",
    cure = utf8 "治疗－由两名外科医生打开病人的胸腔，轻轻地修补其心脏缺陷。",
    name = utf8 "破碎的心",
    symptoms = utf8 "症状－痛哭流涕。",
  },
  slack_tongue = {
    cause = utf8 "病因－过多地讨论肥皂剧。",
    cure = utf8 "治疗－将舌头放入舌头切片机中，将快速有效地得到治疗。",
    name = utf8 "舌头松弛症",
    symptoms = utf8 "症状－舌头增长到正常的5倍。",
  },
  tv_personalities = {
    cause = utf8 "病因－日间电视节目。",
    cure = utf8 "治疗－一位精神病医生必须使病人有信心卖掉电视机，而购买收音机。",
    name = utf8 "电视病",
    symptoms = utf8 "症状－产生错觉，以为自己正在表演。",
  },
  ruptured_nodules = {
    cause = utf8 "病因－在寒冷的季节中跳跃。",
    cure = utf8 "治疗－两名称职的外科医生必须使用稳定的双手切除肿瘤。",
    name = utf8 "肿瘤",
    symptoms = utf8 "症状－无法舒适地坐下。",
  },
  fractured_bones = {
    cause = utf8 "病因－从高处摔到混凝土地面上。",
    cure = utf8 "治疗－将已打好的石膏使用仪器去除。",
    name = utf8 "骨折",
    symptoms = utf8 "症状－剧痛且无法使用四肢。",
  },
  chronic_nosehair = {
    cause = utf8 "病因－经常对不如自己的人嗤之以鼻。",
    cure = utf8 "治疗－口服令人厌恶的毛发去除剂，该药剂由护士在药房配制。",
    name = utf8 "鼻毛过多症",
    symptoms = utf8 "症状－鼻毛过长过多，快成鸟巢了。",
  },
}
policy = {
  header = utf8 "医院制度",
  diag_termination = utf8 "诊断结束",
  sliders = {
    guess = utf8 "尝试治疗",
    send_home = utf8 "遣送回家",
    stop = utf8 "停止治疗",
    staff_room = utf8 "去员工休息室",
  },
  diag_procedure = utf8 "诊断程序",
  staff_rest = utf8 "员工休息",
  staff_leave_rooms = utf8 "员工离开房间",
}
competitor_names = {
  [1] = utf8 "神谕",
  [2] = utf8 "黑尔",
  [3] = utf8 "巨人",
  [4] = utf8 "马笛维克",
  [5] = utf8 "冬青树",
  [6] = utf8 "沉思",
  [7] = utf8 "禅",
  [8] = utf8 "里昂",
  [9] = utf8 "晶体",
  [10] = utf8 "萨姆",
  [11] = utf8 "查理",
  [12] = utf8 "洁尼",
  [13] = utf8 "亚瑟",
  [14] = utf8 "马格尼斯",
  [15] = utf8 "母亲",
  [16] = utf8 "赛尔",
  [17] = utf8 "玛文",
  [18] = utf8 "约书亚",
  [19] = utf8 "丹尼尔",
  [20] = utf8 "奥利文",
  [21] = utf8 "尼克",
}
confirmation = {
  quit = utf8 "您已经选择了退出。您是否确定真的要退出游戏？",
  return_to_blueprint = utf8 "您是否确定返回蓝图模式？",
  restart_level = utf8 "您是否希望重新开始这个任务？",
  overwrite_save = utf8 "该位置已储存游戏进度。您是否确定要将其覆盖？",
  delete_room = utf8 "您是否希望拆除这个房间？",
  sack_staff = utf8 "您是否确定要解雇该员工？",
  replace_machine = utf8 "您是否确定将%s更新，需花费$%d？",
}
menu_display = {
  high_res = utf8 " 阴影",
}
trophy_room = {
  happy_vips = {
    awards = {
      [1] = utf8 "由于您的医院在过去一年中给来访的贵宾们留下了深深地好感，特此向您颁发诺贝尔奖。",
      [2] = utf8 "由于您的医院在过去一年中使每一位来访贵宾都感到了员工的工作热情，特此颁发贵宾满意奖。",
    },
    trophies = {
      [1] = utf8 "由于您的医院使每位造访贵宾都感到快乐，特此由名人机构颁发著名人士奖。您已经成为我们名人行列中的一员。",
    },
  },
  rats_killed = {
    awards = {
    },
    trophies = {
      [1] = utf8 "由于您的医院在过去一年中共击毙了%d只老鼠，特此颁发除害奖。",
      [2] = utf8 "由于您高超的击鼠技巧共击毙老鼠%d只，特此颁发联邦灭鼠奖。",
      [3] = utf8 "由于您的医院在过去一年中共击毙了%d只老鼠，特此颁发老鼠克星奖。",
    },
  },
  rats_accuracy = {
    awards = {
    },
    trophies = {
      [1] = utf8 "由于您击打老鼠的命中率为%d%%，特此颁发极道枭雄2射击准确奖。",
      [2] = utf8 "由于您的医院在过去一年中以难以置信的命中率%d%%击毙老鼠，特此颁奖。",
      [3] = utf8 "由于您的医院在过去一年中击毙了%d%%的老鼠，特此颁发地下城守护者除害奖。恭喜！",
    },
  },
  all_cured = {
    awards = {
      [1] = utf8 "由于您的医院在过去一年中成功地治疗了所有病人，特此颁发玛丽治疗奖。",
    },
    trophies = {
      [1] = utf8 "由于您的医院在过去一年中成功地治疗了就诊的每个病人，国际治疗基金会特此向您颁发全部治愈奖。",
      [2] = utf8 "由于您的医院在过去一年中治愈了大量患者，特此颁发疾病克星奖。",
    },
  },
  many_cured = {
    awards = {
      [1] = utf8 "由于您的医院在过去一年中成功地治疗了几乎所有病人，特此恭喜您荣获玛丽治疗奖。",
    },
    trophies = {
      [1] = utf8 "由于您的医院在过去一年中治愈了大量患者，国际治疗基金会特此向您颁发悬壶济世奖。",
      [2] = utf8 "由于您的医院在过去一年中治愈了大量患者，特此颁发疾病克星奖。",
    },
  },
  healthy_plants = {
    awards = {
      [1] = utf8 "由于您的医院在过去一年中是植物保持健康成长，特此颁发茁壮成长奖。",
    },
    trophies = {
      [1] = utf8 "由于您的医院在过去十二个月中使所有植物长势良好，特此盆栽植物协会向您颁发绿色健康奖。",
      [2] = utf8 "由于您的医院在过去一年中使所有植物长势良好，特此颁发绿色名人奖。",
    },
  },
  no_deaths = {
    awards = {
      [1] = utf8 "由于您的医院在过去一年中没有发生任何病人死亡事件，特此颁发安全奖。",
    },
    trophies = {
      [1] = utf8 "由于您的医院在过去一年中没有发生病人死亡事件，特此由生命发展组织向您颁奖。",
      [2] = utf8 "由于您的医院在过去一年中避免发生病人死亡事件，特此颁发挽留妙手回春奖。",
    },
  },
  sold_drinks = {
    awards = {
    },
    trophies = {
      [1] = utf8 "由于您的医院在过去一年中售出了大量的罐装饮料，特此由全球牙医联合会向您颁奖。",
      [2] = utf8 "由于您的医院在过去一年中卖出大量饮料，特此软饮料零售组织向您颁发清凉饮料奖。",
      [3] = utf8 "由于您的医院在过去一年中卖出大量软饮料，特此由DK填充公司向您颁发巧克力奖杯。",
    },
  },
  high_rep = {
    awards = {
      [1] = utf8 "由于您的医院在过去一年中无懈可击的运营以及最高的声望，您被授予内阁大臣奖。干得好。",
      [2] = utf8 "由于您的医院在过去一年中赢得了最高的声望，特此颁发牛蛙奖。这是您应得的。",
    },
    trophies = {
      [1] = utf8 "由于您的医院在过去一年中赢得了最高的声望，特此颁发白衣天使奖。这是您应得的。",
    },
  },
  happy_staff = {
    awards = {
    },
    trophies = {
      [1] = utf8 "由于您的医院在过去一年中使努力工作的员工保持快乐，特此颁发微笑奖。",
      [2] = utf8 "由于您的医院在过去一年中没有不快乐的员工，特此颁发阿达尼学院奖。",
      [3] = utf8 "由于您的医院在过去一年中使努力工作的员工保持快乐，特此颁发笑星奖杯。快乐地笑吧！",
    },
  },
}
menu_options_volume = {
  [50] = " 50%  ",
  [100] = " 100%  ",
  [30] = " 30%  ",
  [60] = " 60%  ",
  [90] = " 90%  ",
  [10] = " 10%  ",
  [20] = " 20%  ",
  [40] = " 40%  ",
  [80] = " 80%  ",
  [70] = " 70%  ",
}
menu_file_load = {
  [1] = utf8 " 存档一 ",
  [2] = utf8 " 存档二 ",
  [3] = utf8 " 存档三 ",
  [4] = utf8 " 存档四 ",
  [5] = utf8 " 存档五 ",
  [6] = utf8 " 存档六 ",
  [7] = utf8 " 存档七 ",
  [8] = utf8 " 存档八 ",
}
menu_file = {
  quit = utf8 " 退出 ",
  save = utf8 " 存储 ",
  load = utf8 " 读取 ",
  restart = utf8 " 重新开始 ",
}
high_score = {
  categories = {
    deaths = utf8 "死亡人数",
    total_value = utf8 "总价值",
    money = utf8 "最富有",
    cures = utf8 "治愈人数",
    visitors = utf8 "访问者最多",
    staff_number = utf8 "员工数目最多",
    cure_death_ratio = utf8 "医治无效死亡率",
    patient_happiness = utf8 "顾客满意",
    staff_happiness = utf8 "员工满意",
    salary = utf8 "工资最高",
    clean = utf8 "最干净",
  },
  player = utf8 "玩家",
  score = utf8 "分数",
  pos = utf8 "名次",
  best_scores = utf8 "荣誉堂",
  worst_scores = utf8 "耻辱堂",
  killed = utf8 "杀死病人数目",
}
menu_debug = {
  sprite_viewer = "  SPRITE VIEWER  ",
  lose_game_anim = {
    [1] = " LOSE GAME 1 ANIM     ",
    [2] = " LOSE GAME 2 ANIM     ",
    [3] = " LOSE GAME 3 ANIM     ",
    [4] = " LOSE GAME 4 ANIM     ",
    [5] = " LOSE GAME 5 ANIM     ",
    [6] = " LOSE GAME 6 ANIM     ",
    [7] = " LOSE GAME 7 ANIM     ",
  },
  show_watch = "  SHOW WATCH  ",
  disable_salary_raise = "  DISABLE SALARY RAISE  ",
  object_cells = " OBJECT CELLS         ",
  create_emergency = "  CREATE EMERGENCY  ",
  make_adviser_talk = "  MAKE ADVISER TALK  ",
  dump_strings = "  DUMP STRINGS  ",
  limit_camera = "  LIMIT CAMERA  ",
  machine_pagers = " MACHINE PAGERS       ",
  remove_walls = " REMOVE WALLS         ",
  place_objects = "  PLACE OBJECTS  ",
  enter_nav_debug = " ENTER NAV DEBUG      ",
  remove_objects = " REMOVE OBJECTS       ",
  display_pager = " DISPLAY PAGER        ",
  map_overlay = "  MAP OVERLAY  ",
  spawn_patient = "  SPAWN PATIENT  ",
  pixbuf_cells = " PIXBUF CELLS         ",
  win_game_anim = " WIN GAME ANIM        ",
  transparent_walls = "  TRANSPARENT WALLS  ",
  show_help_hotspot = " SHOW HELP HOTSPOTS   ",
  entry_cells = " ENTRY CELLS          ",
  nav_bits = " NAV BITS             ",
  display_big_cells = " DISPLAY BIG CELLS    ",
  win_level_anim = " WIN LEVEL ANIM       ",
  make_debug_patient = "  MAKE DEBUG PATIENT  ",
  porter_pagers = " PORTER PAGERS        ",
  keep_clear_cells = " KEEP CLEAR CELLS     ",
  show_nav_cells = " SHOW NAV CELLS       ",
  display_room_status = " DISPLAY ROOM STATUS  ",
  mapwho_checking = " MAPWHO CHECKING      ",
  plant_pagers = " PLANT PAGERS         ",
}
original_credits = {
  [1] = "",
  [2] = "",
  [3] = "",
  [4] = "",
  [5] = "",
  [6] = "",
  [7] = "",
  [8] = "",
  [9] = "",
  [10] = "",
  [11] = "",
  [12] = utf8 ":设计制作",
  [13] = utf8 ":牛蛙制造",
  [14] = "",
  [15] = utf8 ":冥王星开发组",
  [16] = ",",
  [17] = "Mark Webley",
  [18] = "Gary Carr",
  [19] = "Matt Chilton",
  [20] = "Matt Sullivan",
  [21] = "Jo Rider",
  [22] = "Rajan Tande",
  [23] = "Wayne Imlach",
  [24] = "Andy Bass",
  [25] = "Jon Rennie",
  [26] = "Adam Coglan",
  [27] = "Natalie White",
  [28] = "",
  [29] = "",
  [30] = "",
  [31] = utf8 ":编程",
  [32] = ",",
  [33] = "Mark Webley",
  [34] = "Matt Chilton",
  [35] = "Matt Sullivan",
  [36] = "Rajan Tande",
  [37] = "",
  [38] = "",
  [39] = "",
  [40] = utf8 ":美工",
  [41] = ",",
  [42] = "Gary Carr",
  [43] = "Jo Rider",
  [44] = "Andy Bass",
  [45] = "Adam Coglan",
  [46] = "",
  [47] = "",
  [48] = "",
  [49] = utf8 ":助理编程",
  [50] = ",",
  [51] = "Ben Deane",
  [52] = "Gary Morgan",
  [53] = "Jonty Barnes",
  [54] = "",
  [55] = "",
  [56] = "",
  [57] = utf8 ":助理美工",
  [58] = ",",
  [59] = "Eoin Rogan",
  [60] = "George Svarovsky",
  [61] = "Saurev Sarkar",
  [62] = "Jason Brown",
  [63] = "John Kershaw",
  [64] = "Dee Lee",
  [65] = "",
  [66] = "",
  [67] = "",
  [68] = utf8 ":游戏介绍",
  [69] = ",",
  [70] = "Stuart Black",
  [71] = "",
  [72] = "",
  [73] = "",
  [74] = utf8 ":音乐音效",
  [75] = ",",
  [76] = "Russell Shaw",
  [77] = "Adrian Moore",
  [78] = "",
  [79] = "",
  [80] = "",
  [81] = utf8 ":音乐助理",
  [82] = ",",
  [83] = "Jeremy Longley",
  [84] = "Andy Wood",
  [85] = "",
  [86] = "",
  [87] = "",
  [88] = utf8 ":配音",
  [89] = ",",
  [90] = "Rebecca Green",
  [91] = "",
  [92] = "",
  [93] = "",
  [94] = utf8 ":任务设计",
  [95] = ",",
  [96] = "Wayne Imlach",
  [97] = "Natalie White",
  [98] = "Steven Jarrett",
  [99] = "Shin Kanaoya",
  [100] = "",
  [101] = "",
  [102] = "",
  [103] = utf8 ":剧本",
  [104] = ",",
  [105] = "James Leach",
  [106] = "Sean Masterson",
  [107] = "Neil Cook",
  [108] = "",
  [109] = "",
  [110] = "",
  [111] = ":R&D",
  [112] = "",
  [113] = utf8 ":图形引擎",
  [114] = ",",
  [115] = "Andy Cakebread",
  [116] = "Richard Reed",
  [117] = "",
  [118] = "",
  [119] = "",
  [120] = utf8 ":R&D支持",
  [121] = ",",
  [122] = "Glenn Corpes",
  [123] = "Martin Bell",
  [124] = "Ian Shaw",
  [125] = "Jan Svarovsky",
  [126] = "",
  [127] = "",
  [128] = "",
  [129] = utf8 ":库和工具",
  [130] = "",
  [131] = utf8 "Dos和Win 95库",
  [132] = ",",
  [133] = "Mark Huntley",
  [134] = "Alex Peters",
  [135] = "Rik Heywood",
  [136] = "",
  [137] = "",
  [138] = "",
  [139] = utf8 ":网络库",
  [140] = ",",
  [141] = "Ian Shippen",
  [142] = "Mark Lamport",
  [143] = "",
  [144] = "",
  [145] = "",
  [146] = utf8 ":声音库",
  [147] = ",",
  [148] = "Russell Shaw",
  [149] = "Tony Cox",
  [150] = "",
  [151] = "",
  [152] = "",
  [153] = utf8 ":安装程序",
  [154] = ",",
  [155] = "Andy Nuttall",
  [156] = "Tony Cox",
  [157] = "Andy Cakebread",
  [158] = "",
  [159] = "",
  [160] = "",
  [161] = utf8 ":支持",
  [162] = ",",
  [163] = "Peter Molyneux",
  [164] = "",
  [165] = "",
  [166] = "",
  [167] = utf8 ":测试经理",
  [168] = ",",
  [169] = "Andy Robson",
  [170] = "",
  [171] = "",
  [172] = "",
  [173] = utf8 ":测试主管",
  [174] = ",",
  [175] = "Wayne Imlach",
  [176] = "Jon Rennie",
  [177] = "",
  [178] = "",
  [179] = "",
  [180] = utf8 ":测试",
  [181] = ",",
  [182] = "Jeff Brutus",
  [183] = "Wayne Frost",
  [184] = "Steven Lawrie",
  [185] = "Tristan Paramor",
  [186] = "Nathan Smethurst",
  [187] = "",
  [188] = "Ryan Corkery",
  [189] = "Simon Doherty",
  [190] = "James Dormer",
  [191] = "Martin Gregory",
  [192] = "Ben Lawley",
  [193] = "Joel Lewis",
  [194] = "David Lowe",
  [195] = "Robert Monczak",
  [196] = "Dominic Mortoza",
  [197] = "Karl O'Keeffe",
  [198] = "Michael Singletary",
  [199] = "Andrew Skipper",
  [200] = "Stuart Stephen",
  [201] = "David Wallington",
  [202] = "",
  [203] = "And all our other Work Experience Play Testers",
  [204] = "",
  [205] = "",
  [206] = "",
  [207] = utf8 ":技术支持",
  [208] = ",",
  [209] = "Kevin Donkin",
  [210] = "Mike Burnham",
  [211] = "Simon Handby",
  [212] = "",
  [213] = "",
  [214] = "",
  [215] = utf8 ":市场",
  [216] = ",",
  [217] = "Pete Murphy",
  [218] = "Sean Ratcliffe",
  [219] = "",
  [220] = "",
  [221] = "",
  [222] = utf8 ":特别感谢",
  [223] = ",",
  [224] = "Tamara Burke",
  [225] = "Annabel Roose",
  [226] = "Chris Morgan",
  [227] = "Pete Larsen",
  [228] = "",
  [229] = "",
  [230] = "",
  [231] = utf8 ":公关",
  [232] = ",",
  [233] = "Cathy Campos",
  [234] = "",
  [235] = "",
  [236] = "",
  [237] = utf8 ":文档",
  [238] = ",",
  [239] = "Mark Casey",
  [240] = "Richard Johnston",
  [241] = "James Lenoel",
  [242] = "Jon Rennie",
  [243] = "",
  [244] = "",
  [245] = "",
  [246] = utf8 ":文档及包装盒设计",
  [247] = ",",
  [248] = "Caroline Arthur",
  [249] = "James Nolan",
  [250] = "",
  [251] = "",
  [252] = "",
  [253] = utf8 ":本地化项目经理",
  [254] = ",",
  [255] = "Carol Aggett",
  [256] = "",
  [257] = "",
  [258] = "",
  [259] = utf8 ":本地化工作",
  [260] = ",",
  [261] = "Sandra Picaper",
  [262] = "Sonia 'Sam' Yazmadjian",
  [263] = "",
  [264] = "Bettina Klos",
  [265] = "Alexa Kortsch",
  [266] = "Bianca Normann",
  [267] = "",
  [268] = "C 。T 。O 。 S 。p 。A 。 Zola Predosa (BO)",
  [269] = "Gian Maria Battistini",
  [270] = "Maria Ziino",
  [271] = "Gabriele Vegetti",
  [272] = "",
  [273] = "Elena Ruiz de Velasco",
  [274] = "Julio Valladares",
  [275] = "Ricardo Mart*nez",
  [276] = "",
  [277] = "Kia Collin",
  [278] = "CBG Consult",
  [279] = "Ulf Thor",
  [280] = "",
  [281] = "",
  [282] = "",
  [283] = utf8 ":生产",
  [284] = ",",
  [285] = "Rachel Holman",
  [286] = "",
  [287] = "",
  [288] = "",
  [289] = utf8 ":制片人",
  [290] = ",",
  [291] = "Mark Webley",
  [292] = "",
  [293] = "",
  [294] = "",
  [295] = utf8 ":联合制片人",
  [296] = ",",
  [297] = "Andy Nuttall",
  [298] = "",
  [299] = "",
  [300] = "",
  [301] = utf8 ":运作",
  [302] = ",",
  [303] = "Steve Fitton",
  [304] = "",
  [305] = "",
  [306] = "",
  [307] = utf8 ":行政",
  [308] = ",",
  [309] = "Audrey Adams",
  [310] = "Annette Dabb",
  [311] = "Emma Gibbs",
  [312] = "Lucia Gobbo",
  [313] = "Jo Goodwin",
  [314] = "Sian Jones",
  [315] = "Kathy McEntee",
  [316] = "Louise Ratcliffe",
  [317] = " ",
  [318] = " ",
  [319] = " ",
  [320] = utf8 ":公司管理",
  [321] = ",",
  [322] = "Les Edgar",
  [323] = "Peter Molyneux",
  [324] = "David Byrne",
  [325] = " ",
  [326] = " ",
  [327] = ":All at Bullfrog Productions",
  [328] = " ",
  [329] = " ",
  [330] = " ",
  [331] = utf8 ":特别感谢",
  [332] = ",",
  [333] = utf8 "弗莱利公园医院中每个人",
  [334] = "",
  [335] = utf8 ":特别是",
  [336] = ",",
  [337] = "Beverley Cannell",
  [338] = "Doug Carlisle",
  [339] = "",
  [340] = "",
  [341] = "",
  [342] = utf8 ":中文版制作",
  [343] = ",",
  [344] = utf8 "飞龙工作室",
  [345] = "",
  [346] = "",
  [347] = "",
  [348] = utf8 ":监制/项目主管",
  [349] = ",",
  [350] = utf8 "曲洋",
  [351] = "",
  [352] = "",
  [353] = utf8 ":翻译：刘波",
  [354] = "",
  [355] = utf8 ":录音师：蓝信刚",
  [356] = "",
  [357] = "",
  [358] = utf8 ":配音：夏莉莉",
  [359] = "",
  [360] = "",
  [361] = "",
  [362] = utf8 ":中文版包装/手册设计",
  [363] = ",",
  [364] = utf8 "骆智中 王越鹏",
  [365] = "",
  [366] = "",
  [367] = utf8 ":生产",
  [368] = ",",
  [369] = utf8 "杨平  张威",
  [370] = "",
  [371] = "",
  [372] = "",
  [373] = utf8 ":测试",
  [374] = ",",
  [375] = utf8 "罗耀  陈雷  赫闻  汤宇力",
  [376] = "",
  [377] = "",
  [378] = utf8 ":特别感谢",
  [379] = ",",
  [380] = "Les Edgar",
  [381] = "Rajan Tande",
  [382] = "Steve Fitton",
  [383] = "",
  [384] = "",
  [385] = "",
  [386] = "",
  [387] = "",
  [388] = "",
  [389] = "",
  [390] = "",
  [391] = "",
  [392] = "",
  [393] = "",
  [394] = "",
  [395] = "",
  [396] = "",
  [397] = ".",
}
drug_companies = {
  [1] = utf8 "良药公司",
  [2] = utf8 "名医公司",
  [3] = utf8 "小药片公司",
  [4] = utf8 "普芬公司",
  [5] = utf8 "欧米尼公司",
}
humanoid_name_ends = {
  [1] = utf8 "斯密斯",
  [2] = utf8 "威克",
  [3] = utf8 "克利夫",
  [4] = utf8 "桑",
  [5] = utf8 "因格顿",
  [6] = utf8 "贝里",
  [7] = utf8 "顿",
  [8] = utf8 "桑",
  [9] = utf8 "李",
  [10] = utf8 "伯利",
  [11] = utf8 "波姆",
  [12] = utf8 "兰",
  [13] = utf8 "汉默",
  [14] = utf8 "希尔",
  [15] = utf8 "温",
  [16] = utf8 "莱特",
  [17] = utf8 "艾尔斯",
  [18] = utf8 "顿",
  [19] = utf8 "蒙德",
  [20] = utf8 "曼",
  [21] = utf8 "爱尔顿",
  [22] = utf8 "依",
  [23] = utf8 "摩",
  [24] = utf8 "摩尔",
  [25] = utf8 "莱特",
  [26] = utf8 "林",
}
graphs = {
  deaths = utf8 "死亡",
  money_in = utf8 "收入",
  money_out = utf8 "支出",
  visitors = utf8 "访问者",
  wages = utf8 "工资",
  balance = utf8 "现金",
  time_spans = {
    [1] = utf8 "1 年",
    [2] = utf8 "12 年",
    [3] = utf8 "48 年",
  },
  cures = utf8 "治愈",
  reputation = utf8 "声望",
}
menu_file_save = {
}
months = {
  [1] = utf8 "1 月",
  [2] = utf8 "2 月",
  [3] = utf8 "3 月",
  [4] = utf8 "4 月",
  [5] = utf8 "5 月",
  [6] = utf8 "6 月",
  [7] = utf8 "7 月",
  [8] = utf8 "8 月",
  [9] = utf8 "9 月",
  [10] = utf8 "10 月",
  [11] = utf8 "11 月",
  [12] = utf8 "12 月",
}
menu_options = {
  game_speed = utf8 " 游戏速度 ",
  sound_vol = utf8 " 音效音量 ",
  announcements = utf8 " 语音 ",
  lock_windows = " LOCK WINDOWS ",
  music_vol = utf8 " 音乐音量 ",
  sound = utf8 " 音效 ",
  announcements_vol = utf8 " 语音音量 ",
  music = utf8 " 音乐 ",
  autosave = utf8 " 自动存盘 ",
  jukebox = utf8 " 音乐盒 ",
}
menu_options_game_speed = {
  normal = utf8 " 正常 ",
  slower = utf8 " 较慢 ",
  pause = " PAUSE ",
  max_speed = utf8 " 快速 ",
  slowest = utf8 " 非常慢 ",
  and_then_some_more = utf8 " 极快 ",
}
menu = {
  debug = " DEBUG ",
  display = utf8 " 显示 ",
  file = utf8 " 文件 ",
  options = utf8 " 选项 ",
  charts = utf8 " 图表 ",
}
rooms_short = {
  ultrascan = utf8 "超级扫描仪",
  research_room = utf8 "研究部门",
  fracture_clinic = utf8 "骨折诊所",
  gps_office = utf8 "一般诊断室",
  destroyed = utf8 "已毁坏",
  staffroom = utf8 "员工休息室",
  jelly_vat = utf8 "胶桶诊所",
  scanner = utf8 "扫描仪",
  decontamination = utf8 "净化设备",
  pharmacy = utf8 "药房",
  cardiogram = utf8 "心电图仪",
  reception = utf8 "接待台",
  training_room = utf8 "培训室",
  corridor_objects = utf8 "走廊物品",
  operating_theatre = utf8 "手术中心",
  dna_fixer = utf8 "DNA修复装置",
  ward = utf8 "病房",
  psychiatric = utf8 "精神病诊疗室",
  hair_restoration = utf8 "毛发恢复机器",
  general_diag = utf8 "高级诊断室",
  inflation = utf8 "充气机",
  tongue_clinic = utf8 "舌头治疗机",
  toilets = utf8 "洗手间",
  electrolysis = utf8 "电分解诊所",
  x_ray = utf8 "X光仪器",
  blood_machine = utf8 "血液机器",
}
object = {
  chair = utf8 "椅子",
  litter = "Litter",
  sofa = utf8 "沙发",
  operating_table = utf8 "手术台",
  bed2 = utf8 "床",
  bench = utf8 "长椅",
  scanner = utf8 "扫描仪",
  couch = utf8 "长沙发椅",
  blood_machine = utf8 "血液机器",
  table1 = utf8 "桌子",
  video_game = utf8 "电视游戏",
  lamp = utf8 "灯",
  op_sink2 = utf8 "洗手池",
  door = utf8 "房门",
  auto_autopsy = utf8 "自动验尸仪",
  reception_desk = utf8 "接待台",
  hair_restorer = utf8 "毛发恢复机",
  projector = utf8 "放映机",
  crash_trolley = utf8 "诊断仪器小推车",
  tv = utf8 "电视机",
  ultrascanner = utf8 "超级扫描仪",
  surgeon_screen = utf8 "外科屏风",
  litter_bomb = utf8 "垃圾炸弹",
  inflator = utf8 "充气机",
  table2 = utf8 "桌子",
  desk = utf8 "办公桌",
  pool_table = utf8 "台球桌",
  x_ray_viewer = utf8 "X光透视仪",
  radiation_shield = utf8 "射线防护",
  bed = utf8 "床",
  swing_door2 = utf8 "转门",
  console = utf8 "控制台",
  op_sink1 = utf8 "洗手池",
  bookcase = utf8 "书柜",
  drinks_machine = utf8 "饮料机",
  comfortable_chair = utf8 "舒适座椅",
  skeleton = utf8 "骨骼模型",
  computer = utf8 "计算机",
  bin = utf8 "垃圾桶",
  pharmacy_cabinet = utf8 "医药柜",
  radiator = utf8 "暖气",
  cast_remover = utf8 "石膏剥离装置",
  atom_analyser = utf8 "原子分析仪",
  plant = utf8 "植物",
  jelly_moulder = utf8 "胶桶",
  cardio = utf8 "心电图仪",
  toilet = utf8 "厕所",
  electrolyser = utf8 "电分解机器",
  fire_extinguisher = utf8 "灭火器",
  bed3 = utf8 "床",
  swing_door1 = utf8 "转门",
  lecture_chair = utf8 "演讲座位",
  screen = utf8 "屏风",
  toilet_sink = utf8 "洗手池",
  shower = utf8 "淋浴",
  gates_of_hell = utf8 "地狱之门",
  entrance_right = utf8 "左入口",
  entrance_left = utf8 "右入口",
  slicer = utf8 "舌头治疗机",
  dna_fixer = utf8 "DNA修复装置",
  x_ray = utf8 "X光机",
  cabinet = utf8 "文件柜",
}
pay_rise = {
  definite_quit = utf8 "不论您做什么都无法留住我了。",
  regular = {
    [1] = utf8 "我真的太累了。如果您不希望我辞职的话，请让我好好休息，并增加工资%d。",
    [2] = utf8 "我真的太累了。我需要休息，以及增加工资%d。立即答应，你这个暴君。",
    [3] = utf8 "好吧。我在这里工作就象一只狗一样。给我奖金%d我就还留在这个医院里。",
    [4] = utf8 "我很不快乐。我要求增加工资%d，使我的工资达到%d，否则我就不干了。",
    [5] = utf8 "我的父母告诉我医学专家的待遇是很高的。因此，请给我加薪%d，否则我将辞职去做电脑游戏。",
    [6] = utf8 "我已经受够了。请调整我的工资到合理程度。我希望加薪%d。",
  },
  poached = utf8 "%s答应给我工资%d。如果您无法达到这个数目，那么我就要跳槽了。",
}
town_map = {
  number = utf8 "地区编号",
  not_for_sale = utf8 "非拥有的",
  chat = utf8 "城镇细节",
  price = utf8 "地区售价",
  for_sale = utf8 "出售",
  owner = utf8 "地区所有",
  area = utf8 "地区面积",
}
level_names = {
  [1] = utf8 "毒气城",
  [2] = utf8 "昏睡城",
  [3] = utf8 "大柴斯特城",
  [4] = utf8 "福来明顿城",
  [5] = utf8 "新普顿城",
  [6] = utf8 "世界之疮",
  [7] = utf8 "绿池城",
  [8] = utf8 "曼葵城",
  [9] = utf8 "依斯特威尔",
  [10] = utf8 "爱格森海姆城",
  [11] = utf8 "蛙鸣城",
  [12] = utf8 "巴登堡",
  [13] = utf8 "查姆雷城",
  [14] = utf8 "小爪槟城",
  [15] = utf8 "葬礼城",
}
build_room_window = {
  pick_room_type = utf8 "选择房间类型",
  pick_department = utf8 "选择部门",
  cost = utf8 "花费：",
}
insurance_companies = {
  [1] = utf8 "天鹅绒有限公司",
  [2] = utf8 "诺福克洋葱公司",
  [3] = utf8 "双峰公司",
  [4] = utf8 "刀疤有限公司",
  [5] = utf8 "潜水艇有限公司",
  [6] = utf8 "诚实的泰瑞公司",
  [7] = utf8 "矮胖先生股份有限公司",
  [8] = utf8 "里昂猫公司",
  [9] = utf8 "普里邦有限公司",
  [10] = utf8 "快乐保险公司",
  [11] = utf8 "辛迪加保险公司",
  out_of_business = utf8 "无",
}
