#!/usr/bin/env python2.5
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA  02110-1301, USA.
#

from distutils.core import setup

# files to install
inst_desktop = ['copernicium.desktop']
inst_py = ['copernicium.py', 'listas.py', 'molmass.py']
pixmaps = ['pixmaps/about.png']
inst_dbus = ['copernicium.service']
inst_icon = ['copernicium.png']
inst_icon_sca = ['pixmaps/copernicium.png']
sh_bin = ['copernicium']

data_files = [
  ('share/applications/hildon', inst_desktop),
  ('/opt/copernicium',   inst_py),
  ('/opt/copernicium/pixmaps',   pixmaps),
  ('share/icons/hicolor/26x26/hildon/',   inst_icon),
  ('share/icons/hicolor/scalable/hildon/',   inst_icon_sca),
  ('share/dbus-1/services',   inst_dbus),
]


setup(
  name         = 'copernicium',
  version      = '1.4',
  description  = 'Periodic table',
  author       = 'Daniel Martin Yerga',
  author_email = 'dyerga@gmail.com',
  url          = 'https://garage.maemo.org/projects/maemo-periodic',
  data_files   = data_files,
  scripts      = sh_bin
)
