/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __MATCH_CELL_H__
#define __MATCH_CELL_H__

#include <gtk/gtk.h>


G_BEGIN_DECLS
 
#define TYPE_MATCH_CELL_RENDERER                    (match_cell_renderer_get_type ())
#define MATCH_CELL_RENDERER(obj)                    (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATCH_CELL_RENDERER, MatchCellRenderer))
#define MATCH_CELL_RENDERER_CLASS(klass)            (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATCH_CELL_RENDERER, MatchCellRendererClass))
#define IS_MATCH_CELL_RENDERER_PIXBUF(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATCH_CELL_RENDERER))
#define IS_MATCH_CELL_RENDERER_PIXBUF_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATCH_CELL_RENDERER))
#define MATCH_CELL_RENDERER_GET_CLASS(obj)          (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATCH_CELL_RENDERER, MatchCellRendererClass))

typedef struct _MatchCellRenderer        MatchCellRenderer;
typedef struct _MatchCellRendererClass   MatchCellRendererClass;
typedef struct _MatchCellRendererPrivate MatchCellRendererPrivate;

struct _MatchCellRenderer
{
    GtkCellRenderer parent;

    /*< private >*/
    MatchCellRendererPrivate *priv;
};

struct _MatchCellRendererClass
{
    GtkCellRendererClass parent_class;
};

GType            match_cell_renderer_get_type (void) G_GNUC_CONST;
GtkCellRenderer *match_cell_renderer_new      (void);

G_END_DECLS

#endif /* __MATCH_CELL_H__ */
