/*
 * Copyright (C) 2009-2010 Marco Barisione <marco@barisione.org>
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "config.h"

#include <libosso.h>

#include "debug.h"
#include "merger.h"
#include "merger-window.h"


int
main (int    argc,
      char **argv)
{
    osso_context_t *osso_cxt;
    OssoABookRoster *aggregator;
    GtkWidget *window;
    GError *error = NULL;

    osso_cxt = osso_initialize (argv[0], "0.1", FALSE, NULL);
    osso_abook_init (&argc, &argv, osso_cxt);

    DEBUG ("Starting");

    aggregator = osso_abook_aggregator_get_default (&error);
    if (!aggregator) {
        g_printerr ("Error getting the aggregator: %s\n",
            error ? error->message : "unknown error");
        g_clear_error (&error);
        return 1;
    }

    window = merger_window_new (OSSO_ABOOK_AGGREGATOR (aggregator));
    g_signal_connect (window, "destroy", G_CALLBACK (gtk_main_quit), NULL);
    gtk_widget_show (window);

    gtk_main ();

    return 0;
}
